/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.TableResource;

@SdkInternalApi
public class TableResourceMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<StructuredPojo> TABLEWILDCARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableWildcard").build();
    private static final TableResourceMarshaller instance = new TableResourceMarshaller();

    public static TableResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableResource tableResource, ProtocolMarshaller protocolMarshaller) {
        if (tableResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tableResource.getCatalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)tableResource.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)tableResource.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)tableResource.getTableWildcard(), TABLEWILDCARD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

