/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.DatabaseResource;
import com.amazonaws.services.lakeformation.model.LFTagPair;
import com.amazonaws.services.lakeformation.model.transform.TaggedDatabaseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaggedDatabase
implements Serializable,
Cloneable,
StructuredPojo {
    private DatabaseResource database;
    private List<LFTagPair> lFTags;

    public void setDatabase(DatabaseResource database) {
        this.database = database;
    }

    public DatabaseResource getDatabase() {
        return this.database;
    }

    public TaggedDatabase withDatabase(DatabaseResource database) {
        this.setDatabase(database);
        return this;
    }

    public List<LFTagPair> getLFTags() {
        return this.lFTags;
    }

    public void setLFTags(Collection<LFTagPair> lFTags) {
        if (lFTags == null) {
            this.lFTags = null;
            return;
        }
        this.lFTags = new ArrayList<LFTagPair>(lFTags);
    }

    public TaggedDatabase withLFTags(LFTagPair ... lFTags) {
        if (this.lFTags == null) {
            this.setLFTags(new ArrayList<LFTagPair>(lFTags.length));
        }
        for (LFTagPair ele : lFTags) {
            this.lFTags.add(ele);
        }
        return this;
    }

    public TaggedDatabase withLFTags(Collection<LFTagPair> lFTags) {
        this.setLFTags(lFTags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getLFTags() != null) {
            sb.append("LFTags: ").append(this.getLFTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaggedDatabase)) {
            return false;
        }
        TaggedDatabase other = (TaggedDatabase)obj;
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getLFTags() == null ^ this.getLFTags() == null) {
            return false;
        }
        return other.getLFTags() == null || other.getLFTags().equals(this.getLFTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getLFTags() == null ? 0 : this.getLFTags().hashCode());
        return hashCode;
    }

    public TaggedDatabase clone() {
        try {
            return (TaggedDatabase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaggedDatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

