/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.Column;
import cn.codeforfun.migrate.core.entity.structure.Database;
import cn.codeforfun.migrate.core.entity.structure.Key;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import cn.codeforfun.migrate.core.utils.ObjectUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Table
implements Serializable,
Difference {
    private static final long serialVersionUID = 411108952654575238L;
    @DbUtilProperty(value="TABLE_SCHEMA")
    private String schema;
    @DbUtilProperty(value="TABLE_NAME")
    private String name;
    @DbUtilProperty(value="TABLE_TYPE")
    private String type;
    @DbUtilProperty(value="ENGINE")
    private String engine;
    @DbUtilProperty(value="CREATE_TIME")
    private Timestamp createTime;
    @DbUtilProperty(value="UPDATE_TIME")
    private Timestamp updateTime;
    @DbUtilProperty(value="CHARACTER_SET_NAME")
    private String charset;
    @DbUtilProperty(value="TABLE_COLLATION")
    private String collate;
    @DbUtilProperty(value="TABLE_COMMENT")
    private String comment;
    private List<Column> columns;
    private List<Key> keys;
    private Database database;
    public static final String SQL = FileUtil.getStringByClasspath("sql/diff/create-table.sql");

    @JsonIgnore
    public String getDeleteForeignKeySql() {
        StringBuilder sb = new StringBuilder();
        for (Key key : this.keys) {
            if (key.getKeyType() != Key.KeyType.FOREIGN) continue;
            sb.append("ALTER TABLE `").append(key.getTableName()).append("` DROP FOREIGN KEY `").append(key.getName()).append("`;");
        }
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "DROP TABLE `" + this.name + "`;";
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        List<Key> primaryKeyList;
        String sql = SQL;
        sql = sql.replace("${tableName}", this.name);
        sql = sql.replace("${engine}", " ENGINE = " + this.engine);
        if (this.getDatabase().getInfo().getIgnoreCharacterCompare().booleanValue()) {
            sql = sql.replace("${charset}", "");
            sql = sql.replace("${collate}", "");
        } else {
            sql = sql.replace("${charset}", " DEFAULT CHARSET = " + this.charset);
            sql = sql.replace("${collate}", " COLLATE = " + this.collate);
        }
        sql = sql.replace("${comment}", ObjectUtils.isEmpty(this.comment) ? "" : " COMMENT = '" + this.comment + "'");
        StringBuilder sb = new StringBuilder();
        for (Column column : this.columns) {
            Iterator<Key> columnSql = column.getCreateTableSql();
            sb.append((String)((Object)columnSql));
        }
        List uniqueIndexList = this.keys.stream().filter(s -> s.getKeyType() == Key.KeyType.UNIQUE).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(uniqueIndexList)) {
            Map<String, List<Key>> tableList = uniqueIndexList.stream().collect(Collectors.groupingBy(Key::getTableName));
            if (!ObjectUtils.isEmpty(tableList)) {
                for (Map.Entry entry : tableList.entrySet()) {
                    Map<String, List<Key>> listMap = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(Key::getName));
                    if (ObjectUtils.isEmpty(listMap)) continue;
                    for (Map.Entry<String, List<Key>> j : listMap.entrySet()) {
                        sb.append("UNIQUE KEY `").append(j.getKey()).append("`(");
                        List columnList = j.getValue().stream().map(Key::getColumnName).collect(Collectors.toList());
                        if (!ObjectUtils.isEmpty(columnList)) {
                            for (String s2 : columnList) {
                                sb.append("`").append(s2).append("`, ");
                            }
                        }
                        sb.delete(sb.length() - 2, sb.length());
                        sb.append("),");
                    }
                }
            }
            this.keys.removeAll(uniqueIndexList);
        }
        if ((primaryKeyList = this.keys.stream().filter(k -> k.getKeyType() == Key.KeyType.PRIMARY).collect(Collectors.toList())).size() > 0) {
            sb.append("PRIMARY KEY (");
            primaryKeyList.forEach(k -> sb.append("`").append(k.getColumnName()).append("`,"));
            sb.delete(sb.length() - 1, sb.length());
            sb.append("),");
        }
        this.keys.removeAll(primaryKeyList);
        for (Key key : this.keys) {
            String keySql = key.getCreateTableSql();
            sb.append(keySql);
        }
        String splitStr = "#@#";
        Map<String, List<Key>> map = this.keys.stream().filter(k -> k.getKeyType() == Key.KeyType.OTHER).collect(Collectors.groupingBy(s -> s.getTableName() + "#@#" + s.getName()));
        if (!ObjectUtils.isEmpty(map)) {
            for (Map.Entry entry : map.entrySet()) {
                String keyName = ((String)entry.getKey()).split("#@#")[1];
                List columnNameList = ((List)entry.getValue()).stream().map(Key::getColumnName).collect(Collectors.toList());
                sb.append("KEY `").append(keyName).append("` (");
                for (String s2 : columnNameList) {
                    sb.append("`").append(s2).append("`, ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("),");
            }
        }
        String columnSql = sb.substring(0, sb.length() - 1);
        sql = sql.replace("${columnSql}", columnSql);
        return sql;
    }

    public static List<Table> configure(Connection connection, Database database) throws SQLException {
        List<Table> list1 = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/table.sql"), Table.class, database.getInfo().getName());
        List<Column> list2 = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/column.sql"), Column.class, database.getInfo().getName());
        List<Key> list3 = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/key.sql"), Key.class, database.getInfo().getName());
        return list1.stream().peek(o -> {
            o.setDatabase(database);
            o.setColumns(list2.stream().peek(s -> s.setTable((Table)o)).filter(s -> o.getName().equals(s.getTableName())).collect(Collectors.toList()));
            o.setKeys(list3.stream().peek(s -> s.setTable((Table)o)).filter(s -> o.getName().equals(s.getTableName())).collect(Collectors.toList()));
        }).collect(Collectors.toList());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getEngine() {
        return this.engine;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Timestamp updateTime) {
        this.updateTime = updateTime;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setKeys(List<Key> keys) {
        this.keys = keys;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }
}

