/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.Database;
import cn.codeforfun.migrate.core.entity.structure.Routine;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import cn.codeforfun.migrate.core.utils.ObjectUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Function
implements Serializable,
Difference {
    private static final long serialVersionUID = -1055838976379808321L;
    private String securityType;
    private String definer;
    private String schema;
    private String name;
    private String source;
    private Database database;
    private List<Routine> routines = new ArrayList<Routine>();

    public static List<Function> configure(Connection connection, Database database) throws SQLException {
        List<Routine> beanList = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/function.sql"), Routine.class, database.getInfo().getName());
        HashMap<String, Function> functions = new HashMap<String, Function>(0);
        for (Routine routine : beanList) {
            Function function = (Function)functions.get(routine.getName());
            if (function == null) {
                function = new Function();
            }
            function.setDatabase(database);
            function.getRoutines().add(routine);
            function.setDefiner(routine.getDefiner());
            function.setSecurityType(routine.getSecurityType());
            function.setSchema(routine.getSchema());
            function.setName(routine.getName());
            function.setSource(routine.getSource());
            functions.put(routine.getName(), function);
        }
        return new ArrayList<Function>(functions.values());
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE FUNCTION `").append(this.name).append("`");
        sb.append("(");
        List inputTypeList = this.getRoutines().stream().filter(s -> "IN".equals(s.getParamMode())).collect(Collectors.toList());
        List resultTypeList = this.getRoutines().stream().filter(s -> null == s.getParamMode()).collect(Collectors.toList());
        for (Routine param : inputTypeList) {
            sb.append(param.getParamName()).append(" ").append(param.getResultType()).append(",");
        }
        sb = new StringBuilder(sb.substring(0, sb.length() - 1));
        sb.append(") ");
        sb.append(" RETURNS ");
        Routine param = (Routine)resultTypeList.get(0);
        sb.append(param.getResultType());
        if (!ObjectUtils.isEmpty(param.getCharacter()) && !ObjectUtils.isEmpty(param.getCollation())) {
            sb.append(" CHARSET ").append(param.getCharacter()).append(" COLLATE ").append(param.getCollation());
        }
        sb.append(" ").append(this.source).append(";");
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "DROP FUNCTION `" + this.name + "`;";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Function)) {
            return false;
        }
        Function function = (Function)o;
        return Objects.equals(this.getName(), function.getName()) && Objects.equals(this.getSource(), function.getSource()) && Objects.equals(this.getRoutines(), function.getRoutines());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getSource(), this.getRoutines());
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getDefiner() {
        return this.definer;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public Database getDatabase() {
        return this.database;
    }

    public List<Routine> getRoutines() {
        return this.routines;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setRoutines(List<Routine> routines) {
        this.routines = routines;
    }
}

