/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.entity.DatabaseInfo;
import cn.codeforfun.migrate.core.entity.structure.Function;
import cn.codeforfun.migrate.core.entity.structure.Procedure;
import cn.codeforfun.migrate.core.entity.structure.Table;
import cn.codeforfun.migrate.core.entity.structure.Trigger;
import cn.codeforfun.migrate.core.entity.structure.View;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class Database {
    private DatabaseInfo info;
    @JsonIgnore
    private Connection connection;
    @DbUtilProperty(value="SCHEMA_NAME")
    private String name;
    @DbUtilProperty(value="DEFAULT_CHARACTER_SET_NAME")
    private String character;
    @DbUtilProperty(value="DEFAULT_COLLATION_NAME")
    private String collate;
    private List<Table> tables;
    private List<View> views;
    private List<Function> functions;
    private List<Procedure> procedures;
    private List<Trigger> triggers;
    public static final String SQL = FileUtil.getStringByClasspath("sql/detail/database.sql");

    public Database init(DatabaseInfo info) throws SQLException {
        this.info = info;
        this.connection = DbUtil.getConnection(info.getUrl(), info.getUsername(), info.getPassword());
        return this.configure();
    }

    private Database configure() throws SQLException {
        Database bean = DbUtil.getBean(this.connection, SQL, Database.class, this.info.getName());
        bean.setTables(Table.configure(this.connection, this));
        bean.setViews(View.configure(this.connection, this));
        bean.setFunctions(Function.configure(this.connection, this));
        bean.setProcedures(Procedure.configure(this.connection, this));
        bean.setTriggers(Trigger.configure(this.connection, this));
        bean.setInfo(this.info);
        bean.setConnection(this.connection);
        return bean;
    }

    public DatabaseInfo getInfo() {
        return this.info;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getName() {
        return this.name;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getCollate() {
        return this.collate;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<View> getViews() {
        return this.views;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public List<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setInfo(DatabaseInfo info) {
        this.info = info;
    }

    @JsonIgnore
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public void setTables(List<Table> tables) {
        this.tables = tables;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public void setProcedures(List<Procedure> procedures) {
        this.procedures = procedures;
    }

    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }
}

