/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.docker;

import cloud.localstack.Localstack;
import cloud.localstack.docker.annotation.LocalstackDockerAnnotationProcessor;
import cloud.localstack.docker.annotation.LocalstackDockerConfiguration;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class LocalstackDockerExtension
implements BeforeAllCallback {
    private static final LocalstackDockerAnnotationProcessor PROCESSOR = new LocalstackDockerAnnotationProcessor();
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{LocalstackDockerExtension.class});

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = this.isUseSingleDockerContainer(context) ? context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL) : context.getStore(NAMESPACE);
        store.getOrComputeIfAbsent((Object)"localstack", key -> new StartedLocalStack(context));
    }

    private boolean isUseSingleDockerContainer(ExtensionContext context) {
        return PROCESSOR.process(context.getRequiredTestClass()).isUseSingleDockerContainer();
    }

    static class StartedLocalStack
    implements ExtensionContext.Store.CloseableResource {
        private Localstack localstackDocker = Localstack.INSTANCE;

        StartedLocalStack(ExtensionContext context) {
            LocalstackDockerConfiguration dockerConfig = PROCESSOR.process(context.getRequiredTestClass());
            this.localstackDocker.startup(dockerConfig);
        }

        public void close() throws Throwable {
            this.localstackDocker.stop();
        }
    }
}

