/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LambdaContext;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class LambdaExecutor {
    public static void main(String[] args) throws Exception {
        Map event;
        RequestHandler handler;
        Class<?> clazz;
        if (args.length < 2) {
            System.err.println("Usage: java " + LambdaExecutor.class.getSimpleName() + " <lambdaClass> <recordsFilePath>");
            System.exit(1);
        }
        String fileContent = LambdaExecutor.readFile(args[1]);
        ObjectMapper reader = new ObjectMapper();
        Map map = (Map)reader.reader(Map.class).readValue(fileContent);
        List records = (List)LambdaExecutor.get(map, "Records");
        if (records != null) {
            clazz = Class.forName(args[0]);
            handler = (RequestHandler)clazz.newInstance();
            KinesisEvent kinesisEvent = new KinesisEvent();
            event = kinesisEvent;
            kinesisEvent.setRecords(new LinkedList());
            for (Map record : records) {
                KinesisEvent.KinesisEventRecord r = new KinesisEvent.KinesisEventRecord();
                kinesisEvent.getRecords().add(r);
                KinesisEvent.Record kinesisRecord = new KinesisEvent.Record();
                Map kinesis = (Map)LambdaExecutor.get(record, "Kinesis");
                kinesisRecord.setData(ByteBuffer.wrap(LambdaExecutor.get(kinesis, "Data").toString().getBytes()));
                kinesisRecord.setPartitionKey((String)LambdaExecutor.get(kinesis, "PartitionKey"));
                kinesisRecord.setApproximateArrivalTimestamp(new Date());
                r.setKinesis(kinesisRecord);
            }
        } else {
            clazz = Class.forName(args[0]);
            handler = (RequestHandler)clazz.newInstance();
            event = map;
        }
        LambdaContext ctx = new LambdaContext();
        Object result = handler.handleRequest((Object)event, (Context)ctx);
        System.out.println(result);
    }

    private static <T> T get(Map<String, T> map, String key) {
        T result = map.get(key);
        if (result != null) {
            return result;
        }
        result = map.get(key = StringUtils.uncapitalize((String)key));
        if (result != null) {
            return result;
        }
        return map.get(key.toLowerCase());
    }

    private static String readFile(String file) throws Exception {
        if (!file.startsWith("/")) {
            file = System.getProperty("user.dir") + "/" + file;
        }
        return FileUtils.readFileToString((File)new File(file), (Charset)Charsets.UTF_8);
    }
}

