/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.ArrayList;
import java.util.List;

public class URLEvaluator
extends ContextAwareBase
implements EventEvaluator,
LifeCycle {
    boolean started;
    String name;
    private List<String> URLList = new ArrayList<String>();

    public void addURL(String url) {
        this.URLList.add(url);
    }

    public void start() {
        if (this.URLList.size() == 0) {
            this.addWarn("No URL was given to URLEvaluator");
        } else {
            this.started = true;
        }
    }

    public boolean evaluate(Object eventObject) throws NullPointerException, EvaluationException {
        AccessEvent event = (AccessEvent)eventObject;
        String url = event.getRequestURL();
        for (String expected : this.URLList) {
            if (!url.contains(expected)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.started = false;
    }
}

