/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import com.fasterxml.jackson.databind.JavaType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeRegistry {
    private static final Logger log = LoggerFactory.getLogger(TypeRegistry.class);
    private Set<JavaType> visited = new HashSet<JavaType>();

    public TypeRegistry(JavaType baseType) {
        this.visited.add(baseType);
    }

    public TypeRegistry(Collection<JavaType> visited) {
        this.visited.addAll(visited);
    }

    public TypeRegistry withVisitedTypes(List<JavaType> javaTypes) {
        HashSet<JavaType> result = new HashSet<JavaType>(this.visited);
        result.addAll(javaTypes);
        return new TypeRegistry(result);
    }

    public boolean wasVisited(JavaType type) {
        log.trace(" - WAS VISITED? {}", (Object)type.getRawClass().getSimpleName());
        for (JavaType t : this.visited) {
            if (t.getRawClass().equals(type.getRawClass())) {
                log.trace("   - YES {}", (Object)t.getRawClass().getSimpleName());
                return true;
            }
            log.trace("   - NO {}", (Object)t.getRawClass().getSimpleName());
        }
        return false;
    }
}

