/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SnippetTranslationResolver {
    private static ResourceBundle defaultMessages = SnippetTranslationResolver.getBundle("DefaultSnippetMessages");
    private static ResourceBundle userMessages = SnippetTranslationResolver.getBundle("SnippetMessages");

    private static ResourceBundle getBundle(String name) {
        try {
            return ResourceBundle.getBundle(SnippetTranslationResolver.class.getPackage().getName() + "." + name, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static String translate(String key, Object ... args) {
        try {
            if (userMessages != null) {
                return SnippetTranslationResolver.format(userMessages.getString(key), args);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return SnippetTranslationResolver.format(defaultMessages.getString(key), args);
    }

    static void setUserMessages(String name) {
        userMessages = SnippetTranslationResolver.getBundle(name);
    }

    private static String format(String message, Object[] args) {
        return new MessageFormat(message).format(args);
    }
}

