/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.MethodParameterConstraintResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ValidatorConstraintResolver;
import org.springframework.util.ClassUtils;

public class MethodParameterValidatorConstraintResolver
extends ValidatorConstraintResolver
implements MethodParameterConstraintResolver {
    static Class<Annotation> CONSTRAINT_CLASS;

    @Override
    public List<Constraint> resolveForParameter(MethodParameter param) {
        if (CONSTRAINT_CLASS == null) {
            return Collections.emptyList();
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (Annotation annot : param.getParameterAnnotations()) {
            Class<? extends Annotation> type = annot.annotationType();
            if (type.getAnnotation(CONSTRAINT_CLASS) == null) continue;
            Constraint constraint = this.createConstraint(annot, type);
            constraints.add(constraint);
        }
        return constraints;
    }

    private Constraint createConstraint(Annotation annot, Class<? extends Annotation> type) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        for (Method method : type.getDeclaredMethods()) {
            String methodName = method.getName();
            Object value = this.getAnnotValue(annot, method);
            configuration.put(methodName, value);
        }
        return new Constraint(type.getName(), configuration);
    }

    private Object getAnnotValue(Annotation annot, Method method) {
        try {
            return method.invoke((Object)annot, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            CONSTRAINT_CLASS = ClassUtils.forName((String)"javax.validation.Constraint", (ClassLoader)MethodParameterValidatorConstraintResolver.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

