/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.utils;

import blue.contract.packager.model.BluePackage;
import blue.contract.utils.PackagingUtils;
import blue.language.model.Node;
import blue.language.utils.BlueIdCalculator;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.UncheckedObjectMapper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class RepositoryExportingTool {
    public static final String TARGET_DIR = "src/main/resources/blue-preprocessed";
    public static final String PACKAGE_BLUE = "package.blue";
    public static final String BLUE_IDS_YAML = "blue-ids.yaml";
    private final PackagingUtils.ClasspathBasedPackagingEnvironment env;
    private CompletableFuture<Void> exportFuture;

    public RepositoryExportingTool(PackagingUtils.ClasspathBasedPackagingEnvironment env) {
        this.env = env;
    }

    public void exportRepository() throws IOException {
        this.deleteAndRecreateTargetDir();
        HashMap<String, String> mainBlueIds = new HashMap<String, String>();
        for (Map.Entry<String, BluePackage> entry : this.env.getPackageMap().entrySet()) {
            String packageName = entry.getKey();
            BluePackage bluePackage = entry.getValue();
            Path packageDir = Paths.get(TARGET_DIR, bluePackage.getDirectoryName());
            Files.createDirectories(packageDir, new FileAttribute[0]);
            Node packageContent = bluePackage.getPackageContent();
            this.exportPackageContent(packageDir, packageContent);
            Map<String, String> packageBlueIds = this.createBlueIdsYaml(packageDir, packageContent);
            String packageBlueId = BlueIdCalculator.calculateBlueId((Node)packageContent);
            mainBlueIds.put(bluePackage.getDirectoryName(), packageBlueId);
            for (Map.Entry<String, Node> nodeEntry : bluePackage.getPreprocessedNodes().entrySet()) {
                String nodeName = nodeEntry.getKey();
                Node node = nodeEntry.getValue();
                String yamlContent = UncheckedObjectMapper.YAML_MAPPER.writeValueAsString(NodeToMapListOrValue.get((Node)node));
                String sanitizedNodeName = this.sanitizeName(nodeName);
                Path filePath = packageDir.resolve(sanitizedNodeName + ".blue");
                Files.writeString(filePath, (CharSequence)yamlContent, new OpenOption[0]);
            }
        }
        this.createMainBlueIdsYaml(Paths.get(TARGET_DIR, new String[0]), mainBlueIds);
    }

    private void exportPackageContent(Path packageDir, Node packageContent) throws IOException {
        String yamlContent = UncheckedObjectMapper.YAML_MAPPER.writeValueAsString(NodeToMapListOrValue.get((Node)packageContent));
        Path filePath = packageDir.resolve(PACKAGE_BLUE);
        Files.writeString(filePath, (CharSequence)yamlContent, new OpenOption[0]);
    }

    private Map<String, String> createBlueIdsYaml(Path packageDir, Node packageContent) throws IOException {
        HashMap<String, String> blueIds = new HashMap<String, String>();
        if (packageContent.getItems() != null && packageContent.getItems().size() > 1) {
            Node mappingsNode;
            Node secondItem = (Node)packageContent.getItems().get(1);
            Node node = mappingsNode = secondItem.getProperties() != null ? (Node)secondItem.getProperties().get("mappings") : null;
            if (mappingsNode != null && mappingsNode.getProperties() != null) {
                for (Map.Entry mapping : mappingsNode.getProperties().entrySet()) {
                    String key = (String)mapping.getKey();
                    String value = (String)((Node)mapping.getValue()).getValue();
                    blueIds.put(key, value);
                }
            }
        }
        String yamlContent = UncheckedObjectMapper.YAML_MAPPER.writeValueAsString(blueIds);
        Path yamlPath = packageDir.resolve(BLUE_IDS_YAML);
        Files.writeString(yamlPath, (CharSequence)yamlContent, new OpenOption[0]);
        return blueIds;
    }

    private void createMainBlueIdsYaml(Path targetDir, Map<String, String> blueIds) throws IOException {
        String yamlContent = UncheckedObjectMapper.YAML_MAPPER.writeValueAsString(blueIds);
        Path yamlPath = targetDir.resolve(BLUE_IDS_YAML);
        Files.writeString(yamlPath, (CharSequence)yamlContent, new OpenOption[0]);
    }

    private String sanitizeName(String name) {
        return name.replaceAll("\\s+", "");
    }

    private void deleteAndRecreateTargetDir() throws IOException {
        Path targetPath = Paths.get(TARGET_DIR, new String[0]);
        if (Files.exists(targetPath, new LinkOption[0])) {
            Files.walk(targetPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        Files.createDirectories(targetPath, new FileAttribute[0]);
    }

    public CompletableFuture<Void> exportRepositoryAsync() {
        this.exportFuture = CompletableFuture.runAsync(() -> {
            try {
                this.exportRepository();
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
        return this.exportFuture;
    }

    public boolean isExportComplete() {
        return this.exportFuture != null && this.exportFuture.isDone();
    }
}

