/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.utils;

import blue.contract.model.WorkflowProcessingContext;
import blue.contract.utils.JSExecutor;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ExpressionEvaluator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^\\$\\{(.+)\\}$");
    private final JSExecutor jsExecutor;

    public ExpressionEvaluator(JSExecutor jsExecutor) {
        this.jsExecutor = jsExecutor;
    }

    public Object evaluate(String expression, WorkflowProcessingContext context, ExpressionScope scope, boolean resolveFinalLink) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        if (matcher.matches()) {
            String jsExpression = matcher.group(1);
            return this.evaluateJSExpression(jsExpression, context, scope, resolveFinalLink);
        }
        return expression;
    }

    private Object evaluateJSExpression(String jsExpression, WorkflowProcessingContext context, ExpressionScope scope, boolean resolveFinalLink) {
        Map<String, Object> bindings = this.createBindings(context, scope, resolveFinalLink);
        try {
            return this.jsExecutor.executeExpression(jsExpression, bindings);
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating JS expression: " + jsExpression, e);
        }
    }

    public Object evaluateIfExpression(Object potentialExpression, WorkflowProcessingContext context, ExpressionScope scope, boolean resolveFinalLink) {
        String strExpression;
        Matcher matcher;
        if (potentialExpression instanceof String && (matcher = EXPRESSION_PATTERN.matcher(strExpression = (String)potentialExpression)).matches()) {
            String jsExpression = matcher.group(1);
            return this.evaluateJSExpression(jsExpression, context, scope, resolveFinalLink);
        }
        return potentialExpression;
    }

    public Node processNodeRecursively(Node node, WorkflowProcessingContext context, ExpressionScope scope, boolean resolveFinalLink) {
        Node processedNode;
        if (node == null) {
            return null;
        }
        Object evaluatedValue = this.evaluateIfExpression(node.getValue(), context, scope, resolveFinalLink);
        if (evaluatedValue instanceof Node) {
            processedNode = (Node)evaluatedValue;
        } else {
            processedNode = node.clone();
            processedNode.value(evaluatedValue);
        }
        processedNode.name(this.evaluateStringField("name", node.getName(), context, scope, resolveFinalLink));
        processedNode.description(this.evaluateStringField("description", node.getDescription(), context, scope, resolveFinalLink));
        processedNode.blueId(this.evaluateStringField("blueId", node.getBlueId(), context, scope, resolveFinalLink));
        if (node.getItems() != null) {
            List processedItems = node.getItems().stream().map(item -> this.processNodeRecursively((Node)item, context, scope, resolveFinalLink)).collect(Collectors.toList());
            processedNode.items(processedItems);
        }
        if (node.getProperties() != null) {
            HashMap<String, Node> processedProperties = new HashMap<String, Node>();
            for (Map.Entry entry : node.getProperties().entrySet()) {
                String key = (String)this.evaluateIfExpression(entry.getKey(), context, scope, resolveFinalLink);
                Node value = this.processNodeRecursively((Node)entry.getValue(), context, scope, resolveFinalLink);
                processedProperties.put(key, value);
            }
            processedNode.properties(processedProperties);
        }
        return processedNode;
    }

    private String evaluateStringField(String fieldName, Object fieldValue, WorkflowProcessingContext context, ExpressionScope scope, boolean resolveFinalLink) {
        Object evaluated = this.evaluateIfExpression(fieldValue, context, scope, resolveFinalLink);
        if (evaluated == null) {
            return null;
        }
        if (evaluated instanceof String) {
            return (String)evaluated;
        }
        if (evaluated instanceof Node && ((Node)evaluated).getValue() instanceof String) {
            return (String)((Node)evaluated).getValue();
        }
        throw new RuntimeException("Illegal expression result type for field '" + fieldName + "': " + evaluated.getClass() + ", \"" + evaluated + "\"");
    }

    private Map<String, Object> createBindings(WorkflowProcessingContext context, ExpressionScope scope, boolean resolveFinalLink) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        HashMap<String, Object> processedStepResults = new HashMap<String, Object>();
        if (context.getWorkflowInstance().getStepResults() != null) {
            for (Map.Entry<String, Object> entry : context.getWorkflowInstance().getStepResults().entrySet()) {
                Object value = entry.getValue();
                Blue blue = context.getContractProcessingContext().getBlue();
                processedStepResults.put(entry.getKey(), NodeToMapListOrValue.get((Node)blue.objectToNode(value)));
            }
        }
        bindings.put("steps", processedStepResults);
        if (context.getContractProcessingContext().getIncomingEvent() != null) {
            bindings.put("event", NodeToMapListOrValue.get((Node)context.getContractProcessingContext().getIncomingEvent(), (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        }
        if (scope == ExpressionScope.GLOBAL) {
            bindings.put("contract", path -> context.getContractProcessingContext().accessContract((String)path, true, resolveFinalLink));
        } else {
            bindings.put("contract", path -> context.getContractProcessingContext().accessContract((String)path, false, resolveFinalLink));
        }
        return bindings;
    }

    public static enum ExpressionScope {
        GLOBAL,
        CURRENT_CONTRACT;

    }
}

