/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.model.TimelineEntry;
import blue.contract.model.blink.InitiateTimelineAction;
import blue.contract.model.blink.SimulatorTimelineEntry;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.UncheckedObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class SimulatorMT {
    private final Map<String, Timeline> timelines = new ConcurrentHashMap<String, Timeline>();
    private final List<Subscription> subscriptions = new CopyOnWriteArrayList<Subscription>();
    private final AtomicInteger globalTickSequence = new AtomicInteger(0);
    private final Blue blue;
    private final ExecutorService executorService;

    public SimulatorMT(Blue blue) {
        this.blue = blue;
        this.executorService = Executors.newCachedThreadPool();
    }

    public String createTimeline(String owner) {
        System.out.println("Creating timeline for owner: " + owner);
        InitiateTimelineAction action = new InitiateTimelineAction().owner(owner);
        SimulatorTimelineEntry<Object> entry = ((SimulatorTimelineEntry)new SimulatorTimelineEntry().message(action)).tickSequence(this.globalTickSequence.getAndIncrement());
        String blueId = this.blue.calculateBlueId(entry);
        Timeline timeline = new Timeline(blueId);
        this.timelines.put(blueId, timeline);
        timeline.appendEntry(entry);
        System.out.println("Timeline created with ID: " + blueId);
        return blueId;
    }

    public String appendEntry(String timelineId, Object message) {
        return this.appendEntry(timelineId, null, message);
    }

    public String appendEntry(String timelineId, String threadId, Object message) {
        System.out.println("Appending entry to timeline: " + timelineId + ", thread: " + threadId);
        Timeline timeline = this.timelines.get(timelineId);
        if (timeline == null) {
            throw new IllegalArgumentException("Timeline with ID " + timelineId + " does not exist");
        }
        SimulatorTimelineEntry<Object> newEntry = this.createEntry(timelineId, threadId, message);
        timeline.appendEntry(newEntry);
        String blueId = this.blue.calculateBlueId(newEntry);
        System.out.println("Appended entry with ID: " + blueId);
        this.notifySubscribers(newEntry);
        return blueId;
    }

    private void notifySubscribers(SimulatorTimelineEntry<Object> entry) {
        for (Subscription subscription : this.subscriptions) {
            if (!subscription.filter.test(entry)) continue;
            subscription.consumer.accept(entry);
        }
    }

    private SimulatorTimelineEntry<Object> createEntry(String timelineId, String threadId, Object message) {
        Timeline timeline = this.timelines.get(timelineId);
        String prevEntryId = timeline.getLastEntryId();
        String threadPrev = threadId != null ? timeline.getLastThreadEntryId(threadId) : null;
        return ((SimulatorTimelineEntry)((SimulatorTimelineEntry)((SimulatorTimelineEntry)((SimulatorTimelineEntry)((SimulatorTimelineEntry)new SimulatorTimelineEntry().timeline(timelineId)).timelinePrev(prevEntryId)).thread(threadId)).threadPrev(threadPrev)).message(message)).tickSequence(this.globalTickSequence.getAndIncrement());
    }

    public void subscribe(Predicate<SimulatorTimelineEntry<Object>> filter, TimelineEntryConsumer consumer) {
        this.subscriptions.add(new Subscription(filter, consumer));
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public <T> T getMessageFromLastTimelineEntry(String timelineId, Class<T> clazz) {
        Timeline timeline = this.timelines.get(timelineId);
        if (timeline == null) {
            return null;
        }
        BlockingQueue<SimulatorTimelineEntry<Object>> eventQueue = timeline.getEventQueue();
        if (eventQueue.isEmpty()) {
            return null;
        }
        TimelineEntry lastEntry = null;
        for (SimulatorTimelineEntry simulatorTimelineEntry : eventQueue) {
            lastEntry = simulatorTimelineEntry;
        }
        if (lastEntry == null) {
            return null;
        }
        Object message = lastEntry.getMessage();
        if (message == null) {
            return null;
        }
        if (!clazz.isInstance(message)) {
            return null;
        }
        return clazz.cast(message);
    }

    public void save(String timelineId, int skipEntries, String directory, String filePrefix) throws IOException {
        Timeline timeline = this.timelines.get(timelineId);
        if (timeline == null) {
            throw new IllegalArgumentException("Timeline with ID " + timelineId + " does not exist");
        }
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        BlockingQueue<SimulatorTimelineEntry<Object>> eventQueue = timeline.getEventQueue();
        ArrayList<SimulatorTimelineEntry<Object>> entries = new ArrayList<SimulatorTimelineEntry<Object>>(eventQueue);
        for (int i = skipEntries; i < entries.size(); ++i) {
            SimulatorTimelineEntry entry = (SimulatorTimelineEntry)entries.get(i);
            Node entryNode = (Node)UncheckedObjectMapper.JSON_MAPPER.convertValue((Object)entry, Node.class);
            File outputFile = new File(directory + "/" + filePrefix + "_" + (i - skipEntries + 1) + "_entry.blue");
            UncheckedObjectMapper.YAML_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)entryNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        }
    }

    private class Timeline {
        private final String id;
        private final BlockingQueue<SimulatorTimelineEntry<Object>> eventQueue;
        private volatile String lastEntryId;
        private final Map<String, String> lastThreadEntryIds;

        public Timeline(String id) {
            this.id = id;
            this.eventQueue = new LinkedBlockingQueue<SimulatorTimelineEntry<Object>>();
            this.lastThreadEntryIds = new ConcurrentHashMap<String, String>();
        }

        public void appendEntry(SimulatorTimelineEntry<Object> entry) {
            this.eventQueue.offer(entry);
            this.lastEntryId = SimulatorMT.this.blue.calculateBlueId(entry);
            if (entry.getThread() != null) {
                this.lastThreadEntryIds.put(entry.getThread(), this.lastEntryId);
            }
        }

        public String getLastEntryId() {
            return this.lastEntryId;
        }

        public String getLastThreadEntryId(String threadId) {
            return this.lastThreadEntryIds.get(threadId);
        }

        public BlockingQueue<SimulatorTimelineEntry<Object>> getEventQueue() {
            return this.eventQueue;
        }
    }

    private static class Subscription {
        Predicate<SimulatorTimelineEntry<Object>> filter;
        TimelineEntryConsumer consumer;

        Subscription(Predicate<SimulatorTimelineEntry<Object>> filter, TimelineEntryConsumer consumer) {
            this.filter = filter;
            this.consumer = consumer;
        }
    }

    public static interface TimelineEntryConsumer {
        public void accept(SimulatorTimelineEntry<Object> var1);
    }
}

