/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.simulator;

import blue.contract.ContractProcessor;
import blue.contract.model.Contract;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.blink.SimulatorTimelineEntry;
import blue.contract.processor.StandardProcessorsProvider;
import blue.contract.simulator.SimulatorMT;
import blue.contract.simulator.utils.ContractRunnerSubscriptionUtils;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.UncheckedObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ContractRunnerMT {
    private final Blue blue;
    private final ContractProcessor contractProcessor;
    private final String initiateContractEntryBlueId;
    private final String initiateContractProcessingEntryBlueId;
    private List<ContractUpdateAction> contractUpdateActions = new CopyOnWriteArrayList<ContractUpdateAction>();
    private SimulatorMT simulator;
    private volatile boolean isRunning = true;
    private final BlockingQueue<Node> eventQueue;
    private Thread processingThread;
    private String runnerTimeline;

    public ContractRunnerMT(Blue blue, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        StandardProcessorsProvider provider = new StandardProcessorsProvider(blue);
        this.blue = blue;
        this.contractProcessor = new ContractProcessor(provider, blue);
        this.initiateContractEntryBlueId = initiateContractEntryBlueId;
        this.initiateContractProcessingEntryBlueId = initiateContractProcessingEntryBlueId;
        this.eventQueue = new LinkedBlockingQueue<Node>();
        this.processingThread = new Thread(this::processEvents);
        this.processingThread.start();
    }

    public List<ContractUpdateAction> initiateContract(Object contract) {
        return this.initiateContract(this.blue.objectToNode(contract));
    }

    public List<ContractUpdateAction> initiateContract(Node contract) {
        return this.contractProcessor.initiate(contract, this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId);
    }

    public ContractUpdateAction getLastContractUpdate() {
        if (this.contractUpdateActions.isEmpty()) {
            return null;
        }
        return this.contractUpdateActions.get(this.contractUpdateActions.size() - 1);
    }

    public void startProcessingContract(Contract contract, String runnerTimeline, SimulatorMT simulator) {
        this.simulator = simulator;
        this.runnerTimeline = runnerTimeline;
        simulator.subscribe(entry -> ContractRunnerSubscriptionUtils.createContractFilterForSimulatorMT(contract, this.initiateContractEntryBlueId, runnerTimeline, simulator, this.blue).test((SimulatorTimelineEntry<Object>)entry), entry -> {
            try {
                ArrayList<Node> events = new ArrayList<Node>();
                if (this.initiateContractEntryBlueId.equals(entry.getThread())) {
                    events.add(this.blue.objectToNode((Object)entry));
                } else {
                    ContractUpdateAction action = (ContractUpdateAction)entry.getMessage();
                    if (action.getEmittedEvents() != null) {
                        events.addAll(action.getEmittedEvents());
                    }
                }
                for (Node event : events) {
                    this.eventQueue.put(event);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        List<ContractUpdateAction> actions = this.initiateContract(contract);
        this.contractUpdateActions.addAll(actions);
        actions.forEach(action -> simulator.appendEntry(runnerTimeline, this.initiateContractProcessingEntryBlueId, action));
    }

    private void processEvents() {
        while (this.isRunning || !this.eventQueue.isEmpty()) {
            try {
                Node event = this.eventQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (event == null) continue;
                this.processContractEvent(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private void processContractEvent(Node event) {
        System.out.println("ContractRunner is processing new contract event");
        ContractUpdateAction lastUpdate = this.getLastContractUpdate();
        int epoch = lastUpdate != null ? lastUpdate.getEpoch() : 0;
        List<ContractUpdateAction> result = this.contractProcessor.processEvent(event.clone(), lastUpdate != null ? (ContractInstance)this.blue.clone((Object)lastUpdate.getContractInstance()) : null, this.initiateContractEntryBlueId, this.initiateContractProcessingEntryBlueId, epoch + 1);
        System.out.println("Event processed. Number of new update actions: " + result.size());
        this.contractUpdateActions.addAll(result);
        result.forEach(action -> this.simulator.appendEntry(this.runnerTimeline, this.initiateContractProcessingEntryBlueId, action));
    }

    public void stop() throws InterruptedException {
        this.isRunning = false;
        this.processingThread.join(5000L);
        System.out.println("ContractRunnerMT stopped");
    }

    public void save(String directory, String filePrefix) throws IOException {
        for (int i = 0; i < this.contractUpdateActions.size(); ++i) {
            ContractUpdateAction contractUpdateAction = this.contractUpdateActions.get(i);
            Node contractUpdateNode = (Node)UncheckedObjectMapper.JSON_MAPPER.convertValue((Object)contractUpdateAction, Node.class);
            File outputFile = new File(directory + "/" + filePrefix + "_" + (i + 1) + "_update.blue");
            UncheckedObjectMapper.YAML_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)contractUpdateNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
            Node contractInstanceNode = contractUpdateNode.getAsNode("/contractInstance");
            outputFile = new File(directory + "/" + filePrefix + "_" + (i + 1) + "_contractInstance.json");
            UncheckedObjectMapper.JSON_MAPPER.writeValue(outputFile, NodeToMapListOrValue.get((Node)contractInstanceNode, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        }
    }
}

