/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.processor;

import blue.contract.AbstractStepProcessor;
import blue.contract.WorkflowProcessor;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.utils.ExpressionEvaluator;
import blue.contract.utils.JSExecutor;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WorkflowFunctionStepProcessor
extends AbstractStepProcessor {
    private JSExecutor jsExecutor;

    public WorkflowFunctionStepProcessor(Node step, ExpressionEvaluator expressionEvaluator, JSExecutor jsExecutor) {
        super(step, expressionEvaluator);
        this.jsExecutor = jsExecutor;
    }

    public WorkflowFunctionStepProcessor(Node step, ExpressionEvaluator expressionEvaluator) {
        super(step, expressionEvaluator);
    }

    @Override
    public Optional<WorkflowInstance> executeHandleStep(Node event, WorkflowProcessingContext context) {
        ProcessingResult result = null;
        try {
            result = this.processEvent(event, context, WorkflowProcessor.ProcessingMode.HANDLE);
        }
        catch (JSExecutor.JSException ex) {
            return this.processJSException(ex, context);
        }
        if (result == ProcessingResult.FINISHED) {
            return this.handleNextStepByOrder(event, context);
        }
        if (result == ProcessingResult.CONTINUE) {
            return Optional.of(context.getWorkflowInstance());
        }
        return Optional.empty();
    }

    @Override
    public Optional<WorkflowInstance> executeFinalizeStep(Node event, WorkflowProcessingContext context) {
        ProcessingResult result = null;
        try {
            result = this.processEvent(event, context, WorkflowProcessor.ProcessingMode.FINALIZE);
        }
        catch (JSExecutor.JSException ex) {
            return this.processJSException(ex, context);
        }
        if (result == ProcessingResult.FINISHED) {
            return this.finalizeNextStepByOrder(event, context);
        }
        if (result == ProcessingResult.CONTINUE) {
            WorkflowInstance workflowInstance = context.getWorkflowInstance();
            workflowInstance.currentStepName(this.step.getName());
            return Optional.of(context.getWorkflowInstance());
        }
        return Optional.empty();
    }

    private ProcessingResult processEvent(Node event, WorkflowProcessingContext context, WorkflowProcessor.ProcessingMode mode) throws JSExecutor.JSException {
        WorkflowInstance workflowInstance = context.getWorkflowInstance();
        if (!workflowInstance.hasNestedWorkflowInstance()) {
            Node subflowDefinition = this.generateSubflowDefinition(event, context);
            WorkflowInstance nestedInstance = new WorkflowInstance(subflowDefinition);
            nestedInstance.workflow(new Node().properties("steps", subflowDefinition));
            nestedInstance.currentStepName((String)subflowDefinition.get("/0/name"));
            nestedInstance.id(workflowInstance.getId());
            workflowInstance.nestedWorkflowInstance(nestedInstance);
        }
        return this.processNestedWorkflow(event, context, mode);
    }

    private Node generateSubflowDefinition(Node event, WorkflowProcessingContext context) throws JSExecutor.JSException {
        Node node = (Node)this.step.getProperties().get("initiateStepsCode");
        if (node == null) {
            throw new IllegalArgumentException("Attribute \"initiateStepsCode\" is required for Workflow Functions.");
        }
        String code = (String)node.getValue();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("event", NodeToMapListOrValue.get((Node)event, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        bindings.put("steps", context.getWorkflowInstance().getStepResults());
        bindings.put("functionStep", NodeToMapListOrValue.get((Node)this.step, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        bindings.put("contract", path -> context.getContractProcessingContext().accessContract((String)path, true, true));
        try {
            Object result = this.jsExecutor.executeScript(code, bindings);
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                if (!resultMap.containsKey("steps")) {
                    throw new IllegalArgumentException("\"initiateStepsCode\" did not return any steps.");
                }
                return context.getContractProcessingContext().getBlue().objectToNode(resultMap.get("steps"));
            }
            throw new IllegalArgumentException("Unexpected result type from JavaScript execution: " + result.getClass());
        }
        catch (JSExecutor.JSCriticalException e) {
            throw new IllegalArgumentException("Error executing JS script", e);
        }
    }

    private ProcessingResult processNestedWorkflow(Node event, WorkflowProcessingContext context, WorkflowProcessor.ProcessingMode mode) {
        WorkflowInstance workflowInstance = context.getWorkflowInstance();
        WorkflowInstance nestedWorkflowInstance = workflowInstance.getNestedWorkflowInstance();
        WorkflowProcessor workflowProcessor = new WorkflowProcessor(context.getStepProcessorProvider());
        Optional<WorkflowInstance> result = workflowProcessor.processEvent(event, nestedWorkflowInstance, context.getContractProcessingContext(), mode);
        if (result.isPresent()) {
            WorkflowInstance processedSubflow = result.get();
            if (processedSubflow.isCompleted()) {
                workflowInstance.nestedWorkflowInstance(null);
                return ProcessingResult.FINISHED;
            }
            workflowInstance.nestedWorkflowInstance(processedSubflow);
            return ProcessingResult.CONTINUE;
        }
        return ProcessingResult.NO_RESULT;
    }

    private static enum ProcessingResult {
        FINISHED,
        CONTINUE,
        NO_RESULT;

    }
}

