/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.processor;

import blue.contract.AbstractStepProcessor;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.model.event.ContractUpdateEvent;
import blue.contract.utils.Events;
import blue.contract.utils.ExpressionEvaluator;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.UncheckedObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdateStepProcessor
extends AbstractStepProcessor {
    private static final Set<String> ALLOWED_KEYS = Set.of("path", "value", "op");
    private List<Map<String, Object>> rawChangeset;

    public UpdateStepProcessor(Node step, ExpressionEvaluator expressionEvaluator) {
        super(step, expressionEvaluator);
        List<Map<String, Object>> changeset = ((Node)step.getProperties().get("changeset")).getItems().stream().map(el -> (Map)NodeToMapListOrValue.get((Node)el, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE)).toList();
        this.rawChangeset = this.prepareChangeset(changeset, false);
    }

    private List<Map<String, Object>> prepareChangeset(List<Map<String, Object>> changeset, boolean toVal) {
        return changeset.stream().map(change -> {
            String toKey;
            HashMap newChange = new HashMap(change);
            String fromKey = toVal ? "value" : "val";
            String string = toKey = toVal ? "val" : "value";
            if (newChange.containsKey(fromKey)) {
                newChange.put(toKey, newChange.remove(fromKey));
            }
            return newChange;
        }).collect(Collectors.toList());
    }

    @Override
    public Optional<WorkflowInstance> executeHandleStep(Node event, WorkflowProcessingContext context) {
        this.processEvent(event, context);
        return this.handleNextStepByOrder(event, context);
    }

    @Override
    public Optional<WorkflowInstance> executeFinalizeStep(Node event, WorkflowProcessingContext context) {
        this.processEvent(event, context);
        return this.finalizeNextStepByOrder(event, context);
    }

    private void processEvent(Node event, WorkflowProcessingContext context) {
        Blue blue = context.getContractProcessingContext().getBlue();
        Node node = blue.objectToNode((Object)context.getContractProcessingContext().getContract());
        Object obj = NodeToMapListOrValue.get((Node)node, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE);
        JsonNode objNode = (JsonNode)UncheckedObjectMapper.JSON_MAPPER.convertValue(obj, JsonNode.class);
        try {
            List<Map<String, Object>> evaluatedChangeset = this.rawChangeset.stream().map(change -> this.evaluateChange((Map<String, Object>)change, context, blue)).map(change -> change.entrySet().stream().filter(entry -> ALLOWED_KEYS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).collect(Collectors.toList());
            evaluatedChangeset.forEach(e -> e.remove("type"));
            ArrayList<Map> modifiedChangeset = new ArrayList<Map>();
            for (Map map : evaluatedChangeset) {
                String parentPath;
                Node parentNode;
                String path = (String)map.get("path");
                if (path.endsWith("/-") && ((parentNode = node.getAsNode(parentPath = path.substring(0, path.length() - 2))) == null || parentNode.getItems() == null)) {
                    modifiedChangeset.add(this.createListOperation(parentPath));
                }
                modifiedChangeset.add(map);
            }
            JsonNode patchNode = (JsonNode)UncheckedObjectMapper.JSON_MAPPER.convertValue(modifiedChangeset, JsonNode.class);
            JsonPatch jsonPatch = JsonPatch.fromJson((JsonNode)patchNode);
            JsonNode result = jsonPatch.apply(objNode);
            Node updatedContract = (Node)UncheckedObjectMapper.JSON_MAPPER.convertValue((Object)result, Node.class);
            context.getContractProcessingContext().contract(updatedContract);
            List<Map<String, Object>> eventChangeset = this.prepareChangeset(evaluatedChangeset, true);
            ContractUpdateEvent updateEvent = new ContractUpdateEvent().changeset((Node)UncheckedObjectMapper.JSON_MAPPER.convertValue(eventChangeset, Node.class));
            Node updateEventNode = context.getContractProcessingContext().getBlue().objectToNode((Object)updateEvent);
            ContractProcessingEvent processingEvent = Events.prepareContractProcessingEvent(updateEventNode, this.step.getName(), context);
            Node processingEventNode = context.getContractProcessingContext().getBlue().objectToNode((Object)processingEvent);
            context.getContractProcessingContext().getEmittedEvents().add(processingEventNode);
        }
        catch (JsonPatchException | IOException e2) {
            throw new IllegalArgumentException("Applying JSON Patch failed", e2);
        }
    }

    private Map<String, Object> evaluateChange(Map<String, Object> change, WorkflowProcessingContext context, Blue blue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("op", this.evaluateExpression(change.get("op"), context));
        result.put("path", this.evaluateExpression(change.get("path"), context));
        if (change.get("value") instanceof Map) {
            result.put("value", this.evaluateExpressionsRecursively(blue.objectToNode(change.get("value")), context));
        } else {
            result.put("value", this.evaluateExpression(change.get("value"), context));
        }
        return result;
    }

    private Map<String, Object> createListOperation(String path) {
        HashMap<String, Object> operation = new HashMap<String, Object>();
        operation.put("op", "add");
        operation.put("path", path);
        operation.put("value", new ArrayList());
        return operation;
    }
}

