/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.processor;

import blue.contract.AbstractStepProcessor;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.utils.Events;
import blue.contract.utils.ExpressionEvaluator;
import blue.language.model.Node;
import java.util.Optional;

public class TriggerEventStepProcessor
extends AbstractStepProcessor {
    public TriggerEventStepProcessor(Node step, ExpressionEvaluator expressionEvaluator) {
        super(step, expressionEvaluator);
    }

    @Override
    public Optional<WorkflowInstance> executeHandleStep(Node event, WorkflowProcessingContext context) {
        this.processEvent(event, context);
        return this.handleNextStepByOrder(event, context);
    }

    @Override
    public Optional<WorkflowInstance> executeFinalizeStep(Node event, WorkflowProcessingContext context) {
        this.processEvent(event, context);
        return this.finalizeNextStepByOrder(event, context);
    }

    private void processEvent(Node event, WorkflowProcessingContext workflowProcessingContext) {
        Node eventNode = ((Node)this.step.getProperties().get("event")).clone();
        eventNode = this.evaluateExpressionsRecursively(eventNode, workflowProcessingContext);
        ContractProcessingEvent processingEvent = Events.prepareContractProcessingEvent(eventNode, this.step.getName(), workflowProcessingContext);
        Node processingEventNode = workflowProcessingContext.getContractProcessingContext().getBlue().objectToNode((Object)processingEvent);
        workflowProcessingContext.getContractProcessingContext().getEmittedEvents().add(processingEventNode);
        this.getStepName().ifPresent(s -> workflowProcessingContext.getWorkflowInstance().addStepResult((String)s, processingEventNode));
    }
}

