/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.processor;

import blue.contract.AbstractStepProcessor;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.utils.ExpressionEvaluator;
import blue.contract.utils.JSExecutor;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.limits.Limits;
import blue.language.utils.limits.PathLimits;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JSCodeStepProcessor
extends AbstractStepProcessor {
    private final String code;
    private final JSExecutor jsExecutor;

    public JSCodeStepProcessor(Node step, ExpressionEvaluator expressionEvaluator, JSExecutor jsExecutor, Blue blue) {
        super(step, expressionEvaluator);
        blue.extend(step, (Limits)PathLimits.withSinglePath((String)"/*"));
        this.code = (String)((Node)step.getProperties().get("code")).getValue();
        this.jsExecutor = jsExecutor;
    }

    @Override
    public Optional<WorkflowInstance> executeHandleStep(Node event, WorkflowProcessingContext context) {
        try {
            Object result = this.processEvent(event, context);
            if (result instanceof JSExecutor.ContractCompleteResult) {
                return this.handleContractComplete((JSExecutor.ContractCompleteResult)result, context);
            }
            return this.handleNextStepByOrder(event, context);
        }
        catch (JSExecutor.JSException ex) {
            return this.processJSException(ex, context);
        }
    }

    @Override
    public Optional<WorkflowInstance> executeFinalizeStep(Node event, WorkflowProcessingContext context) {
        try {
            Object result = this.processEvent(event, context);
            if (result instanceof JSExecutor.ContractCompleteResult) {
                return this.handleContractComplete((JSExecutor.ContractCompleteResult)result, context);
            }
            return this.finalizeNextStepByOrder(event, context);
        }
        catch (JSExecutor.JSException ex) {
            return this.processJSException(ex, context);
        }
    }

    private Object processEvent(Node event, WorkflowProcessingContext context) throws JSExecutor.JSException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("event", NodeToMapListOrValue.get((Node)event, (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
        HashMap<String, Object> processedStepResults = new HashMap<String, Object>();
        if (context.getWorkflowInstance().getStepResults() != null) {
            for (Map.Entry<String, Object> entry : context.getWorkflowInstance().getStepResults().entrySet()) {
                Object value = entry.getValue();
                Blue blue = context.getContractProcessingContext().getBlue();
                processedStepResults.put(entry.getKey(), NodeToMapListOrValue.get((Node)blue.objectToNode(value)));
            }
        }
        bindings.put("steps", processedStepResults);
        bindings.put("contract", path -> context.getContractProcessingContext().accessContract((String)path, true, true));
        Object result = this.jsExecutor.executeScript(this.code, bindings);
        Optional<String> stepName = this.getStepName();
        if (stepName.isPresent()) {
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                context.getWorkflowInstance().getStepResults().put(stepName.get(), resultMap);
            } else {
                throw new IllegalArgumentException("Unexpected result type from JavaScript execution: " + result.getClass());
            }
        }
        return result;
    }

    private Optional<WorkflowInstance> handleContractComplete(JSExecutor.ContractCompleteResult result, WorkflowProcessingContext context) {
        ContractProcessingContext contractProcessingContext = context.getContractProcessingContext();
        ContractInstance currentInstance = contractProcessingContext.getCurrentContractInstance();
        currentInstance.getProcessingState().completed(true);
        if (currentInstance.getId() == 0) {
            contractProcessingContext.completed(true);
        }
        return Optional.of(context.getWorkflowInstance().completed(true));
    }
}

