/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.processor;

import blue.contract.AbstractStepProcessor;
import blue.contract.SingleEventContractProcessor;
import blue.contract.debug.DebugContext;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.GenericContract;
import blue.contract.model.LocalContract;
import blue.contract.model.Participant;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.utils.ExpressionEvaluator;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.NodeToMapListOrValue;
import blue.language.utils.limits.Limits;
import blue.language.utils.limits.PathLimits;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class InitializeLocalContractStepProcessor
extends AbstractStepProcessor {
    public InitializeLocalContractStepProcessor(Node step, ExpressionEvaluator expressionEvaluator) {
        super(step, expressionEvaluator);
    }

    @Override
    public Optional<WorkflowInstance> executeHandleStep(Node event, WorkflowProcessingContext context) {
        this.processEvent(event, context);
        return this.handleNextStepByOrder(event, context);
    }

    @Override
    public Optional<WorkflowInstance> executeFinalizeStep(Node event, WorkflowProcessingContext context) {
        this.processEvent(event, context);
        return this.finalizeNextStepByOrder(event, context);
    }

    private void processEvent(Node event, WorkflowProcessingContext workflowProcessingContext) {
        Blue blue = workflowProcessingContext.getContractProcessingContext().getBlue();
        Node contractToInitialize = this.extractContract(workflowProcessingContext, blue);
        ContractProcessingContext contractProcessingContext = workflowProcessingContext.getContractProcessingContext();
        this.assignParticipants(contractToInitialize, contractProcessingContext.getContract(), blue);
        int instanceId = contractProcessingContext.getStartedLocalContracts() + 1;
        int currentContractInstanceId = contractProcessingContext.getContractInstanceId();
        Node currentContract = contractProcessingContext.getContract();
        contractProcessingContext.contractInstanceId(instanceId);
        contractProcessingContext.contract(contractToInitialize);
        DebugContext newDebugContext = new DebugContext(this.getDebugContext().isDebug());
        SingleEventContractProcessor singleEventContractProcessor = new SingleEventContractProcessor(contractProcessingContext.getStepProcessorProvider(), blue, newDebugContext);
        ContractUpdateAction update = singleEventContractProcessor.initiate(contractToInitialize, contractProcessingContext, contractProcessingContext.getInitiateContractEntryBlueId(), contractProcessingContext.getInitiateContractProcessingEntryBlueId());
        ContractInstance instance = update.getContractInstance();
        instance.id(instanceId);
        contractProcessingContext.getContractInstances().add(instance);
        contractProcessingContext.contractInstanceId(currentContractInstanceId);
        contractProcessingContext.contract(currentContract);
        contractProcessingContext.startedLocalContracts(contractProcessingContext.getStartedLocalContracts() + 1);
        Optional<String> stepName = this.getStepName();
        if (newDebugContext.getDebugInfo() != null) {
            this.getDebugContext().addWorkflowStepResult(this.getStepName(), Map.of("contractInitializationDebug", blue.objectToSimpleYaml((Object)newDebugContext.getDebugInfo())));
        }
        if (stepName.isPresent()) {
            LocalContract result = new LocalContract().id(instance.getId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("localContract", NodeToMapListOrValue.get((Node)blue.objectToNode((Object)result), (NodeToMapListOrValue.Strategy)NodeToMapListOrValue.Strategy.SIMPLE));
            workflowProcessingContext.getWorkflowInstance().getStepResults().put(stepName.get(), map);
        }
    }

    private void assignParticipants(Node contractToInitializeNode, Node mainContractNode, Blue blue) {
        GenericContract contractToInitialize = (GenericContract)blue.nodeToObject(contractToInitializeNode, GenericContract.class);
        GenericContract mainContract = (GenericContract)blue.nodeToObject(mainContractNode, GenericContract.class);
        if (contractToInitialize.getMessaging() == null || contractToInitialize.getMessaging().getParticipants() == null) {
            return;
        }
        Map<String, Participant> participantsToInitialize = contractToInitialize.getMessaging().getParticipants();
        Map<String, Participant> currentParticipants = mainContract.getMessaging().getParticipants();
        ArrayList<String> participantKeys = new ArrayList<String>(participantsToInitialize.keySet());
        for (String key : participantKeys) {
            if (!currentParticipants.containsKey(key)) {
                throw new RuntimeException("Participant with key '" + key + "' does not exist in the main contract.");
            }
            Participant participantToCopy = currentParticipants.get(key);
            participantsToInitialize.put(key, participantToCopy);
        }
        contractToInitializeNode.getProperties().put("messaging", blue.objectToNode((Object)contractToInitialize.getMessaging()));
    }

    public Node extractContract(WorkflowProcessingContext context, Blue blue) {
        Node contractNode = (Node)this.step.getProperties().get("contract");
        if (contractNode == null) {
            throw new IllegalArgumentException("No \"contract\" defined for step with name \"" + this.getStepName().orElse("<noname>") + "\" in workflow with name \"" + context.getWorkflowInstance().getWorkflow().getName() + "\".");
        }
        blue.extend(contractNode, (Limits)PathLimits.withSinglePath((String)"/"));
        contractNode = this.evaluateExpressionsRecursively(contractNode, context);
        return contractNode;
    }

    private Node preprocess(Node contract, Blue blue) {
        PathLimits contractLimits = new PathLimits.Builder().addPath("/participants/*").addPath("/properties/*").addPath("/workflows/*/*").addPath("/modules/*/*").build();
        blue.extend(contract, (Limits)contractLimits);
        return blue.resolve(contract);
    }
}

