/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.packager.utils;

import blue.language.model.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodeDependencyAnalyzer {
    public Map<String, Set<String>> analyzeDependencies(Map<String, Node> nodes) {
        HashMap<String, Set<String>> graph = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Node> entry : nodes.entrySet()) {
            String nodeName = entry.getKey();
            Node node = entry.getValue();
            Set<String> dependencies = this.findDependencies(node);
            dependencies.retainAll(nodes.keySet());
            graph.put(nodeName, dependencies);
        }
        return graph;
    }

    private Set<String> findDependencies(Node node) {
        HashSet<String> dependencies = new HashSet<String>();
        this.findDependenciesRecursive(node, dependencies);
        return dependencies;
    }

    private void findDependenciesRecursive(Node node, Set<String> dependencies) {
        if (node == null) {
            return;
        }
        this.addDependencyIfInline(node.getType(), dependencies);
        this.addDependencyIfInline(node.getItemType(), dependencies);
        this.addDependencyIfInline(node.getKeyType(), dependencies);
        this.addDependencyIfInline(node.getValueType(), dependencies);
        if (node.getItems() != null) {
            for (Node node2 : node.getItems()) {
                this.findDependenciesRecursive(node2, dependencies);
            }
        }
        if (node.getProperties() != null) {
            for (Map.Entry entry : node.getProperties().entrySet()) {
                this.addDependencyIfInline(((Node)entry.getValue()).getType(), dependencies);
                this.findDependenciesRecursive((Node)entry.getValue(), dependencies);
            }
        }
    }

    private void addDependencyIfInline(Node typeNode, Set<String> dependencies) {
        if (typeNode != null && typeNode.isInlineValue()) {
            dependencies.add(typeNode.getValue().toString());
        }
    }
}

