/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.packager.model;

import blue.contract.packager.model.DirectoryNode;
import blue.language.model.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph {
    private Map<String, DirectoryNode> directories = new HashMap<String, DirectoryNode>();

    public void addDirectory(String name, String dependency) {
        DirectoryNode node = new DirectoryNode(name);
        node.setDependency(dependency);
        this.directories.put(name, node);
    }

    public void addNode(String dirName, Node node) {
        this.directories.get(dirName).addNode(node);
    }

    public List<String> getProcessingOrder() {
        ArrayList<String> order = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> recursionStack = new HashSet<String>();
        for (String dirName : this.directories.keySet()) {
            if (!this.hasCyclicDependency(dirName, visited, recursionStack, order)) continue;
            throw new IllegalStateException("Cyclic dependency detected in directory structure: " + String.join((CharSequence)" -> ", recursionStack) + " -> " + dirName);
        }
        return order;
    }

    private boolean hasCyclicDependency(String dirName, Set<String> visited, Set<String> recursionStack, List<String> order) {
        if (recursionStack.contains(dirName)) {
            return true;
        }
        if (visited.contains(dirName)) {
            return false;
        }
        visited.add(dirName);
        recursionStack.add(dirName);
        DirectoryNode node = this.directories.get(dirName);
        String dep = node.getDependency();
        if (!dep.equals("ROOT") && this.hasCyclicDependency(dep, visited, recursionStack, order)) {
            return true;
        }
        recursionStack.remove(dirName);
        order.add(dirName);
        return false;
    }

    public Map<String, DirectoryNode> getDirectories() {
        return this.directories;
    }

    public DependencyGraph setDirectories(Map<String, DirectoryNode> directories) {
        this.directories = directories;
        return this;
    }
}

