/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.packager.graphbuilder;

import blue.contract.packager.graphbuilder.DependencyGraphBuilder;
import blue.contract.packager.model.DependencyGraph;
import blue.language.model.Node;
import blue.language.utils.UncheckedObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;

public class ClasspathDependencyGraphBuilder
implements DependencyGraphBuilder {
    private final ClassLoader classLoader;

    public ClasspathDependencyGraphBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public DependencyGraph buildDependencyGraph(String rootDir) throws IOException {
        DependencyGraph graph = new DependencyGraph();
        URL resource = this.classLoader.getResource(rootDir);
        if (resource == null) {
            throw new IOException("Root directory not found in classpath: " + rootDir);
        }
        try (InputStream is = resource.openStream();){
            String[] directories;
            Scanner scanner = new Scanner(is).useDelimiter("\\A");
            String content = scanner.hasNext() ? scanner.next() : "";
            for (String dir : directories = content.split("\n")) {
                String dependency = this.readDependency(rootDir + "/" + dir + "/_extends.txt");
                graph.addDirectory(dir, dependency);
                this.processFiles(rootDir, dir, graph);
            }
        }
        return graph;
    }

    private String readDependency(String path) throws IOException {
        try (InputStream is = this.classLoader.getResourceAsStream(path);){
            String content;
            if (is == null) {
                throw new IOException("Dependency file not found: " + path);
            }
            Scanner scanner = new Scanner(is).useDelimiter("\\A");
            String string = content = scanner.hasNext() ? scanner.next().trim() : "";
            if (content.isEmpty() || content.lines().count() != 1L) {
                throw new IOException("Invalid dependency file format. Expected one line in: " + path);
            }
            String string2 = content;
            return string2;
        }
    }

    private void processFiles(String rootDir, String dirName, DependencyGraph graph) throws IOException {
        String dirPath = rootDir + "/" + dirName + "/";
        URL dirUrl = this.classLoader.getResource(dirPath);
        if (dirUrl == null) {
            return;
        }
        try (InputStream is = dirUrl.openStream();){
            String[] files;
            Scanner scanner = new Scanner(is).useDelimiter("\\A");
            String content = scanner.hasNext() ? scanner.next() : "";
            for (String file : files = content.split("\n")) {
                if (file.equals("_extends.txt") || !file.endsWith(".blue")) continue;
                String filePath = dirPath + file;
                try (InputStream fileIs = this.classLoader.getResourceAsStream(filePath);){
                    if (fileIs == null) continue;
                    Node contract = (Node)UncheckedObjectMapper.YAML_MAPPER.readValue(fileIs, Node.class);
                    graph.addNode(dirName, contract);
                }
            }
        }
    }
}

