/*
 * Decompiled with CFR 0.152.
 */
package blue.contract.debug;

import blue.contract.WorkflowProcessor;
import blue.contract.debug.DebugContractProcessingInfo;
import blue.contract.debug.DebugInfo;
import blue.contract.debug.DebugWorkflowProcessingInfo;
import blue.contract.debug.DebugWorkflowStepProcessingInfo;
import blue.language.model.Node;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DebugContext {
    private DebugInfo currentDebugInfo;
    private DebugContractProcessingInfo currentContractInfo;
    private DebugWorkflowProcessingInfo currentWorkflowInfo;
    private boolean debug;

    public DebugContext(boolean debug) {
        this.debug = debug;
        if (debug) {
            this.currentDebugInfo = new DebugInfo();
        }
    }

    public void startContractProcessing(Node incomingEvent, Node contract) {
        if (this.debug) {
            this.currentContractInfo = new DebugContractProcessingInfo();
            this.currentContractInfo.incomingEvent(incomingEvent.clone());
            this.currentContractInfo.contract(contract.clone());
            this.currentDebugInfo.getContractResults().add(this.currentContractInfo);
            this.currentWorkflowInfo = null;
        }
    }

    public void startWorkflowProcessing(String workflowName) {
        this.startWorkflowProcessing(workflowName, null);
    }

    public void startWorkflowProcessing(String workflowName, Map<String, Object> initialStepResults) {
        if (this.debug) {
            this.currentWorkflowInfo = new DebugWorkflowProcessingInfo();
            this.currentWorkflowInfo.workflowName(workflowName == null ? "<Unknown>" : workflowName);
            if (initialStepResults != null) {
                this.currentWorkflowInfo.initialStepResultsMap(initialStepResults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() instanceof Node ? ((Node)e.getValue()).clone() : "<Not a Node>")));
            }
            this.currentContractInfo.getWorkflowResults().add(this.currentWorkflowInfo);
        }
    }

    public void skipWorkflowStep(WorkflowProcessor.ProcessingMode processingMode, String stepName) {
        if (this.debug) {
            DebugWorkflowStepProcessingInfo stepInfo = new DebugWorkflowStepProcessingInfo();
            stepInfo.mode(processingMode);
            stepInfo.stepName(stepName);
            stepInfo.skipping(true);
            this.currentWorkflowInfo.getStepResults().add(stepInfo);
        }
    }

    public void addWorkflowStepResult(Optional<String> stepName, Map<String, Object> results) {
        if (this.debug) {
            this.addWorkflowStepResult(stepName.orElse("<UnnamedStep>"), results);
        }
    }

    public void addWorkflowStepResult(String stepName, Map<String, Object> results) {
        if (this.debug) {
            DebugWorkflowStepProcessingInfo stepInfo = new DebugWorkflowStepProcessingInfo();
            stepInfo.stepName(stepName);
            stepInfo.results(results);
            this.currentWorkflowInfo.getStepResults().add(stepInfo);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public DebugInfo getDebugInfo() {
        return this.currentDebugInfo;
    }
}

