/*
 * Decompiled with CFR 0.152.
 */
package blue.contract;

import blue.contract.StepProcessor;
import blue.contract.StepProcessorProvider;
import blue.contract.debug.DebugContext;
import blue.contract.debug.DebugContextAware;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.WorkflowProcessingContext;
import blue.contract.model.step.ExpectEventStep;
import blue.contract.utils.Workflows;
import blue.language.model.Node;
import blue.language.utils.BlueIds;
import blue.language.utils.UncheckedObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Optional;

public class WorkflowProcessor {
    private StepProcessorProvider stepProcessorProvider;
    private DebugContext debugContext;

    public WorkflowProcessor(StepProcessorProvider stepProcessorProvider) {
        this(stepProcessorProvider, new DebugContext(false));
    }

    public WorkflowProcessor(StepProcessorProvider stepProcessorProvider, DebugContext debugContext) {
        this.stepProcessorProvider = stepProcessorProvider;
        this.debugContext = debugContext;
    }

    public Optional<WorkflowInstance> processEvent(Node event, Node workflow, ContractProcessingContext contractProcessingContext) {
        return this.processEvent(event, workflow, contractProcessingContext, ProcessingMode.HANDLE);
    }

    public Optional<WorkflowInstance> processEvent(Node event, Node workflow, ContractProcessingContext contractProcessingContext, ProcessingMode mode) {
        WorkflowInstance workflowInstance = new WorkflowInstance(workflow);
        WorkflowProcessingContext context = new WorkflowProcessingContext(workflowInstance, contractProcessingContext, this.stepProcessorProvider);
        Node step = (Node)workflow.getProperties().get("trigger");
        if (step.getType() == null) {
            step.type(new Node().blueId((String)BlueIds.getBlueId(ExpectEventStep.class).orElseThrow(() -> new RuntimeException("No blueId found for 'Expect Event Step'."))));
        }
        return this.handleEvent(event, step, context, mode);
    }

    public Optional<WorkflowInstance> processEvent(Node event, WorkflowInstance workflowInstance, ContractProcessingContext contractProcessingContext) {
        return this.processEvent(event, workflowInstance, contractProcessingContext, ProcessingMode.HANDLE);
    }

    public Optional<WorkflowInstance> processEvent(Node event, WorkflowInstance workflowInstance, ContractProcessingContext contractProcessingContext, ProcessingMode mode) {
        WorkflowProcessingContext context = new WorkflowProcessingContext(workflowInstance, contractProcessingContext, this.stepProcessorProvider);
        Optional<Node> step = Workflows.getStepByName(workflowInstance.getCurrentStepName(), workflowInstance.getWorkflow());
        if (!step.isPresent()) {
            throw new IllegalArgumentException("No step found with name '" + workflowInstance.getCurrentStepName() + "' in the workflow.");
        }
        return this.handleEvent(event, step.get(), context, mode);
    }

    private Optional<WorkflowInstance> handleEvent(Node event, Node step, WorkflowProcessingContext context, ProcessingMode mode) {
        Optional<StepProcessor> stepProcessor = this.stepProcessorProvider.getProcessor(step);
        if (!stepProcessor.isPresent()) {
            throw new IllegalArgumentException("No StepProcessor found for event: " + UncheckedObjectMapper.JSON_MAPPER.disable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)event));
        }
        if (stepProcessor.get() instanceof DebugContextAware) {
            ((DebugContextAware)((Object)stepProcessor.get())).setDebugContext(this.debugContext);
        }
        context.beginTransaction();
        Optional<WorkflowInstance> result = mode == ProcessingMode.HANDLE ? stepProcessor.get().handleEvent(event, context) : stepProcessor.get().finalizeEvent(event, context);
        if (result.isPresent()) {
            context.commitTransaction();
            return result;
        }
        context.rollbackTransaction();
        return Optional.empty();
    }

    public static enum ProcessingMode {
        HANDLE,
        FINALIZE;

    }
}

