/*
 * Decompiled with CFR 0.152.
 */
package blue.contract;

import blue.contract.StepProcessorProvider;
import blue.contract.WorkflowProcessor;
import blue.contract.debug.DebugContext;
import blue.contract.exception.ContractProcessingException;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractProcessingContext;
import blue.contract.model.ContractProcessorConfig;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.ProcessingState;
import blue.contract.model.WorkflowInstance;
import blue.contract.model.event.WorkflowInstanceStartedEvent;
import blue.language.Blue;
import blue.language.model.Node;
import blue.language.utils.BlueIdCalculator;
import blue.language.utils.limits.Limits;
import blue.language.utils.limits.PathLimits;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SingleEventContractProcessor {
    private final StepProcessorProvider stepProcessorProvider;
    private final WorkflowProcessor workflowProcessor;
    private final Blue blue;
    private final ContractProcessorConfig contractProcessorConfig;
    private final DebugContext debugContext;

    public SingleEventContractProcessor(StepProcessorProvider stepProcessorProvider, Blue blue) {
        this(stepProcessorProvider, blue, new DebugContext(false));
    }

    public SingleEventContractProcessor(StepProcessorProvider stepProcessorProvider, Blue blue, DebugContext debugContext) {
        this.blue = blue;
        this.stepProcessorProvider = stepProcessorProvider;
        this.workflowProcessor = new WorkflowProcessor(stepProcessorProvider, debugContext);
        this.contractProcessorConfig = new ContractProcessorConfig();
        this.debugContext = debugContext;
    }

    public ContractUpdateAction initiate(Node contract, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        return this.initiate(contract, null, initiateContractEntryBlueId, initiateContractProcessingEntryBlueId);
    }

    public ContractUpdateAction initiate(Node contract, ContractProcessingContext initiatedContext, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        Node event = this.initializationEvent();
        Node preprocessedContractNode = this.preprocess(contract);
        ContractInstance rootInstance = new ContractInstance().id(0).contractState(preprocessedContractNode).processingState(new ProcessingState());
        ArrayList<ContractInstance> contractInstances = new ArrayList<ContractInstance>();
        contractInstances.add(rootInstance);
        ContractProcessingContext context = initiatedContext != null ? initiatedContext : new ContractProcessingContext().contractInstances(contractInstances).contractInstanceId(0).contract(preprocessedContractNode).startedLocalContracts(0).initiateContractEntryBlueId(initiateContractEntryBlueId).initiateContractProcessingEntryBlueId(initiateContractProcessingEntryBlueId).stepProcessorProvider(this.stepProcessorProvider).blue(this.blue).config(this.contractProcessorConfig).incomingEvent(event);
        this.debugContext.startContractProcessing(event, contract);
        List<WorkflowInstance> workflowInstances = this.processWorkflows(event, context, 0);
        int startedWorkflowInstancesCount = workflowInstances.size();
        workflowInstances.removeIf(WorkflowInstance::isCompleted);
        List localContractInstances = context.getContractInstances().stream().filter(instance -> instance.getId() != 0).collect(Collectors.toList());
        rootInstance.getProcessingState().startedWorkflowsCount(startedWorkflowInstancesCount).workflowInstances(workflowInstances.isEmpty() ? null : workflowInstances).startedLocalContractsCount(context.getStartedLocalContracts()).localContractInstances(localContractInstances.isEmpty() ? null : new ArrayList(localContractInstances)).completed(context.isCompleted()).terminatedWithError(context.isTerminatedWithError());
        rootInstance.contractState(context.getContract());
        return new ContractUpdateAction().contractInstance(rootInstance).emittedEvents(context.getEmittedEvents().isEmpty() ? null : context.getEmittedEvents()).initiateContractEntry(initiateContractEntryBlueId).initiateContractProcessingEntry(initiateContractProcessingEntryBlueId).incomingEvent(event);
    }

    private Node preprocess(Node contract) {
        PathLimits contractLimits = new PathLimits.Builder().addPath("/participants/*").addPath("/properties/*").addPath("/workflows/*/*").addPath("/modules/*/*").build();
        this.blue.extend(contract, (Limits)contractLimits);
        return this.blue.resolve(contract);
    }

    public ContractUpdateAction processEvent(Node event, ContractInstance contractInstance, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        if (contractInstance.getProcessingState().isCompleted() || contractInstance.getProcessingState().isTerminatedWithError()) {
            throw new IllegalStateException("Contract instance is already completed or terminated with error.");
        }
        contractInstance = (ContractInstance)this.blue.clone((Object)contractInstance);
        int initialStartedLocalContracts = contractInstance.getProcessingState().getStartedLocalContractCount();
        String previousContractInstanceBlueId = this.calculateBlueId(contractInstance);
        List<ContractInstance> localContractInstances = contractInstance.getProcessingState().getLocalContractInstances();
        List<Object> localContractIds = new ArrayList();
        if (localContractInstances != null) {
            localContractIds = localContractInstances.stream().map(ContractInstance::getId).sorted().collect(Collectors.toList());
        }
        ContractProcessingContext context = new ContractProcessingContext().contractInstances(localContractInstances == null ? new ArrayList<ContractInstance>() : new ArrayList<ContractInstance>(localContractInstances)).contractInstanceId(contractInstance.getId()).contract(contractInstance.getContractState()).startedLocalContracts(initialStartedLocalContracts).initiateContractEntryBlueId(initiateContractEntryBlueId).initiateContractProcessingEntryBlueId(initiateContractProcessingEntryBlueId).stepProcessorProvider(this.stepProcessorProvider).blue(this.blue).config(this.contractProcessorConfig).incomingEvent(event);
        this.debugContext.startContractProcessing(event, this.blue.objectToNode((Object)contractInstance.getContractState()));
        this.processEventInContractInstance(event, contractInstance, context);
        Iterator<Object> iterator = localContractIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            ContractInstance instance2 = context.getContractInstance(id);
            ContractInstance result = this.processEventInContractInstance(event, instance2, context);
            if (context.isCompleted()) break;
            context.replaceContractInstance(id, result);
        }
        List processedLocalInstances = context.getContractInstances().stream().filter(instance -> instance.getId() != 0).collect(Collectors.toList());
        contractInstance.getProcessingState().startedLocalContractsCount(context.getStartedLocalContracts()).localContractInstances(processedLocalInstances.isEmpty() ? null : new ArrayList(processedLocalInstances));
        return new ContractUpdateAction().contractInstance(contractInstance).contractInstancePrev(previousContractInstanceBlueId).emittedEvents(context.getEmittedEvents().isEmpty() ? null : context.getEmittedEvents()).initiateContractEntry(initiateContractEntryBlueId).initiateContractProcessingEntry(initiateContractProcessingEntryBlueId).incomingEvent(event);
    }

    private ContractInstance processEventInContractInstance(Node event, ContractInstance contractInstance, ContractProcessingContext context) {
        context.contract(contractInstance.getContractState());
        context.contractInstanceId(contractInstance.getId());
        List<WorkflowInstance> existingWorkflowInstances = contractInstance.getProcessingState().getWorkflowInstances();
        int startedWorkflows = contractInstance.getProcessingState().getStartedWorkflowCount();
        List<WorkflowInstance> newWorkflowInstances = this.processWorkflows(event, context, startedWorkflows);
        this.addWorkflowInstanceStartedEvents(newWorkflowInstances, context);
        startedWorkflows += newWorkflowInstances.size();
        if (existingWorkflowInstances != null) {
            for (WorkflowInstance workflowInstance : existingWorkflowInstances) {
                this.debugContext.startWorkflowProcessing(workflowInstance.getWorkflow().getName(), workflowInstance.getStepResults());
                this.workflowProcessor.processEvent(event, workflowInstance, context);
            }
        }
        ArrayList<WorkflowInstance> updatedWorkflowInstances = new ArrayList<WorkflowInstance>();
        if (existingWorkflowInstances != null) {
            updatedWorkflowInstances.addAll(existingWorkflowInstances);
        }
        updatedWorkflowInstances.addAll(newWorkflowInstances);
        updatedWorkflowInstances.removeIf(WorkflowInstance::isCompleted);
        contractInstance.contractState(context.getContract());
        contractInstance.getProcessingState().startedWorkflowsCount(startedWorkflows).workflowInstances(updatedWorkflowInstances.isEmpty() ? null : updatedWorkflowInstances);
        return contractInstance;
    }

    private List<WorkflowInstance> processWorkflows(Node event, ContractProcessingContext context, int initialStartedWorkflows) {
        if (context.getContract().getProperties() == null || context.getContract().getProperties().get("workflows") == null || ((Node)context.getContract().getProperties().get("workflows")).getItems() == null) {
            return new ArrayList<WorkflowInstance>();
        }
        List workflows = ((Node)context.getContract().getProperties().get("workflows")).getItems();
        AtomicInteger currentId = new AtomicInteger(initialStartedWorkflows);
        ArrayList<WorkflowInstance> processedWorkflows = new ArrayList<WorkflowInstance>();
        for (Node workflow : workflows) {
            try {
                this.debugContext.startWorkflowProcessing(workflow.getName());
                Optional<WorkflowInstance> result = this.workflowProcessor.processEvent(event, workflow, context);
                if (!result.isPresent()) continue;
                result.get().id(currentId.getAndIncrement());
                processedWorkflows.add(result.get());
                if (!context.isCompleted()) continue;
                return processedWorkflows;
            }
            catch (ContractProcessingException e) {
                break;
            }
        }
        return processedWorkflows;
    }

    private void addWorkflowInstanceStartedEvents(List<WorkflowInstance> newWorkflowInstances, ContractProcessingContext context) {
        for (WorkflowInstance workflowInstance : newWorkflowInstances) {
            WorkflowInstanceStartedEvent event = new WorkflowInstanceStartedEvent().workflowInstanceId(workflowInstance.getId()).contractInstanceId(context.getContractInstanceId()).currentStepName(workflowInstance.getCurrentStepName()).initiateContractEntry(context.getInitiateContractEntryBlueId()).initiateContractProcessingEntry(context.getInitiateContractProcessingEntryBlueId());
            Node eventNode = this.blue.objectToNode((Object)event);
            context.getEmittedEvents().add(eventNode);
        }
    }

    private Node initializationEvent() {
        return new Node().type(new Node().blueId("3uzSCGkrdX4hTFGuLbyZES7NQmiuFskCpUy572GxNQuC"));
    }

    private String calculateBlueId(ContractInstance contractInstance) {
        return BlueIdCalculator.calculateBlueId((Node)this.toNode(contractInstance));
    }

    private Node toNode(ContractInstance contractInstance) {
        return this.blue.objectToNode((Object)contractInstance);
    }

    public StepProcessorProvider getStepProcessorProvider() {
        return this.stepProcessorProvider;
    }

    public WorkflowProcessor getWorkflowProcessor() {
        return this.workflowProcessor;
    }

    public Blue getBlue() {
        return this.blue;
    }

    public ContractProcessorConfig getContractProcessorConfig() {
        return this.contractProcessorConfig;
    }
}

