/*
 * Decompiled with CFR 0.152.
 */
package blue.contract;

import blue.contract.SingleEventContractProcessor;
import blue.contract.StepProcessorProvider;
import blue.contract.debug.DebugContext;
import blue.contract.model.ContractInstance;
import blue.contract.model.ContractUpdateAction;
import blue.contract.model.GenericContract;
import blue.contract.model.event.AgreedUponSimulatedEvent;
import blue.contract.model.event.ContractProcessingEvent;
import blue.contract.model.subscription.ContractSubscription;
import blue.contract.model.subscription.LocalContractSubscription;
import blue.language.Blue;
import blue.language.model.Node;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;

public class ContractProcessor {
    private final SingleEventContractProcessor singleEventProcessor;
    private final Blue blue;
    private final DebugContext debugContext;

    public ContractProcessor(StepProcessorProvider stepProcessorProvider, Blue blue) {
        this(stepProcessorProvider, blue, new DebugContext(false));
    }

    public ContractProcessor(StepProcessorProvider stepProcessorProvider, Blue blue, DebugContext debugContext) {
        this.singleEventProcessor = new SingleEventContractProcessor(stepProcessorProvider, blue, debugContext);
        this.blue = blue;
        this.debugContext = debugContext;
    }

    public List<ContractUpdateAction> initiate(Node contract, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId) {
        ArrayList<ContractUpdateAction> result = new ArrayList<ContractUpdateAction>();
        ContractUpdateAction initialAction = this.singleEventProcessor.initiate(contract, initiateContractEntryBlueId, initiateContractProcessingEntryBlueId);
        initialAction.epoch(0);
        result.add(initialAction);
        this.processAdditionalEvents(initialAction.getContractInstance(), result, initiateContractEntryBlueId, initiateContractProcessingEntryBlueId, 1);
        return result;
    }

    public List<ContractUpdateAction> processEvent(Node event, ContractInstance contractInstance, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId, int epoch) {
        ArrayList<ContractUpdateAction> actions = new ArrayList<ContractUpdateAction>();
        ContractUpdateAction initialAction = this.singleEventProcessor.processEvent(event, contractInstance, initiateContractEntryBlueId, initiateContractProcessingEntryBlueId);
        initialAction.epoch(epoch);
        actions.add(initialAction);
        this.processAdditionalEvents(initialAction.getContractInstance(), actions, initiateContractEntryBlueId, initiateContractProcessingEntryBlueId, epoch + 1);
        return actions;
    }

    private void processAdditionalEvents(ContractInstance contractInstance, List<ContractUpdateAction> actions, String initiateContractEntryBlueId, String initiateContractProcessingEntryBlueId, int startingEpoch) {
        ContractUpdateAction lastAction = actions.get(actions.size() - 1);
        if (lastAction.getEmittedEvents() == null || lastAction.getEmittedEvents().isEmpty()) {
            return;
        }
        List<ContractSubscription> mergedSubscriptions = this.mergeSubscriptions(contractInstance);
        LinkedList<Node> eventsToProcess = new LinkedList<Node>();
        this.processEmittedEvents(lastAction.getEmittedEvents(), eventsToProcess);
        int currentEpoch = startingEpoch;
        while (!eventsToProcess.isEmpty()) {
            Node event = ((Node)eventsToProcess.poll()).clone();
            Optional<AgreedUponSimulatedEvent> agreedUponEvent = this.extractAgreedUponSimulatedEvent(event);
            boolean isAgreedUponEvent = agreedUponEvent.isPresent();
            if (!isAgreedUponEvent && !this.subscriptionApplies(event, mergedSubscriptions)) continue;
            if (isAgreedUponEvent) {
                event = agreedUponEvent.get().getEvent();
            }
            ContractUpdateAction newAction = this.singleEventProcessor.processEvent(event, lastAction.getContractInstance(), initiateContractEntryBlueId, initiateContractProcessingEntryBlueId);
            newAction.epoch(currentEpoch++);
            actions.add(newAction);
            lastAction = newAction;
            if (newAction.getEmittedEvents() == null || newAction.getEmittedEvents().isEmpty()) continue;
            this.processEmittedEvents(newAction.getEmittedEvents(), eventsToProcess);
        }
    }

    private void processEmittedEvents(List<Node> emittedEvents, Queue<Node> eventsToProcess) {
        for (Node emittedEvent : emittedEvents) {
            Optional<AgreedUponSimulatedEvent> agreedUponSimulatedEvent = this.extractAgreedUponSimulatedEvent(emittedEvent);
            if (agreedUponSimulatedEvent.isPresent()) {
                eventsToProcess.add(agreedUponSimulatedEvent.get().getEvent());
                eventsToProcess.add(emittedEvent);
                continue;
            }
            eventsToProcess.add(emittedEvent);
        }
    }

    private Optional<AgreedUponSimulatedEvent> extractAgreedUponSimulatedEvent(Node event) {
        return this.blue.determineClass(event).filter(ContractProcessingEvent.class::equals).map(clazz -> (ContractProcessingEvent)this.blue.nodeToObject(event, ContractProcessingEvent.class)).map(ContractProcessingEvent::getEvent).flatMap(innerEvent -> this.blue.determineClass(innerEvent).filter(AgreedUponSimulatedEvent.class::equals).map(clazz -> (AgreedUponSimulatedEvent)this.blue.nodeToObject(innerEvent, AgreedUponSimulatedEvent.class)));
    }

    private List<ContractSubscription> mergeSubscriptions(ContractInstance contractInstance) {
        ArrayList<ContractSubscription> mergedSubscriptions = new ArrayList<ContractSubscription>();
        GenericContract mainContract = (GenericContract)this.blue.nodeToObject(contractInstance.getContractState(), GenericContract.class);
        if (mainContract.getSubscriptions() != null) {
            mergedSubscriptions.addAll(mainContract.getSubscriptions());
        }
        if (contractInstance.getProcessingState().getLocalContractInstances() != null) {
            for (ContractInstance localInstance : contractInstance.getProcessingState().getLocalContractInstances()) {
                GenericContract localContract = (GenericContract)this.blue.nodeToObject(localInstance.getContractState(), GenericContract.class);
                if (localContract.getSubscriptions() == null) continue;
                mergedSubscriptions.addAll(localContract.getSubscriptions());
            }
        }
        return mergedSubscriptions;
    }

    private boolean subscriptionApplies(Node event, List<ContractSubscription> subscriptions) {
        return this.blue.determineClass(event).filter(ContractProcessingEvent.class::equals).map(clazz -> (ContractProcessingEvent)this.blue.nodeToObject(event, ContractProcessingEvent.class)).map(contractProcessingEvent -> subscriptions.stream().filter(LocalContractSubscription.class::isInstance).map(LocalContractSubscription.class::cast).anyMatch(subscription -> this.subscriptionMatchesEvent((LocalContractSubscription)subscription, (ContractProcessingEvent)contractProcessingEvent))).orElse(false);
    }

    private boolean subscriptionMatchesEvent(LocalContractSubscription subscription, ContractProcessingEvent event) {
        return Optional.of(true).filter(__ -> this.matchesContractInstance(subscription, event)).filter(__ -> this.matchesWorkflowInstance(subscription, event)).filter(__ -> this.matchesEventType(subscription, event)).isPresent();
    }

    private boolean matchesContractInstance(LocalContractSubscription subscription, ContractProcessingEvent event) {
        return subscription.getContractInstanceId() == null || subscription.getContractInstanceId().equals(event.getContractInstanceId());
    }

    private boolean matchesWorkflowInstance(LocalContractSubscription subscription, ContractProcessingEvent event) {
        return subscription.getWorkflowInstanceId() == null || subscription.getWorkflowInstanceId().equals(event.getWorkflowInstanceId());
    }

    private boolean matchesEventType(LocalContractSubscription subscription, ContractProcessingEvent event) {
        return subscription.getEvent() == null || this.blue.nodeMatchesType(event.getEvent(), subscription.getEvent());
    }

    public SingleEventContractProcessor getSingleEventProcessor() {
        return this.singleEventProcessor;
    }
}

