/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 100;
    private int len;
    private int bumpLen;
    private byte[] buf;

    public FastOutputStream() {
        this.buf = null;
    }

    public FastOutputStream(int initialSize) {
        this.initBuffer(initialSize, 100);
    }

    public FastOutputStream(int initialSize, int bumpSize) {
        this.initBuffer(initialSize, bumpSize);
    }

    public FastOutputStream(byte[] buffer) {
        this.buf = buffer;
        this.bumpLen = 100;
    }

    public FastOutputStream(byte[] buffer, int bumpSize) {
        this.buf = buffer;
        this.bumpLen = bumpSize;
    }

    private void initBuffer(int bufferSize, int bumpLen) {
        this.buf = new byte[bufferSize];
        this.bumpLen = bumpLen;
    }

    private void checkBuf(byte[] fromBuf) {
        if (this.buf == null) {
            if (fromBuf == null) {
                this.initBuffer(100, 100);
            } else {
                this.buf = new byte[fromBuf.length];
                this.bumpLen = 100;
            }
        }
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    public void write(int b) throws IOException {
        this.checkBuf(null);
        this.writeFast(b);
    }

    public void write(byte[] fromBuf) throws IOException {
        this.checkBuf(fromBuf);
        this.writeFast(fromBuf);
    }

    public void write(byte[] fromBuf, int offset, int length) throws IOException {
        this.checkBuf(fromBuf);
        this.writeFast(fromBuf, offset, length);
    }

    public void writeTo(OutputStream out) throws IOException {
        this.checkBuf(null);
        out.write(this.buf, 0, this.len);
    }

    public String toString() {
        this.checkBuf(null);
        return new String(this.buf, 0, this.len);
    }

    public String toString(String encoding) throws UnsupportedEncodingException {
        this.checkBuf(null);
        return new String(this.buf, 0, this.len, encoding);
    }

    public byte[] toByteArray() {
        this.checkBuf(null);
        byte[] toBuf = new byte[this.len];
        int i = 0;
        while (i < this.len) {
            toBuf[i] = this.buf[i];
            ++i;
        }
        return toBuf;
    }

    public final void writeFast(int b) {
        this.checkBuf(null);
        if (this.len + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.len++] = (byte)b;
    }

    public final void writeFast(byte[] fromBuf) {
        this.checkBuf(fromBuf);
        int needed = this.len + fromBuf.length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        int i = 0;
        while (i < fromBuf.length) {
            this.buf[this.len++] = fromBuf[i];
            ++i;
        }
    }

    public final void writeFast(byte[] fromBuf, int offset, int length) {
        this.checkBuf(fromBuf);
        int needed = this.len + length - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
        int fromLen = offset + length;
        int i = offset;
        while (i < fromLen) {
            this.buf[this.len++] = fromBuf[i];
            ++i;
        }
    }

    public void toByteArray(byte[] toBuf, int offset) {
        this.checkBuf(null);
        int toLen = toBuf.length > this.len ? this.len : toBuf.length;
        int i = offset;
        while (i < toLen) {
            toBuf[i] = this.buf[i];
            ++i;
        }
    }

    public byte[] getBufferBytes() {
        this.checkBuf(null);
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void makeSpace(int sizeNeeded) {
        this.checkBuf(null);
        int needed = this.len + sizeNeeded - this.buf.length;
        if (needed > 0) {
            this.bump(needed);
        }
    }

    public void addSize(int sizeAdded) {
        this.len += sizeAdded;
    }

    private void bump(int needed) {
        this.checkBuf(null);
        byte[] toBuf = new byte[this.buf.length + needed + this.bumpLen];
        int i = 0;
        while (i < this.len) {
            toBuf[i] = this.buf[i];
            ++i;
        }
        this.buf = toBuf;
    }
}

