/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class DaemonThread
extends Thread {
    private static final int JOIN_MILLIS = 10;
    private long waitTime;
    private Object synchronizer = new Object();
    private boolean shutdownRequest = false;
    private boolean paused = false;
    protected String name;
    protected Set workQueue;
    protected Latch workQueueLatch;
    protected int nWakeupRequests;

    public DaemonThread(long waitTime, String name, EnvironmentImpl env) {
        this.waitTime = waitTime;
        this.name = name;
        this.workQueue = new HashSet();
        this.workQueueLatch = new Latch(name + " work queue", env);
        this.setDaemon(true);
    }

    public void runOrPause(boolean run) {
        if (run) {
            this.paused = false;
            if (this.isAlive()) {
                this.wakeup();
            } else {
                this.start();
            }
        } else {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequest = true;
        while (this.isAlive()) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notifyAll();
            }
            try {
                this.join(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DaemonThread name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        this.workQueueLatch.acquire();
        this.workQueue.add(o);
        this.wakeup();
        this.workQueueLatch.release();
    }

    public int getQueueSize() throws DatabaseException {
        this.workQueueLatch.acquire();
        int count = this.workQueue.size();
        this.workQueueLatch.release();
        return count;
    }

    public void addToQueueAlreadyLatched(Collection c) throws DatabaseException {
        this.workQueue.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (!this.paused) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdownRequest) {
            try {
                Object object;
                this.workQueueLatch.acquire();
                boolean nothingToDo = this.workQueue.size() == 0;
                this.workQueueLatch.release();
                if (nothingToDo) {
                    object = this.synchronizer;
                    synchronized (object) {
                        if (this.waitTime == 0L) {
                            this.synchronizer.wait();
                        } else {
                            this.synchronizer.wait(this.waitTime);
                        }
                    }
                }
                if (this.shutdownRequest) break;
                if (this.paused) {
                    object = this.synchronizer;
                    synchronized (object) {
                        this.synchronizer.wait();
                        continue;
                    }
                }
                int numTries = 0;
                int maxRetries = this.nDeadlockRetries();
                while (true) {
                    try {
                        ++this.nWakeupRequests;
                        this.onWakeup();
                    }
                    catch (DeadlockException e) {
                        if (!this.shutdownRequest && ++numTries <= maxRetries) continue;
                    }
                    break;
                }
                if (!this.shutdownRequest) {
                    Object object2 = this.synchronizer;
                    synchronized (object2) {
                        if (this.waitTime == 0L) {
                            this.synchronizer.wait();
                        } else {
                            this.synchronizer.wait(this.waitTime);
                        }
                        continue;
                    }
                }
                break;
            }
            catch (DatabaseException DBE) {
                System.out.println("Shutting down " + this + " due to exception: " + DBE);
                DBE.printStackTrace(System.out);
                this.shutdownRequest = true;
            }
            catch (InterruptedException IE) {
                System.err.println("Shutting down " + this + " due to exception: " + IE);
                this.shutdownRequest = true;
            }
        }
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return 0;
    }

    protected abstract void onWakeup() throws DatabaseException;

    protected boolean isShutdownRequested() {
        return this.shutdownRequest;
    }

    public int getNWakeupRequests() {
        return this.nWakeupRequests;
    }
}

