/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.util.DbVerify;
import java.io.File;

public class DbStat
extends DbVerify {
    private String usageString = "usage: DbStat [-V]\n               -s database -h dbEnvHome\n";

    public static void main(String[] argv) throws DatabaseException {
        DbStat verifier = new DbStat();
        verifier.parseArgs(argv);
        int ret = 0;
        try {
            if (!verifier.verify(System.err)) {
                ret = 1;
            }
        }
        catch (Throwable T) {
            ret = 1;
            T.printStackTrace(System.err);
        }
        try {
            verifier.env.close();
        }
        catch (Throwable T) {
            // empty catch block
        }
        System.exit(ret);
    }

    protected DbStat() {
    }

    public DbStat(Environment env, String dbName) {
        super(env, dbName, false);
    }

    protected void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(this.usageString);
        System.exit(-1);
    }

    protected void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (!thisArg.equals("-s")) continue;
            if (argc < nArgs) {
                this.dbName = argv[argc++];
                continue;
            }
            this.printUsage("-s requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (this.dbName == null) {
            this.printUsage("-s is a required argument");
        }
    }

    protected void openEnv() throws DatabaseException {
        if (this.env == null) {
            this.env = new Environment(this.envHome, null);
        }
    }
}

