/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedMap;

public class DbSpace {
    private static final String USAGE = "usage: java " + (class$com$sleepycat$je$util$DbSpace == null ? (class$com$sleepycat$je$util$DbSpace = DbSpace.class$("com.sleepycat.je.util.DbSpace")) : class$com$sleepycat$je$util$DbSpace).getName() + "\n" + "       -h <dir> # environment home directory\n" + "       [-q]     # quiet, print grand totals only\n" + "       [-u]     # sort by utilization\n" + "       [-V]     # print JE version number";
    private File envHome = null;
    private Environment env;
    private boolean quiet = false;
    private boolean sorted = false;
    static /* synthetic */ Class class$com$sleepycat$je$util$DbSpace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws DatabaseException {
        DbSpace space = new DbSpace();
        space.parseArgs(argv);
        try {
            try {
                space.print(System.out);
                System.exit(0);
            }
            catch (Throwable T) {
                if (space.quiet) {
                    System.exit(1);
                } else {
                    T.printStackTrace(System.err);
                }
                Object var4_3 = null;
                space.env.close();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            space.env.close();
            throw throwable;
        }
        space.env.close();
    }

    private DbSpace() {
    }

    public DbSpace(Environment env, boolean quiet, boolean sorted) {
        this.env = env;
        this.quiet = quiet;
        this.sorted = sorted;
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-u")) {
                this.sorted = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (!thisArg.equals("-h")) continue;
            if (argc < nArgs) {
                this.envHome = new File(argv[argc++]);
                continue;
            }
            this.printUsage("-h requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    private void openEnv() throws DatabaseException {
        if (this.env == null) {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(true);
            this.env = new Environment(this.envHome, envConfig);
        }
    }

    public void print(PrintStream out) throws DatabaseException {
        this.openEnv();
        SortedMap map = DbInternal.envGetEnvironmentImpl(this.env).getUtilizationProfile().getFileSummaryMap();
        Summary totals = new Summary();
        Object[] summaries = null;
        if (!this.quiet) {
            summaries = new Summary[map.size()];
        }
        int nextIndex = 0;
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Long fileNum = (Long)i.next();
            Summary summary = new Summary(fileNum, (FileSummary)map.get(fileNum));
            if (summaries != null) {
                summaries[nextIndex++] = summary;
            }
            totals.add(summary);
        }
        out.println("  File    Size (KB)  % Used\n--------  ---------  ------");
        if (summaries != null) {
            if (this.sorted) {
                Arrays.sort(summaries);
            }
            int i2 = 0;
            while (i2 < summaries.length) {
                ((Summary)summaries[i2]).print(out);
                ++i2;
            }
        }
        totals.print(out);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Summary
    implements Comparable {
        static final String HEADER = "  File    Size (KB)  % Used\n--------  ---------  ------";
        Long fileNum;
        long totalSize;
        long obsoleteSize;

        Summary() {
        }

        Summary(Long fileNum, FileSummary summary) {
            this.fileNum = fileNum;
            this.totalSize = summary.totalSize;
            this.obsoleteSize = summary.getObsoleteSize();
        }

        public int compareTo(Object other) {
            Summary o = (Summary)other;
            return this.utilization() - o.utilization();
        }

        void add(Summary o) {
            this.totalSize += o.totalSize;
            this.obsoleteSize += o.obsoleteSize;
        }

        void print(PrintStream out) {
            if (this.fileNum != null) {
                this.pad(out, Long.toHexString(this.fileNum), 8, '0');
            } else {
                out.print(" TOTALS ");
            }
            int kb = (int)(this.totalSize / 1024L);
            int util = this.utilization();
            out.print("  ");
            this.pad(out, Integer.toString(kb), 9, ' ');
            out.print("     ");
            this.pad(out, Integer.toString(util), 3, ' ');
            out.println();
        }

        int utilization() {
            return UtilizationProfile.utilization(this.obsoleteSize, this.totalSize);
        }

        private void pad(PrintStream out, String val, int digits, char padChar) {
            int padSize = digits - val.length();
            int i = 0;
            while (i < padSize) {
                out.print(padChar);
                ++i;
            }
            out.print(val);
        }
    }
}

