/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;

public class DbRecover {
    public static void main(String[] argv) {
        try {
            int whichArg = 0;
            boolean seenFile = false;
            boolean seenOffset = false;
            long truncateFileNum = -1L;
            long truncateOffset = -1L;
            File envHome = new File(".");
            while (whichArg < argv.length) {
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                } else if (nextArg.equals("-f")) {
                    truncateFileNum = CmdUtil.readLongNumber(CmdUtil.getArg(argv, ++whichArg));
                    seenFile = true;
                } else if (nextArg.equals("-o")) {
                    truncateOffset = CmdUtil.readLongNumber(CmdUtil.getArg(argv, ++whichArg));
                    seenOffset = true;
                } else {
                    throw new IllegalArgumentException(nextArg + " is not a supported option.");
                }
                ++whichArg;
            }
            if (!seenFile || !seenOffset) {
                DbRecover.usage();
                System.exit(1);
            }
            EnvironmentImpl env = CmdUtil.makeUtilityEnvironment(envHome, false);
            env.getFileManager().truncateLog(truncateFileNum, truncateOffset);
            env.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            DbRecover.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: DbRecover -h <environment home> (optional)");
        System.out.println("                 -f <file number, in hex>");
        System.out.println("                 -o <offset, in hex>");
        System.out.println("Log file is truncated at position starting at and inclusive of the offset. Beware, not  for general purpose use yet!");
    }
}

