/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockTimeOutException;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnTimeOutException;
import com.sleepycat.je.utilint.Tracer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class LockManager {
    protected Latch lockTableLatch;
    private Map lockTable = new HashMap();
    private EnvironmentImpl env;
    private Level traceLevel;
    private long nWaits;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$txn$LockManager;

    public LockManager(EnvironmentImpl env) throws DatabaseException {
        this.lockTableLatch = new Latch("Lock Table", env);
        this.env = env;
        this.nWaits = 0L;
        this.traceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_LOCKMGR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType lock(long nodeId, Locker locker, LockType type, long timeout, boolean nonBlockingRequest) throws DeadlockException, LockNotGrantedException, DatabaseException {
        if (!$assertionsDisabled && timeout < 0L) {
            throw new AssertionError();
        }
        Locker locker2 = locker;
        synchronized (locker2) {
            LockAttemptResult result = this.attemptLock(nodeId, locker, type, nonBlockingRequest);
            if (result.success) {
                return result.lockGrant;
            }
            if (!$assertionsDisabled && !this.checkNoLatchesHeld(nonBlockingRequest)) {
                throw new AssertionError((Object)(Latch.countLatchesHeld() + " latches held while trying to lock, lock table =" + Latch.latchesHeldToString()));
            }
            try {
                boolean doWait = true;
                Long nid = new Long(nodeId);
                if (locker.isTimedOut()) {
                    if (this.validateOwnership(nid, locker, type, true)) {
                        doWait = false;
                    } else {
                        String errMsg = this.makeTimeoutMsg("Locker", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeOut(), locker.getTxnStartMillis(), System.currentTimeMillis());
                        throw new TxnTimeOutException(errMsg);
                    }
                }
                boolean keepTime = timeout > 0L;
                long startTime = keepTime ? System.currentTimeMillis() : 0L;
                while (doWait) {
                    boolean thisLockTimedOut;
                    locker.setWaitingFor(result.useLock);
                    try {
                        locker.wait(timeout);
                    }
                    catch (InterruptedException IE) {
                        throw new RunRecoveryException(this.env, (Throwable)IE);
                    }
                    boolean lockerTimedOut = locker.isTimedOut();
                    long now = System.currentTimeMillis();
                    boolean bl = thisLockTimedOut = keepTime && now - startTime > timeout;
                    if (this.validateOwnership(nid, locker, type, lockerTimedOut | thisLockTimedOut)) break;
                    if (thisLockTimedOut) {
                        String errMsg = this.makeTimeoutMsg("Lock", locker, nodeId, type, result.lockGrant, result.useLock, timeout, startTime, now);
                        throw new LockTimeOutException(errMsg);
                    }
                    if (!lockerTimedOut) continue;
                    String errMsg = this.makeTimeoutMsg("Locker", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeOut(), locker.getTxnStartMillis(), now);
                    throw new TxnTimeOutException(errMsg);
                }
                Object var21_19 = null;
                locker.setWaitingFor(null);
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                locker.setWaitingFor(null);
                if (EnvironmentImpl.getForcedYield()) {
                    Thread.yield();
                }
                throw throwable;
            }
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
            locker.addLock(nodeId, result.useLock, type, result.lockGrant);
            return result.lockGrant;
        }
    }

    protected abstract LockAttemptResult attemptLock(long var1, Locker var3, LockType var4, boolean var5) throws DatabaseException;

    protected LockAttemptResult attemptLockInternal(long nodeId, Locker locker, LockType type, boolean nonBlockingRequest) throws DatabaseException {
        Long nid = new Long(nodeId);
        Lock useLock = (Lock)this.lockTable.get(nid);
        if (useLock == null) {
            useLock = new Lock(nodeId);
            this.lockTable.put(nid, useLock);
        }
        LockGrantType lockGrant = useLock.lock(type, locker, nonBlockingRequest);
        boolean success = false;
        if (lockGrant == LockGrantType.NEW || lockGrant == LockGrantType.PROMOTION) {
            locker.addLock(nodeId, useLock, type, lockGrant);
            success = true;
        } else if (lockGrant == LockGrantType.EXISTING) {
            success = true;
        } else {
            if (lockGrant == LockGrantType.DENIED) {
                throw new LockNotGrantedException("Non-blocking lock was denied.");
            }
            ++this.nWaits;
        }
        return new LockAttemptResult(useLock, lockGrant, success);
    }

    protected abstract String makeTimeoutMsg(String var1, Locker var2, long var3, LockType var5, LockGrantType var6, Lock var7, long var8, long var10, long var12) throws DatabaseException;

    protected String makeTimeoutMsgInternal(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now) {
        StringBuffer sb = new StringBuffer();
        sb.append(lockOrTxn);
        sb.append(" expired. Locker").append(locker);
        sb.append(": waited for lock on node=").append(nodeId);
        sb.append(" type=").append(type);
        sb.append(" grant=").append(grantType);
        sb.append(" timeoutMillis=").append(timeout);
        sb.append(" startTime=").append(start);
        sb.append(" endTime=").append(now);
        sb.append("\nOwners: ").append(useLock.getOwnersClone());
        sb.append("\nWaiters: ").append(useLock.getWaitersListClone()).append("\n");
        StringBuffer deadlockInfo = this.findDeadlock(useLock, locker);
        if (deadlockInfo != null) {
            sb.append(deadlockInfo);
        }
        return sb.toString();
    }

    public void release(long nodeId, Locker locker) throws DatabaseException {
        this.release(nodeId, null, locker, true);
    }

    public void release(Lock lock, Locker locker) throws DatabaseException {
        this.release(-1L, lock, locker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(long nodeId, Lock lock, Locker locker, boolean removeFromLocker) throws DatabaseException {
        Locker locker2 = locker;
        synchronized (locker2) {
            Set newOwners = this.releaseAndFindNotifyTargets(nodeId, lock, locker, removeFromLocker);
            if (newOwners != null) {
                Iterator iter = newOwners.iterator();
                while (iter.hasNext()) {
                    Locker pendingOwner;
                    LockInfo o = (LockInfo)iter.next();
                    Locker locker3 = pendingOwner = o.getLocker();
                    synchronized (locker3) {
                        pendingOwner.notifyAll();
                    }
                    if (!EnvironmentImpl.getForcedYield()) continue;
                    Thread.yield();
                }
            }
        }
    }

    protected abstract Set releaseAndFindNotifyTargets(long var1, Lock var3, Locker var4, boolean var5) throws DatabaseException;

    protected Set releaseAndFindNotifyTargetsInternal(long nodeId, Lock lock, Locker locker, boolean removeFromLocker) throws DatabaseException {
        Set newOwners = null;
        boolean notifyNewOwners = false;
        Lock useLock = lock;
        if (useLock == null) {
            useLock = (Lock)this.lockTable.get(new Long(nodeId));
        }
        if (useLock == null) {
            return null;
        }
        int releaseStatus = useLock.release(locker);
        if (releaseStatus == 1) {
            notifyNewOwners = true;
        } else if (releaseStatus == 0) {
            return null;
        }
        if (removeFromLocker) {
            if (!$assertionsDisabled && nodeId == -1L) {
                throw new AssertionError();
            }
            locker.removeLock(nodeId, useLock);
        }
        if (useLock.nWaiters() == 0 && useLock.nOwners() == 0) {
            this.lockTable.remove(new Long(useLock.getNodeId()));
        }
        if (notifyNewOwners) {
            newOwners = useLock.getOwnersClone();
        }
        return newOwners;
    }

    abstract void transfer(long var1, Locker var3, Locker var4, boolean var5) throws DatabaseException;

    protected void transferInternal(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        Lock useLock = (Lock)this.lockTable.get(new Long(nodeId));
        if (!$assertionsDisabled && useLock == null) {
            throw new AssertionError((Object)("Transfer, lock " + nodeId + " was null"));
        }
        if (demoteToRead) {
            useLock.demote(owningLocker);
        }
        LockType lockType = useLock.transfer(owningLocker, destLocker);
        owningLocker.removeLock(nodeId, useLock);
    }

    abstract void transferMultiple(long var1, Locker var3, Locker[] var4) throws DatabaseException;

    protected void transferMultipleInternal(long nodeId, Locker owningLocker, Locker[] destLockers) throws DatabaseException {
        Lock useLock = (Lock)this.lockTable.get(new Long(nodeId));
        if (!$assertionsDisabled && useLock == null) {
            throw new AssertionError((Object)("Transfer, lock " + nodeId + " was null"));
        }
        useLock.demote(owningLocker);
        LockType lockType = useLock.transferMultiple(owningLocker, destLockers);
        owningLocker.removeLock(nodeId, useLock);
    }

    abstract void demote(long var1, Locker var3) throws DatabaseException;

    protected void demoteInternal(long nodeId, Locker locker) throws DatabaseException {
        Lock useLock = (Lock)this.lockTable.get(new Long(nodeId));
        useLock.demote(locker);
        locker.moveWriteToReadLock(nodeId, useLock);
    }

    abstract boolean isLocked(Long var1) throws DatabaseException;

    protected boolean isLockedInternal(Long nodeId) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.nOwners() != 0;
    }

    abstract boolean isOwner(Long var1, Locker var2, LockType var3) throws DatabaseException;

    protected boolean isOwnerInternal(Long nodeId, Locker locker, LockType type) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isOwner(locker, type);
    }

    abstract boolean isWaiter(Long var1, Locker var2) throws DatabaseException;

    protected boolean isWaiterInternal(Long nodeId, Locker locker) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isWaiter(locker);
    }

    abstract int nWaiters(Long var1) throws DatabaseException;

    protected int nWaitersInternal(Long nodeId) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nWaiters();
    }

    abstract int nOwners(Long var1) throws DatabaseException;

    protected int nOwnersInternal(Long nodeId) {
        Lock entry = (Lock)this.lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nOwners();
    }

    abstract Locker getWriteOwnerLocker(Long var1) throws DatabaseException;

    protected Locker getWriteOwnerLockerInternal(Long nodeId) throws DatabaseException {
        Lock lock = (Lock)this.lockTable.get(nodeId);
        if (lock == null) {
            return null;
        }
        if (lock.nOwners() > 1) {
            return null;
        }
        return lock.getWriteOwnerLocker();
    }

    protected abstract boolean validateOwnership(Long var1, Locker var2, LockType var3, boolean var4) throws DatabaseException;

    protected boolean validateOwnershipInternal(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters) throws DatabaseException {
        Lock entry;
        if (this.isOwnerInternal(nodeId, locker, type)) {
            return true;
        }
        if (flushFromWaiters && (entry = (Lock)this.lockTable.get(nodeId)) != null) {
            entry.flushWaiter(locker);
        }
        return false;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        LockStats stats = new LockStats();
        stats.setNWaits(this.nWaits);
        if (config.getClear()) {
            this.nWaits = 0L;
        }
        LatchStats latchStats = this.lockTableLatch.getLatchStats();
        stats.setLockTableLatchStats(latchStats);
        if (!config.getFast()) {
            this.dumpLockTable(stats);
        }
        return stats;
    }

    protected abstract void dumpLockTable(LockStats var1) throws DatabaseException;

    protected void dumpLockTableInternal(LockStats stats) {
        stats.setNTotalLocks(this.lockTable.size());
        Iterator iter = this.lockTable.values().iterator();
        while (iter.hasNext()) {
            Lock lock = (Lock)iter.next();
            stats.setNWaiters(stats.getNWaiters() + lock.nWaiters());
            stats.setNOwners(stats.getNOwners() + lock.nOwners());
            Iterator ownerIter = lock.getOwnersClone().iterator();
            while (ownerIter.hasNext()) {
                LockInfo info = (LockInfo)ownerIter.next();
                if (info.isReadLock()) {
                    stats.setNReadLocks(stats.getNReadLocks() + 1);
                    continue;
                }
                stats.setNWriteLocks(stats.getNWriteLocks() + 1);
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpToString());
    }

    public String dumpToString() throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        this.lockTableLatch.acquire();
        Iterator keys = this.lockTable.keySet().iterator();
        while (keys.hasNext()) {
            Long nid = (Long)keys.next();
            Lock entry = (Lock)this.lockTable.get(nid);
            sb.append("---- Node Id: ").append(nid).append("----\n");
            sb.append(entry);
            sb.append('\n');
        }
        this.lockTableLatch.release();
        return sb.toString();
    }

    private boolean checkNoLatchesHeld(boolean nonBlockingRequest) {
        if (nonBlockingRequest) {
            return true;
        }
        return Latch.countLatchesHeld() == 0;
    }

    private StringBuffer findDeadlock(Lock lock, Locker rootLocker) {
        HashSet<Locker> ownerSet = new HashSet<Locker>();
        ownerSet.add(rootLocker);
        StringBuffer ret = this.findDeadlock1(ownerSet, lock, rootLocker);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private StringBuffer findDeadlock1(Set ownerSet, Lock lock, Locker rootLocker) {
        Iterator ownerIter = lock.getOwnersClone().iterator();
        while (ownerIter.hasNext()) {
            LockInfo info = (LockInfo)ownerIter.next();
            Locker locker = info.getLocker();
            Lock waitsFor = locker.getWaitingFor();
            if (ownerSet.contains(locker) || locker == rootLocker) {
                StringBuffer ret = new StringBuffer();
                ret.append("Transaction ").append(locker.toString());
                ret.append(" owns ").append(lock.getNodeId());
                ret.append(" ").append(info).append("\n");
                ret.append("Transaction ").append(locker.toString());
                ret.append(" waits for ");
                if (waitsFor == null) {
                    ret.append(" nothing");
                } else {
                    ret.append(" node ");
                    ret.append(waitsFor.getNodeId());
                }
                ret.append("\n");
                return ret;
            }
            if (waitsFor == null) continue;
            ownerSet.add(locker);
            StringBuffer sb = this.findDeadlock1(ownerSet, waitsFor, rootLocker);
            if (sb != null) {
                String waitInfo = "Transaction " + locker + " waits for node " + waitsFor.getNodeId() + "\n";
                sb.insert(0, waitInfo);
                return sb;
            }
            ownerSet.remove(locker);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$txn$LockManager == null ? (class$com$sleepycat$je$txn$LockManager = LockManager.class$("com.sleepycat.je.txn.LockManager")) : class$com$sleepycat$je$txn$LockManager).desiredAssertionStatus();
    }

    class LockAttemptResult {
        boolean success;
        Lock useLock;
        LockGrantType lockGrant;

        LockAttemptResult(Lock useLock, LockGrantType lockGrant, boolean success) {
            this.useLock = useLock;
            this.lockGrant = lockGrant;
            this.success = success;
        }
    }
}

