/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.utilint.DbLsn;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BasicLocker
extends Locker {
    private Lock ownedLock;
    private Set ownedLockSet;

    public BasicLocker(EnvironmentImpl env) throws DatabaseException {
        super(env, false, false);
    }

    protected long generateId(TxnManager txnManager) {
        return -1L;
    }

    public LockResult writeLock(LN ln, DatabaseImpl database) throws DatabaseException {
        return new LockResult(this.lockManager.lock(ln.getNodeId(), this, LockType.WRITE, this.lockTimeOutMillis, this.defaultNoWait), null);
    }

    public LockGrantType nonBlockingWriteLock(LN ln) throws DatabaseException {
        long nodeId = ln.getNodeId();
        try {
            return this.lockManager.lock(nodeId, this, LockType.WRITE, 0L, true);
        }
        catch (LockNotGrantedException e) {
            return LockGrantType.DENIED;
        }
    }

    public DbLsn getOwnerAbortLsn(long nodeId) throws DatabaseException {
        Locker ownerTxn = this.lockManager.getWriteOwnerLocker(new Long(nodeId));
        if (ownerTxn != null) {
            return ownerTxn.getAbortLsn(nodeId);
        }
        return null;
    }

    public boolean isTransactional() {
        return false;
    }

    public Locker newInstance() throws DatabaseException {
        return new BasicLocker(this.envImpl);
    }

    public boolean sharesLocksWith(Locker txn) {
        return false;
    }

    public void operationEnd() throws DatabaseException {
        this.operationEnd(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationEnd(boolean operationOK) throws DatabaseException {
        if (this.ownedLock != null) {
            this.lockManager.release(this.ownedLock, (Locker)this);
            this.ownedLock = null;
        }
        if (this.ownedLockSet != null) {
            Iterator iter = this.ownedLockSet.iterator();
            while (iter.hasNext()) {
                Lock l = (Lock)iter.next();
                this.lockManager.release(l, (Locker)this);
            }
            this.ownedLockSet.clear();
        }
        BasicLocker basicLocker = this;
        synchronized (basicLocker) {
            if (this.deleteInfo != null && this.deleteInfo.size() > 0) {
                this.envImpl.addToCompressorQueue(this.deleteInfo);
                this.deleteInfo.clear();
            }
        }
    }

    public void setHandleLockOwner(boolean operationOK, Database dbHandle, boolean dbIsClosing) throws DatabaseException {
        if (dbHandle != null) {
            if (!dbIsClosing) {
                this.transferHandleLockToHandle(dbHandle);
            }
            this.unregisterHandle(dbHandle);
        }
    }

    public void registerCursor(CursorImpl cursor) {
    }

    public void unRegisterCursor(CursorImpl cursor) {
    }

    public DbLsn getAbortLsn(long nodeId) throws DatabaseException {
        return null;
    }

    public boolean getAbortKnownDeleted(long nodeId) throws DatabaseException {
        return true;
    }

    public void setIsDeletedAtCommit(DatabaseImpl db) throws DatabaseException {
        db.deleteAndReleaseINs();
    }

    void addLock(long nodeId, Lock lock, LockType type, LockGrantType grantStatus) throws DatabaseException {
        if (this.ownedLock == lock || this.ownedLockSet != null && this.ownedLockSet.contains(lock)) {
            return;
        }
        if (this.ownedLock == null) {
            this.ownedLock = lock;
        } else {
            if (this.ownedLockSet == null) {
                this.ownedLockSet = new HashSet();
            }
            this.ownedLockSet.add(lock);
        }
    }

    void removeLock(long nodeId, Lock lock) throws DatabaseException {
        if (lock == this.ownedLock) {
            this.ownedLock = null;
        } else if (this.ownedLockSet != null) {
            this.ownedLockSet.remove(lock);
        }
    }

    public boolean createdNode(long nodeId) {
        return false;
    }

    void moveWriteToReadLock(long nodeId, Lock lock) {
    }

    public LockStats collectStats(LockStats stats) throws DatabaseException {
        if (this.ownedLock != null) {
            if (this.ownedLock.isOwnedWriteLock(this)) {
                stats.setNWriteLocks(stats.getNWriteLocks() + 1);
            } else {
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
        if (this.ownedLockSet != null) {
            Iterator iter = this.ownedLockSet.iterator();
            while (iter.hasNext()) {
                Lock l = (Lock)iter.next();
                if (l.isOwnedWriteLock(this)) {
                    stats.setNWriteLocks(stats.getNWriteLocks() + 1);
                    continue;
                }
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
        return stats;
    }
}

