/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeStats;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tree
implements LogWritable,
LogReadable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private static final String TRACE_DUP_ROOT_SPLIT = "DupRootSplit:";
    private static final String TRACE_MUTATE = "Mut:";
    private static final String TRACE_INSERT = "Ins:";
    private static final String TRACE_INSERT_DUPLICATE = "InsD:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxEntriesPerNode;
    private Latch rootLatch;
    private TreeStats treeStats;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$tree$Tree;

    public Tree(DatabaseImpl database) throws DatabaseException {
        this.init(database);
        this.maxEntriesPerNode = this.getMaxEntriesFromConfig(database);
    }

    public Tree() {
        this.init(null);
        this.maxEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.rootLatch = new Latch("RootLatch", database != null ? database.getDbEnvironment() : null);
        this.treeStats = new TreeStats();
        this.root = null;
        this.database = database;
    }

    public void setDatabase(DatabaseImpl database) throws DatabaseException {
        this.database = database;
        this.maxEntriesPerNode = this.getMaxEntriesFromConfig(database);
    }

    private int getMaxEntriesFromConfig(DatabaseImpl database) throws DatabaseException {
        DbConfigManager configManager = database.getDbEnvironment().getConfigManager();
        return configManager.getInt(EnvironmentParams.NODE_MAX);
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot) {
        this.root = newRoot;
    }

    TreeStats getTreeStats() {
        return this.treeStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatched(WithRootLatched wrl) throws DatabaseException {
        IN iN;
        try {
            this.rootLatch.acquire();
            iN = wrl.doWork(this.root);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Key idKey) throws DatabaseException {
        boolean treeEmpty;
        block5: {
            INList inMemoryINs = this.database.getDbEnvironment().getInMemoryINs();
            treeEmpty = false;
            IN subtreeRoot = null;
            subtreeRoot = this.search(idKey, SearchType.DELETE, -1L, false);
            LogManager logManager = this.database.getDbEnvironment().getLogManager();
            if (subtreeRoot == null) {
                this.rootLatch.acquire();
                try {
                    IN rootIN = (IN)this.root.fetchTarget(this.database, null);
                    DbConfigManager configManager = this.database.getDbEnvironment().getConfigManager();
                    boolean purgeRoot = configManager.getBoolean(EnvironmentParams.COMPRESSOR_PURGE_ROOT);
                    if (purgeRoot && rootIN.getNEntries() <= 1 && rootIN.validateSubtreeBeforeDelete(0)) {
                        this.removeSubtreeFromINList(inMemoryINs, rootIN);
                        this.root = null;
                        treeEmpty = true;
                        logManager.log(new INDeleteInfo(rootIN.getNodeId(), rootIN.getIdentifierKey(), this.database.getId()));
                    }
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    this.rootLatch.release();
                    throw throwable;
                }
                this.rootLatch.release();
                {
                    break block5;
                }
            }
            int index = subtreeRoot.findEntry(idKey, false, false);
            IN subtreeRootIN = (IN)subtreeRoot.getEntry(index).fetchTarget(this.database, subtreeRoot);
            this.removeSubtreeFromINList(inMemoryINs, subtreeRootIN);
            boolean deleteOk = subtreeRoot.deleteEntry(index, true);
            if (!$assertionsDisabled && !deleteOk) {
                throw new AssertionError();
            }
            logManager.log(new INDeleteInfo(subtreeRootIN.getNodeId(), subtreeRootIN.getIdentifierKey(), this.database.getId()));
            subtreeRoot.getLatch().release();
        }
        return treeEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDup(Key idKey, Key dupKey) throws DatabaseException {
        boolean ret;
        block24: {
            int index;
            BasicLocker locker;
            DupCountLN dcl;
            boolean dupCountLNLocked;
            IN duplicateRoot;
            IN in;
            INList inMemoryINs;
            block25: {
                boolean bl;
                block26: {
                    ret = true;
                    EnvironmentImpl env = this.database.getDbEnvironment();
                    inMemoryINs = env.getInMemoryINs();
                    in = this.search(dupKey, SearchType.NORMAL, -1L, false);
                    if (!$assertionsDisabled && !in.getLatch().isOwner()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !(in instanceof BIN)) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && in.getNEntries() <= 0) {
                        throw new AssertionError();
                    }
                    duplicateRoot = null;
                    dupCountLNLocked = false;
                    dcl = null;
                    locker = new BasicLocker(env);
                    index = in.findEntry(dupKey, false, true);
                    if (index < 0) break block24;
                    ChildReference childRef = in.getEntry(index);
                    duplicateRoot = (DIN)childRef.fetchTarget(this.database, in);
                    duplicateRoot.latch();
                    ChildReference dclRef = ((DIN)duplicateRoot).getDupCountLNRef();
                    dcl = (DupCountLN)dclRef.fetchTarget(this.database, duplicateRoot);
                    if (locker.nonBlockingReadLock(dcl) != LockGrantType.DENIED) break block25;
                    bl = false;
                    if (!in.getLatch().isOwner()) break block26;
                    in.releaseLatch();
                }
                if (duplicateRoot.getLatch().isOwner()) {
                    duplicateRoot.releaseLatch();
                }
                if (dupCountLNLocked) {
                    locker.releaseLock(dcl);
                }
                return bl;
            }
            try {
                IN subtreeRoot;
                dupCountLNLocked = true;
                try {
                    subtreeRoot = this.searchSubTree(duplicateRoot, idKey, SearchType.DELETE, -1L, false);
                }
                catch (NodeNotEmptyException NNNE) {
                    in.releaseLatch();
                    throw NNNE;
                }
                if (subtreeRoot == null) {
                    block27: {
                        BIN bin = (BIN)in;
                        if (bin.nCursors() == 0) {
                            try {
                                duplicateRoot.latch();
                                if (duplicateRoot.isValidForDelete()) {
                                    this.removeSubtreeFromINList(inMemoryINs, duplicateRoot);
                                    boolean deleteOk = bin.deleteEntry(index, true);
                                    if (!$assertionsDisabled && !deleteOk) {
                                        throw new AssertionError();
                                    }
                                    if (bin.getNEntries() == 0) {
                                        this.database.getDbEnvironment().addToCompressorQueue(bin);
                                    }
                                }
                                Object var18_21 = null;
                            }
                            catch (Throwable throwable) {
                                Object var18_22 = null;
                                duplicateRoot.releaseLatch();
                                throw throwable;
                            }
                            duplicateRoot.releaseLatch();
                            {
                                break block27;
                            }
                        }
                        ret = false;
                    }
                    in.releaseLatch();
                    break block24;
                }
                try {
                    in.releaseLatch();
                    int dupIndex = subtreeRoot.findEntry(idKey, false, false);
                    IN rootIN = (IN)subtreeRoot.getEntry(dupIndex).fetchTarget(this.database, subtreeRoot);
                    this.removeSubtreeFromINList(inMemoryINs, rootIN);
                    boolean deleteOk = subtreeRoot.deleteEntry(dupIndex, true);
                    if (!$assertionsDisabled && !deleteOk) {
                        throw new AssertionError();
                    }
                    Object var20_25 = null;
                }
                catch (Throwable throwable) {
                    Object var20_26 = null;
                    subtreeRoot.getLatch().release();
                    throw throwable;
                }
                subtreeRoot.getLatch().release();
                {
                }
            }
            finally {
                if (in.getLatch().isOwner()) {
                    in.releaseLatch();
                }
                if (duplicateRoot.getLatch().isOwner()) {
                    duplicateRoot.releaseLatch();
                }
                if (dupCountLNLocked) {
                    locker.releaseLock(dcl);
                }
            }
        }
        return ret;
    }

    public IN getFirstNode() throws DatabaseException {
        return this.search(null, SearchType.LEFT, -1L, true);
    }

    public IN getLastNode() throws DatabaseException {
        return this.search(null, SearchType.RIGHT, -1L, true);
    }

    public DBIN getFirstNode(DIN duplicateRoot) throws DatabaseException {
        if (duplicateRoot == null) {
            throw new IllegalArgumentException("getFirstNode passed null root");
        }
        if (!$assertionsDisabled && !duplicateRoot.getLatch().isOwner()) {
            throw new AssertionError();
        }
        IN ret = this.searchSubTree(duplicateRoot, null, SearchType.LEFT, -1L, false);
        return (DBIN)ret;
    }

    public DBIN getLastNode(DIN duplicateRoot) throws DatabaseException {
        if (duplicateRoot == null) {
            throw new IllegalArgumentException("getLastNode passed null root");
        }
        if (!$assertionsDisabled && !duplicateRoot.getLatch().isOwner()) {
            throw new AssertionError();
        }
        IN ret = this.searchSubTree(duplicateRoot, null, SearchType.RIGHT, -1L, false);
        return (DBIN)ret;
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, List trackingList) throws DatabaseException {
        if (child == null) {
            throw new IllegalArgumentException("getParentNode passed null");
        }
        if (!$assertionsDisabled && !child.getLatch().isOwner()) {
            throw new AssertionError();
        }
        Key mainTreeKey = child.getMainTreeKey();
        Key dupTreeKey = child.getDupTreeKey();
        child.releaseLatch();
        this.rootLatch.acquire();
        IN rootIN = null;
        try {
            if (this.root != null) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                rootIN.latch();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId()));
            }
            IN potentialParent = rootIN;
            try {
                while (result.keepSearching) {
                    potentialParent.findParent(SearchType.NORMAL, requireExactMatch, result, child, mainTreeKey, dupTreeKey, trackingList);
                    potentialParent = result.parent;
                }
            }
            catch (Exception e) {
                if (potentialParent.getLatch().isOwner()) {
                    potentialParent.releaseLatch();
                }
                throw new DatabaseException(e);
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, Key mainKey, Key dupKey, LN ln, boolean splitsAllowed, boolean findDeletedEntries, boolean searchDupTree) throws DatabaseException {
        boolean found = false;
        location.bin = (BIN)this.search(mainKey, SearchType.NORMAL, ln.getNodeId(), splitsAllowed);
        if (location.bin == null) {
            return false;
        }
        boolean exactSearch = false;
        boolean indicateIfExact = true;
        if (!findDeletedEntries) {
            exactSearch = true;
            indicateIfExact = false;
        }
        location.index = location.bin.findEntry(mainKey, indicateIfExact, exactSearch);
        boolean match = false;
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            ChildReference childRef = location.bin.getEntry(location.index);
            if (!childRef.isKnownDeleted()) {
                if (!ln.containsDuplicates()) {
                    Node childNode = childRef.fetchTarget(this.database, location.bin);
                    if (childNode.containsDuplicates()) {
                        if (dupKey == null) {
                            if (searchDupTree) {
                                BIN oldBIN = location.bin;
                                if (childNode.matchLNByNodeId(location, ln.getNodeId())) {
                                    location.index &= 0xFFFEFFFF;
                                    if (oldBIN != null) {
                                        oldBIN.releaseLatch();
                                    }
                                    location.bin.latch();
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }
                        DIN duplicateRoot = (DIN)childNode;
                        duplicateRoot.latch();
                        location.bin.releaseLatch();
                        if (this.maybeSplitDuplicateRoot(location.bin, location.index)) {
                            duplicateRoot = (DIN)childRef.fetchTarget(this.database, location.bin);
                        }
                        location.lnKey = dupKey == null ? new Key(ln.getData()) : dupKey;
                        location.bin = (BIN)this.searchSubTree(duplicateRoot, location.lnKey, SearchType.NORMAL, ln.getNodeId(), true);
                        location.index = location.bin.findEntry(location.lnKey, indicateIfExact, exactSearch);
                        if (findDeletedEntries) {
                            match = location.index >= 0 && (location.index & 0x10000) != 0;
                            location.index &= 0xFFFEFFFF;
                        } else {
                            boolean bl = match = location.index >= 0;
                        }
                        if (match) {
                            childRef = location.bin.getEntry(location.index);
                        }
                    }
                } else {
                    location.lnKey = mainKey;
                    DIN duplicateRoot = (DIN)childRef.fetchTarget(this.database, location.bin);
                    childRef = duplicateRoot.getDupCountLNRef();
                }
            }
            if (location.index >= 0) {
                found = true;
                location.childLsn = childRef.getLsn();
            }
        } else {
            location.lnKey = mainKey;
        }
        return found;
    }

    public BIN getNextBin(BIN bin, DIN duplicateRoot) throws DatabaseException {
        return this.getNextBinInternal(duplicateRoot, bin, true);
    }

    public BIN getPrevBin(BIN bin, DIN duplicateRoot) throws DatabaseException {
        return this.getNextBinInternal(duplicateRoot, bin, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private BIN getNextBinInternal(DIN duplicateRoot, BIN bin, boolean forward) throws DatabaseException {
        Key idKey = null;
        int nEntries = bin.getNEntries();
        idKey = !forward || nEntries == 0 ? (nEntries == 0 ? bin.getIdentifierKey() : bin.getEntry(0).getKey()) : bin.getEntry(bin.getNEntries() - 1).getKey();
        BIN bIN = bin;
        bIN.latch();
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
            throw new AssertionError((Object)Latch.latchesHeldToString());
        }
        while (true) {
            IN parent;
            block18: {
                void var6_7;
                parent = null;
                SearchResult result = null;
                if (duplicateRoot == null) {
                    result = this.getParentINForChildIN((IN)var6_7, true);
                    if (result.exactParentFound) {
                        parent = result.parent;
                        break block18;
                    } else {
                        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                            throw new AssertionError((Object)Latch.latchesHeldToString());
                        }
                        return null;
                    }
                }
                if (var6_7 == duplicateRoot) {
                    var6_7.releaseLatch();
                    return null;
                }
                result = this.getParentINForChildIN((IN)var6_7, true);
                if (!result.exactParentFound) {
                    return null;
                }
                parent = result.parent;
            }
            if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                throw new AssertionError((Object)Latch.latchesHeldToString());
            }
            int index = parent.findEntry(idKey, false, false);
            boolean moreEntriesThisBin = false;
            if (forward) {
                if (++index < parent.getNEntries()) {
                    moreEntriesThisBin = true;
                }
            } else {
                if (index > 0) {
                    moreEntriesThisBin = true;
                }
                --index;
            }
            if (moreEntriesThisBin) {
                IN nextIN = (IN)parent.getEntry(index).fetchTarget(this.database, parent);
                nextIN.latch();
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 2) {
                    throw new AssertionError((Object)Latch.latchesHeldToString());
                }
                if (nextIN instanceof BIN) {
                    parent.releaseLatch();
                    return (BIN)nextIN;
                }
                IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, -1L, false);
                parent.releaseLatch();
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                    throw new AssertionError((Object)Latch.latchesHeldToString());
                }
                if (ret instanceof BIN) {
                    return (BIN)ret;
                }
                throw new InconsistentNodeException("subtree did not have a BIN for leaf");
            }
            IN iN = parent;
        }
    }

    private void splitRoot() throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch();
        Key rootIdKey = curRoot.getEntry(0).getKey();
        IN newRoot = new IN(this.database, rootIdKey, this.maxEntriesPerNode, curRoot.getLevel() + 1);
        newRoot.setIsRoot(true);
        curRoot.setIsRoot(false);
        DbLsn curRootLsn = curRoot.logProvisional(logManager);
        boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
        if (!$assertionsDisabled && !insertOk) {
            throw new AssertionError();
        }
        DbLsn logLsn = newRoot.log(logManager);
        inMemoryINs.add(newRoot);
        this.root.setTarget(newRoot);
        this.root.setLsn(logLsn);
        DbLsn postSplitRootLsn = curRoot.split(newRoot, 0, this.maxEntriesPerNode);
        this.root.setLsn(postSplitRootLsn);
        curRoot.releaseLatch();
        ++this.treeStats.nRootSplits;
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IN search(Key key, SearchType searchType, long nid, boolean splitsAllowed) throws DatabaseException {
        IN rootIN;
        block6: {
            this.rootLatch.acquire();
            rootIN = null;
            try {
                if (this.root != null) {
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    if (splitsAllowed && rootIN.needsSplitting()) {
                        this.splitRoot();
                        this.rootLatch.release();
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        env.getDbMapTree().modifyDbRoot(this.database);
                        this.rootLatch.acquire();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                    }
                    rootIN.latch();
                }
                Object var9_7 = null;
                if (!this.rootLatch.isOwner()) break block6;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (this.rootLatch.isOwner()) {
                    this.rootLatch.release();
                }
                throw throwable;
            }
            this.rootLatch.release();
        }
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, nid, splitsAllowed);
        }
        return null;
    }

    public IN searchSubTree(IN parent, Key key, SearchType searchType, long nid, boolean splitsAllowed) throws DatabaseException {
        if (parent == null) {
            return null;
        }
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw new IllegalArgumentException("searchSubTree passed key and left/right search");
        }
        if (searchType == SearchType.DELETE && (key == null || nid != -1L || splitsAllowed)) {
            throw new IllegalArgumentException("bad arguments for DELETE style search");
        }
        if (!$assertionsDisabled && !parent.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        boolean allLeftSideDescent = true;
        boolean allRightSideDescent = true;
        IN child = null;
        IN lowestMultipleEntryIN = null;
        do {
            int index;
            if (parent.getNEntries() == 0) {
                return parent;
            }
            if (searchType == SearchType.NORMAL) {
                index = parent.findEntry(key, false, false);
                if (index != 0) {
                    allLeftSideDescent = false;
                }
                if (index != parent.getNEntries() - 1) {
                    allRightSideDescent = false;
                }
            } else if (searchType == SearchType.LEFT) {
                index = 0;
                allRightSideDescent = false;
                allLeftSideDescent = false;
            } else if (searchType == SearchType.RIGHT) {
                index = parent.getNEntries() - 1;
                allRightSideDescent = false;
                allLeftSideDescent = false;
            } else if (searchType == SearchType.DELETE) {
                index = parent.findEntry(key, false, false);
                if (parent.getNEntries() > 1) {
                    if (lowestMultipleEntryIN != null) {
                        lowestMultipleEntryIN.releaseLatch();
                    }
                    lowestMultipleEntryIN = parent;
                }
                allRightSideDescent = false;
                allLeftSideDescent = false;
            } else {
                throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
            }
            if (!$assertionsDisabled && index < 0) {
                throw new AssertionError();
            }
            child = (IN)parent.getEntry(index).fetchTarget(this.database, parent);
            child.latch();
            if (splitsAllowed && child.needsSplitting()) {
                if (allLeftSideDescent || allRightSideDescent) {
                    child.splitSpecial(parent, index, this.maxEntriesPerNode, key, allLeftSideDescent);
                } else {
                    child.split(parent, index, this.maxEntriesPerNode);
                }
                child.releaseLatch();
                continue;
            }
            if (child.getNodeId() == nid) {
                child.releaseLatch();
                return parent;
            }
            if (parent != lowestMultipleEntryIN) {
                parent.releaseLatch();
            }
            parent = child;
        } while (!(parent instanceof BIN));
        if (searchType == SearchType.DELETE) {
            boolean notEmpty;
            boolean bl = notEmpty = child.getNEntries() != 0;
            if (child != lowestMultipleEntryIN) {
                child.releaseLatch();
            }
            if (lowestMultipleEntryIN == null) {
                return null;
            }
            if (notEmpty || ((BIN)child).nCursors() > 0) {
                lowestMultipleEntryIN.releaseLatch();
                throw new NodeNotEmptyException();
            }
            return lowestMultipleEntryIN;
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(LN ln, Key key, boolean allowDuplicates, CursorImpl cursor, LockResult lnLock) throws DatabaseException {
        block18: {
            this.validateInsertArgs(allowDuplicates);
            EnvironmentImpl env = this.database.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            BIN bin = null;
            try {
                bin = this.findBinForInsert(key, logManager, inMemoryINs);
                if (!$assertionsDisabled && !bin.getLatch().isOwner()) {
                    throw new AssertionError();
                }
                ChildReference newLNRef = new ChildReference(ln, key, new DbLsn(0L, 0L));
                cursor.setBIN(bin);
                int duplicateEntryIndex = bin.insertEntry1(newLNRef);
                if ((duplicateEntryIndex & 0x20000) != 0) {
                    lnLock.setAbortLsn(null, true, true);
                    DbLsn newLsn = ln.log(env, this.database.getId(), key, null, cursor.getLocker());
                    cursor.updateBin(bin, duplicateEntryIndex &= 0xFFFDFFFF);
                    bin.updateEntry(duplicateEntryIndex, newLsn);
                    this.traceInsert(Level.FINER, env, bin, ln, newLsn, duplicateEntryIndex);
                    break block18;
                }
                ChildReference ref = bin.getEntry(duplicateEntryIndex &= 0xFFFEFFFF);
                LN currentLN = ln;
                int dupCount = -1;
                Node n = ref.fetchTargetIgnoreKnownDeleted(this.database, bin);
                if (n == null) {
                    throw new DatabaseException("internal error: fetchTarget returned null " + bin.getNodeId());
                }
                if (n instanceof LN) {
                    currentLN = (LN)n;
                } else {
                    DIN duplicateRoot = (DIN)n;
                    currentLN = (DupCountLN)duplicateRoot.getDupCountLNRef().fetchTarget(this.database, duplicateRoot);
                    dupCount = ((DupCountLN)currentLN).getDupCount();
                }
                cursor.updateBin(bin, duplicateEntryIndex);
                bin.releaseLatch();
                Locker locker = cursor.getLocker();
                while (true) {
                    locker.writeLock(currentLN, this.database);
                    while (true) {
                        bin = cursor.getBIN();
                        bin.latch();
                        if (bin == cursor.getBIN()) break;
                        bin.releaseLatch();
                    }
                    duplicateEntryIndex = cursor.getIndex();
                    ref = bin.getEntry(duplicateEntryIndex);
                    n = ref.fetchTargetIgnoreKnownDeleted(this.database, bin);
                    if (n == null) {
                        throw new DatabaseException("internal error: fetchTarget returned null " + bin.getNodeId());
                    }
                    if (n == currentLN || dupCount != -1) break;
                    if (n instanceof LN) {
                        currentLN = (LN)n;
                    } else {
                        DIN duplicateRoot = (DIN)n;
                        currentLN = (DupCountLN)duplicateRoot.getDupCountLNRef().fetchTarget(this.database, duplicateRoot);
                        dupCount = ((DupCountLN)currentLN).getDupCount();
                    }
                    bin.releaseLatch();
                }
                boolean isKnownDeleted = ref.isKnownDeleted();
                if (isKnownDeleted || dupCount == -1 && ((LN)ref.fetchTarget(this.database, bin)).isDeleted()) {
                    DbLsn existingAbortLsn = locker.getAbortLsn(currentLN.getNodeId());
                    lnLock.setAbortLsn(existingAbortLsn, isKnownDeleted);
                    DbLsn newLsn = ln.log(env, this.database.getId(), key, null, cursor.getLocker());
                    bin.updateEntry(duplicateEntryIndex, ln, newLsn, key);
                    bin.clearKnownDeleted(duplicateEntryIndex);
                    this.traceInsert(Level.FINER, env, bin, ln, newLsn, duplicateEntryIndex);
                    boolean bl = true;
                    return bl;
                }
                if (!allowDuplicates && dupCount != 0) {
                    boolean bl = false;
                    return bl;
                }
                cursor.updateBin(bin, duplicateEntryIndex);
                boolean bl = this.insertDuplicate(key, bin, ln, logManager, inMemoryINs, cursor, lnLock);
                return bl;
            }
            finally {
                if (bin != null && bin.getLatch().isOwner()) {
                    bin.releaseLatch();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean insertDuplicate(Key key, BIN bin, LN newLN, LogManager logManager, INList inMemoryINs, CursorImpl cursor, LockResult lnLock) throws DatabaseException {
        env = this.database.getDbEnvironment();
        index = cursor.getIndex();
        successfulInsert = false;
        latchCount = 0;
        if (!Tree.$assertionsDisabled && (latchCount = Latch.countLatchesHeld()) <= -1) {
            throw new AssertionError();
        }
        duplicateRoot = null;
        n = bin.fetchTarget(index);
        if (n instanceof DIN) {
            duplicateBin = null;
            try {
                duplicateRoot = (DIN)n;
                duplicateRoot.latch();
                if (this.maybeSplitDuplicateRoot(bin, index)) {
                    duplicateRoot = (DIN)bin.fetchTarget(index);
                }
                if (((duplicateEntryIndex = (duplicateBin = (DBIN)this.searchSubTree(duplicateRoot, newLNKey = new Key(newLN.getData()), SearchType.NORMAL, -1L, true)).insertEntry1(newLNRef = new ChildReference(newLN, newLNKey, DbLsn.NULL_LSN))) & 131072) != 0) {
                    lnLock.setAbortLsn(null, true, true);
                    cursor.updateDBin((DBIN)duplicateBin, duplicateEntryIndex &= -131073);
                    newLsn = newLN.log(env, this.database.getId(), key, null, cursor.getLocker());
                    newLNRef.setLsn(newLsn);
                    this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)duplicateBin, newLN, newLsn, bin);
                    successfulInsert = true;
                } else {
                    currentLN = (LN)duplicateBin.fetchTarget(duplicateEntryIndex &= -65537);
                    cursor.updateDBin((DBIN)duplicateBin, duplicateEntryIndex);
                    duplicateBin.releaseLatch();
                    locker = cursor.getLocker();
                    targetRef = null;
                    while (true) {
                        locker.readLock(currentLN);
                        while (true) {
                            duplicateBin = cursor.getDupBIN();
                            duplicateBin.latch();
                            if (duplicateBin == cursor.getDupBIN()) break;
                            duplicateBin.releaseLatch();
                        }
                        duplicateEntryIndex = cursor.getDupIndex();
                        targetRef = duplicateBin.getEntry(duplicateEntryIndex);
                        n = targetRef.fetchTargetIgnoreKnownDeleted(this.database, duplicateBin);
                        if (n == null) {
                            throw new DatabaseException("internal error: fetchTarget returned null " + duplicateBin.getNodeId());
                        }
                        if (n == currentLN) break;
                        duplicateBin.releaseLatch();
                        currentLN = (LN)n;
                    }
                    isKnownDeleted = targetRef.isKnownDeleted();
                    if (isKnownDeleted || currentLN.isDeleted()) {
                        cursor.updateDBin((DBIN)duplicateBin, duplicateEntryIndex);
                        existingAbortLsn = locker.getAbortLsn(currentLN.getNodeId());
                        lnLock.setAbortLsn(existingAbortLsn, isKnownDeleted);
                        newLsn = newLN.log(env, this.database.getId(), key, null, cursor.getLocker());
                        duplicateBin.updateEntry(duplicateEntryIndex, newLN, newLsn, newLNKey);
                        duplicateBin.clearKnownDeleted(duplicateEntryIndex);
                        this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)duplicateBin, newLN, newLsn, bin);
                        successfulInsert = true;
                    } else {
                        successfulInsert = false;
                    }
                }
                if (!successfulInsert) ** GOTO lbl81
                this.incrementDuplicateCount(env, cursor, key);
            }
            finally {
                if (duplicateBin != null && duplicateBin.getLatch().isOwner()) {
                    duplicateBin.releaseLatch();
                }
                if (duplicateRoot.getLatch().isOwner()) {
                    duplicateRoot.releaseLatch();
                }
            }
        } else if (n instanceof LN) {
            try {
                lnLock.setAbortLsn(null, true, true);
                duplicateRoot = this.createDuplicateTree(key, logManager, inMemoryINs, newLN, cursor);
            }
            finally {
                if (duplicateRoot != null) {
                    duplicateRoot.releaseLatch();
                    successfulInsert = true;
                } else {
                    successfulInsert = false;
                }
            }
        } else {
            throw new InconsistentNodeException("neither LN or DIN found in BIN");
        }
lbl81:
        // 3 sources

        if (!Tree.$assertionsDisabled && Latch.countLatchesHeld() != latchCount) {
            throw new AssertionError((Object)("latchCount=" + latchCount + " held=" + Latch.countLatchesHeld()));
        }
        return successfulInsert;
    }

    private void incrementDuplicateCount(EnvironmentImpl env, CursorImpl cursor, Key key) throws DatabaseException {
        DIN duplicateRoot = this.getLatchedDuplicateTreeRoot(cursor);
        DupCountLN dupCountLN = duplicateRoot.getDupCountLN();
        duplicateRoot.releaseLatch();
        cursor.releaseBINs();
        LockResult lockResult = cursor.getLocker().writeLock(dupCountLN, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        cursor.latchBIN();
        duplicateRoot = this.getLatchedDuplicateTreeRoot(cursor);
        duplicateRoot.incrementDuplicateCount(env, lockResult, key, cursor.getLocker());
    }

    private DIN getLatchedDuplicateTreeRoot(CursorImpl cursor) throws DatabaseException {
        int index = cursor.getIndex();
        BIN bin = cursor.getBIN();
        DIN duplicateRoot = (DIN)bin.getEntry(index).fetchTarget(this.database, bin);
        duplicateRoot.latch();
        return duplicateRoot;
    }

    private boolean maybeSplitDuplicateRoot(BIN bin, int index) throws DatabaseException {
        ChildReference ref = bin.getEntry(index);
        DIN curRoot = (DIN)ref.fetchTarget(this.database, bin);
        if (curRoot.needsSplitting()) {
            EnvironmentImpl env = this.database.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            Key rootIdKey = curRoot.getEntry(0).getKey();
            DIN newRoot = new DIN(this.database, rootIdKey, this.maxEntriesPerNode, curRoot.getDupKey(), curRoot.getDupCountLNRef(), curRoot.getLevel() + 1);
            newRoot.latch();
            newRoot.setIsRoot(true);
            curRoot.setDupCountLN(null);
            curRoot.setIsRoot(false);
            DbLsn curRootLsn = curRoot.logProvisional(logManager);
            boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, ref.getLsn()));
            if (!$assertionsDisabled && !insertOk) {
                throw new AssertionError();
            }
            DbLsn logLsn = newRoot.log(logManager);
            inMemoryINs.add(newRoot);
            bin.updateEntry(index, newRoot, logLsn);
            curRoot.split(newRoot, 0, this.maxEntriesPerNode);
            curRoot.releaseLatch();
            this.traceSplitRoot(Level.FINE, TRACE_DUP_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
            return true;
        }
        return false;
    }

    private DIN createDuplicateTree(Key key, LogManager logManager, INList inMemoryINs, LN newLN, CursorImpl cursor) throws DatabaseException {
        boolean keysEqual;
        EnvironmentImpl env = this.database.getDbEnvironment();
        DIN duplicateRoot = null;
        DBIN duplicateBin = null;
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        LN existingLN = (LN)bin.getEntry(index).fetchTarget(this.database, bin);
        Key existingKey = new Key(existingLN.getData());
        Key newLNKey = new Key(newLN.getData());
        Comparator userComparisonFcn = this.database.getDuplicateComparator();
        boolean bl = keysEqual = (userComparisonFcn == null ? newLNKey.compareTo(existingKey) : userComparisonFcn.compare(newLNKey.getKey(), existingKey.getKey())) == 0;
        if (keysEqual) {
            return null;
        }
        Locker locker = cursor.getLocker();
        int startingCount = locker.createdNode(existingLN.getNodeId()) ? 0 : 1;
        DupCountLN dupCountLN = new DupCountLN(startingCount);
        DbLsn firstDupCountLNLsn = dupCountLN.logProvisional(env, this.database.getId(), key, null);
        duplicateRoot = new DIN(this.database, existingKey, this.maxEntriesPerNode, key, new ChildReference(dupCountLN, key, firstDupCountLNLsn), 2);
        duplicateRoot.latch();
        duplicateRoot.setIsRoot(true);
        duplicateBin = new DBIN(this.database, existingKey, this.maxEntriesPerNode, key, 1);
        duplicateBin.latch();
        ChildReference newExistingLNRef = new ChildReference(existingLN, existingKey, bin.getEntry(index).getLsn());
        boolean insertOk = duplicateBin.insertEntry(newExistingLNRef);
        if (!$assertionsDisabled && !insertOk) {
            throw new AssertionError();
        }
        DbLsn dbinLsn = duplicateBin.logProvisional(logManager);
        inMemoryINs.add(duplicateBin);
        duplicateRoot.setEntry(0, new ChildReference(duplicateBin, duplicateBin.getEntry(0).getKey(), dbinLsn));
        DbLsn dinLsn = duplicateRoot.log(logManager);
        inMemoryINs.add(duplicateRoot);
        LockResult lockResult = locker.writeLock(dupCountLN, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        lockResult.setAbortLsn(firstDupCountLNLsn, false);
        dupCountLN.setDupCount(2);
        DbLsn dupCountLsn = dupCountLN.log(env, this.database.getId(), key, firstDupCountLNLsn, locker);
        duplicateRoot.updateDupCountLNRef(dupCountLsn);
        DbLsn newLsn = newLN.log(env, this.database.getId(), key, null, locker);
        int duplicateEntryIndex = duplicateBin.insertEntry1(new ChildReference(newLN, newLNKey, newLsn));
        if (cursor != null) {
            cursor.updateDBin(duplicateBin, duplicateEntryIndex &= 0xFFFDFFFF);
        }
        duplicateBin.releaseLatch();
        bin.updateEntry(index, duplicateRoot, dinLsn);
        this.traceMutate(Level.FINE, bin, existingLN, newLN, newLsn, dupCountLN, dupCountLsn, duplicateRoot, dinLsn, duplicateBin, dbinLsn);
        return duplicateRoot;
    }

    private void validateInsertArgs(boolean allowDuplicates) throws DatabaseException {
        if (allowDuplicates && !this.database.getSortedDuplicates()) {
            throw new DatabaseException("allowDuplicates passed to insert but database doesn't have allow duplicates set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BIN findBinForInsert(Key key, LogManager logManager, INList inMemoryINs) throws DatabaseException {
        BIN bin;
        try {
            block5: {
                IN in;
                do {
                    this.rootLatch.acquire();
                    if (this.root == null) {
                        IN rootIN = new IN(this.database, key, this.maxEntriesPerNode, 2);
                        rootIN.setIsRoot(true);
                        DbLsn logLsn = rootIN.log(logManager);
                        this.root = new ChildReference(rootIN, new Key(new byte[0]), logLsn);
                        bin = new BIN(this.database, key, this.maxEntriesPerNode, 1);
                        bin.latch();
                        logLsn = bin.log(logManager);
                        boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                        if (!$assertionsDisabled && !insertOk) {
                            throw new AssertionError();
                        }
                        inMemoryINs.add(bin);
                        inMemoryINs.add(rootIN);
                        this.rootLatch.release();
                        break block5;
                    }
                    this.rootLatch.release();
                    in = this.search(key, SearchType.NORMAL, -1L, true);
                } while (in == null);
                bin = (BIN)in;
            }
            Object var9_8 = null;
            if (!this.rootLatch.isOwner()) return bin;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!this.rootLatch.isOwner()) throw throwable;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return bin;
    }

    private void removeSubtreeFromINList(INList inMemoryINs, IN subtreeRoot) throws DatabaseException {
        subtreeRoot.removeFromINList(inMemoryINs);
        Tracer.trace(Level.FINE, this.database.getDbEnvironment(), "RemovedSubtreeFromInList: subtreeRoot = " + subtreeRoot.getNodeId());
    }

    public int getLogSize() {
        int size = LogUtils.getBooleanLogSize();
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeBoolean(logBuffer, this.root != null);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer) {
        boolean rootExists = LogUtils.readBoolean(itemBuffer);
        if (rootExists) {
            this.root = new ChildReference();
            this.root.readFromLog(itemBuffer);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeInfo verify(VerifyConfig config) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        INCompressor iNCompressor = env.getINCompressor();
        synchronized (iNCompressor) {
            Cleaner cleaner = env.getCleaner();
            synchronized (cleaner) {
                Evictor evictor = env.getEvictor();
                synchronized (evictor) {
                    Checkpointer checkpointer = env.getCheckpointer();
                    synchronized (checkpointer) {
                        return this.verifyInternal(config);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeInfo verifyInternal(VerifyConfig config) throws DatabaseException {
        boolean checkINList = config.getAggressive();
        INList theRealINList = this.database.getDbEnvironment().getInMemoryINs();
        TreeInfo treeInfo = new TreeInfo();
        try {
            Tracer.trace(Level.INFO, this.database.getDbEnvironment(), "Validation of " + this.database.getName() + " starting.");
            theRealINList.latchMajor();
            INList inMemoryINCheckList = new INList(theRealINList, this.database.getDbEnvironment());
            if (!checkINList) {
                theRealINList.releaseMajorLatch();
            }
            if (this.root != null) {
                this.rootLatch.acquire();
                try {
                    IN rootIN = (IN)this.root.fetchTarget(this.database, null);
                    this.verify1(rootIN, rootIN.getLevel() + 1, treeInfo, inMemoryINCheckList, null);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.rootLatch.release();
                    throw throwable;
                }
                this.rootLatch.release();
                {
                }
            }
            if (checkINList && inMemoryINCheckList.getSize() > 0) {
                Iterator iter = inMemoryINCheckList.getINs().iterator();
                boolean foundOne = false;
                StringBuffer foundList = new StringBuffer();
                while (iter.hasNext()) {
                    IN theIN = (IN)iter.next();
                    if (theIN.getDatabase().getId() == this.database.getId()) {
                        if (!theRealINList.contains(theIN)) continue;
                        foundOne = true;
                        foundList.append(" ").append(theIN.getNodeId());
                        continue;
                    }
                    iter.remove();
                }
                if (foundOne) {
                    String errorMsg = inMemoryINCheckList.getSize() + " INs on INList were not in db " + this.database.getName();
                    if (!$assertionsDisabled && (errorMsg = errorMsg + foundList.toString()) == null) {
                        throw new AssertionError();
                    }
                    throw new DatabaseException(errorMsg);
                }
            }
        }
        finally {
            Tracer.trace(Level.INFO, this.database.getDbEnvironment(), "Validation of " + this.database.getName() + " ending.");
            theRealINList.releaseMajorLatchIfHeld();
        }
        return treeInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verify1(Node node, int parentLevel, TreeInfo tinfo, INList inMemoryINs, Key maxKeyArg) throws DatabaseException {
        Long nid = new Long(node.getNodeId());
        if (tinfo.nodeIdsSeen.put(nid, nid) != null) {
            throw new DatabaseException("Node id " + nid + " seen more than once. ");
        }
        int level = node.getLevel();
        if (level > tinfo.maxDepth) {
            tinfo.maxDepth = level;
        }
        if (level >= parentLevel) {
            throw new DatabaseException("Levels are not ordered");
        }
        node.verify(maxKeyArg);
        if (node instanceof LN) {
            if (((LN)node).isDeleted()) {
                ++tinfo.deletedLNCount;
                return;
            } else {
                ++tinfo.lnCount;
            }
            return;
        }
        if (node instanceof BIN) {
            ++tinfo.binCount;
            this.verifyOneIN((IN)node, inMemoryINs);
        } else {
            if (!(node instanceof IN)) throw new DatabaseException("wierd node type found: " + node);
            ++tinfo.inCount;
            IN in = (IN)node;
            this.verifyOneIN(in, inMemoryINs);
            if (in.isDbRoot()) {
                if (tinfo.rootId != -1L) throw new DatabaseException("Found 2 root nodes: first=" + tinfo.rootId + " second=" + in.getNodeId());
                tinfo.rootId = in.getNodeId();
            }
        }
        IN n = (IN)node;
        int nEntries = n.getNEntries();
        int i = 0;
        while (i < nEntries) {
            ChildReference ref = n.getEntry(i);
            if (!ref.isKnownDeleted()) {
                Node child = ref.fetchTarget(this.database, n);
                Key maxKey = null;
                if (i < nEntries - 1) {
                    maxKey = n.getEntry(i + 1).getKey();
                }
                if (!n.containsDuplicates() && child.containsDuplicates()) {
                    ++tinfo.dupCountLNCount;
                    DIN duplicateRoot = (DIN)child;
                    DupCountLN dupCountLN = (DupCountLN)duplicateRoot.getDupCountLNRef().fetchTarget(this.database, duplicateRoot);
                    int beforeLNCount = tinfo.lnCount;
                    this.verify1(child, duplicateRoot.getLevel() + 1, tinfo, inMemoryINs, null);
                    int afterLNCount = tinfo.lnCount;
                    if (afterLNCount - beforeLNCount != dupCountLN.getDupCount()) {
                        throw new DatabaseException("   Saved DupCountLN node=" + dupCountLN.getNodeId() + " count: " + dupCountLN.getDupCount() + "   Actual count: " + (afterLNCount - beforeLNCount));
                    }
                    this.verify1(dupCountLN, level, tinfo, inMemoryINs, null);
                } else {
                    this.verify1(child, level, tinfo, inMemoryINs, maxKey);
                }
            }
            ++i;
        }
    }

    private void verifyOneIN(IN in, INList inMemoryINs) throws DatabaseException {
        if (in.getDatabase() != this.database) {
            throw new DatabaseException("Database for IN " + in.getNodeId() + " (" + in.getDatabase().getName() + ") does not match database " + " for tree (" + this.database.getName());
        }
        if (inMemoryINs.contains(in)) {
            inMemoryINs.remove(in);
        } else {
            INList theRealINList = this.database.getDbEnvironment().getInMemoryINs();
            if (!theRealINList.contains(in)) {
                throw new DatabaseException("inMemoryINs does not contain IN " + in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquire();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.rootLatch.release();
                throw throwable;
            }
            this.rootLatch.release();
            {
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(this.root.getLsn().dumpString(nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    void dumpKeys() throws DatabaseException {
        IN nextBin = this.getFirstNode();
        while (nextBin != null) {
            BIN bin = (BIN)nextBin;
            System.out.println("-----------");
            bin.dumpKeys();
            nextBin = this.getNextBin(bin, null);
        }
        System.out.println("-----------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        boolean bl;
        this.rootLatch.acquire();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            bl = rootIN.validateSubtreeBeforeDelete(index);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return bl;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, DbLsn newRootLsn, IN oldRoot, DbLsn oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(newRootLsn.getNoFormatString());
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(oldRootLsn.getNoFormatString());
            logger.log(level, sb.toString());
        }
    }

    private void traceMutate(Level level, BIN theBin, LN existingLn, LN newLn, DbLsn newLsn, DupCountLN dupCountLN, DbLsn dupRootLsn, DIN duplicateDIN, DbLsn ddinLsn, DBIN duplicateBin, DbLsn dbinLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_MUTATE);
            sb.append(" existingLn=");
            sb.append(existingLn.getNodeId());
            sb.append(" newLn=");
            sb.append(newLn.getNodeId());
            sb.append(" newLnLsn=");
            sb.append(newLsn.getNoFormatString());
            sb.append(" dupCountLN=");
            sb.append(dupCountLN.getNodeId());
            sb.append(" dupRootLsn=");
            sb.append(dupRootLsn.getNoFormatString());
            sb.append(" rootdin=");
            sb.append(duplicateDIN.getNodeId());
            sb.append(" ddinLsn=");
            sb.append(ddinLsn.getNoFormatString());
            sb.append(" dbin=");
            sb.append(duplicateBin.getNodeId());
            sb.append(" dbinLsn=");
            sb.append(dbinLsn.getNoFormatString());
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            logger.log(level, sb.toString());
        }
    }

    private void traceInsert(Level level, EnvironmentImpl env, BIN insertingBin, LN ln, DbLsn lnLsn, int index) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(lnLsn.getNoFormatString());
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    private void traceInsertDuplicate(Level level, EnvironmentImpl env, BIN insertingDBin, LN ln, DbLsn lnLsn, BIN bin) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT_DUPLICATE);
            sb.append(" dbin=");
            sb.append(insertingDBin.getNodeId());
            sb.append(" bin=");
            sb.append(bin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(lnLsn.getNoFormatString());
            logger.log(level, sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$tree$Tree == null ? (class$com$sleepycat$je$tree$Tree = Tree.class$("com.sleepycat.je.tree.Tree")) : class$com$sleepycat$je$tree$Tree).desiredAssertionStatus();
    }

    public static class SearchType {
        private short typeNumber;
        public static final SearchType NORMAL = new SearchType(1);
        public static final SearchType LEFT = new SearchType(2);
        public static final SearchType RIGHT = new SearchType(3);
        public static final SearchType DELETE = new SearchType(4);

        private SearchType(short typeNumber) {
            this.typeNumber = typeNumber;
        }
    }
}

