/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.Generation;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IN
extends Node
implements Comparable,
LoggableObject,
LogReadable {
    private static final String BEGIN_TAG = "<in>";
    private static final String END_TAG = "</in>";
    private static final String TRACE_SPLIT = "Split:";
    private static final String TRACE_DELETE = "Delete:";
    private static final int DBMAP_LEVEL = 131072;
    private static final int MAIN_LEVEL = 65536;
    private Latch latch;
    private long generation;
    private boolean dirty;
    private int nEntries;
    private Key identifierKey;
    private ChildReference[] entries;
    private DatabaseImpl databaseImpl;
    private boolean isRoot;
    private int level;
    private long inMemorySize;
    private boolean inListResident;
    protected boolean evictionProhibited;
    public static final int EXACT_MATCH = 65536;
    public static final int INSERT_SUCCESS = 131072;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$tree$IN;

    public IN() {
        super(false);
        this.init(null, new Key(), 0, 0);
    }

    public IN(DatabaseImpl db, Key identifierKey, int capacity, int level) {
        super(true);
        this.init(db, identifierKey, capacity, this.generateLevel(db.getId(), level));
        this.initMemorySize();
    }

    protected void init(DatabaseImpl db, Key identifierKey, int initialCapacity, int level) {
        this.setDatabase(db);
        EnvironmentImpl env = this.databaseImpl == null ? null : this.databaseImpl.getDbEnvironment();
        this.latch = new Latch(this.shortClassName() + this.getNodeId(), env);
        this.generation = 0L;
        this.dirty = false;
        this.nEntries = 0;
        this.identifierKey = identifierKey;
        this.entries = new ChildReference[initialCapacity];
        this.isRoot = false;
        this.level = level;
        this.inListResident = false;
        this.evictionProhibited = false;
    }

    protected void initMemorySize() {
        this.inMemorySize = this.computeMemorySize();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IN)) {
            return false;
        }
        IN in = (IN)obj;
        return in.getNodeId() == this.getNodeId();
    }

    public int hashCode() {
        return (int)(this.getNodeId() & 0xFFFFFFFFFFFFFFFFL);
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        IN argIN = (IN)o;
        long argNodeId = argIN.getNodeId();
        long myNodeId = this.getNodeId();
        if (myNodeId < argNodeId) {
            return -1;
        }
        if (myNodeId > argNodeId) {
            return 1;
        }
        return 0;
    }

    protected IN createNewInstance(Key identifierKey, int maxEntries, int level) {
        return new IN(this.databaseImpl, identifierKey, maxEntries, level);
    }

    public void postFetchInit(DatabaseImpl db) throws DatabaseException {
        this.setDatabase(db);
        EnvironmentImpl env = db.getDbEnvironment();
        this.initMemorySize();
        env.getInMemoryINs().add(this);
    }

    public void postRecoveryInit(DatabaseImpl db, DbLsn sourceLsn) {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        this.initMemorySize();
    }

    protected void setLastFullLsn(DbLsn lsn) {
    }

    public void latch() throws DatabaseException {
        this.setGeneration();
        this.latch.acquire();
    }

    public void releaseLatch() throws LatchNotHeldException {
        this.latch.release();
    }

    public Latch getLatch() {
        return this.latch;
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration() {
        this.generation = Generation.getNextGeneration();
    }

    public void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    public int getLevel() {
        return this.level;
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        if (dbId.equals(DbTree.ID_DB_ID)) {
            return newLevel | 0x20000;
        }
        return newLevel | 0x10000;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isDbRoot() {
        return this.isRoot;
    }

    void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
        this.setDirty(true);
    }

    public Key getIdentifierKey() {
        return this.identifierKey;
    }

    void setIdentifierKey(Key key) {
        this.identifierKey = key;
        this.setDirty(true);
    }

    public Key getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public Key selectKey(Key mainTreeKey, Key dupTreeKey) {
        return mainTreeKey;
    }

    public Key getDupKey() throws DatabaseException {
        throw new DatabaseException(this.shortClassName() + ".getDupKey() called");
    }

    Key getDupTreeKey() {
        return null;
    }

    public Key getMainTreeKey() {
        return this.getIdentifierKey();
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public void setDatabase(DatabaseImpl db) {
        this.databaseImpl = db;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseImpl.getId();
    }

    public boolean isKnownDeleted(int index) {
        return false;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    int getMaxEntries() {
        return this.entries.length;
    }

    public ChildReference getEntry(int n) {
        return this.entries[n];
    }

    Node fetchTarget(int n) throws DatabaseException {
        return this.getEntry(n).fetchTarget(this.databaseImpl, this);
    }

    public void setEntry(int n, ChildReference ref) {
        this.updateMemorySize(this.entries[n], ref);
        this.entries[n] = ref;
        if (++n > this.nEntries) {
            this.nEntries = n;
        }
        this.setDirty(true);
    }

    public void updateEntry(int n, Node node, DbLsn lsn) {
        ChildReference ref = this.entries[n];
        long oldSize = ref.getInMemorySize();
        ref.setLsn(lsn);
        ref.setTarget(node);
        long newSize = ref.getInMemorySize();
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int n, Node node, DbLsn lsn, Key key) {
        ChildReference ref = this.entries[n];
        long oldSize = ref.getInMemorySize();
        ref.setLsn(lsn);
        ref.setTarget(node);
        ref.setKey(key);
        long newSize = ref.getInMemorySize();
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int n, DbLsn lsn) {
        ChildReference ref = this.entries[n];
        this.updateMemorySize(ref.getLsn(), lsn);
        ref.setLsn(lsn);
        this.setDirty(true);
    }

    private void updateEntryCompareKey(int n, Node node, DbLsn lsn, Key key) {
        int s;
        ChildReference ref = this.entries[n];
        long oldSize = ref.getInMemorySize();
        ref.setLsn(lsn);
        ref.setTarget(node);
        Key existingKey = ref.getKey();
        Comparator userCompareToFcn = this.getKeyComparator();
        int n2 = s = userCompareToFcn == null ? key.compareTo(existingKey) : userCompareToFcn.compare(key.getKey(), existingKey.getKey());
        if (s < 0) {
            ref.setKey(key);
        }
        long newSize = ref.getInMemorySize();
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public boolean verifyMemorySize() {
        long calcMemorySize = this.computeMemorySize();
        if (calcMemorySize != this.inMemorySize) {
            String msg = "-Warning: Out of sync. Should be " + calcMemorySize + " / actual: " + this.inMemorySize + " node: " + this.getNodeId();
            Tracer.trace(Level.INFO, this.databaseImpl.getDbEnvironment(), msg);
            System.out.println(msg);
            return false;
        }
        return true;
    }

    public long getInMemorySize() {
        return this.inMemorySize;
    }

    protected long computeMemorySize() {
        MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
        long calcMemorySize = this.getMemoryOverhead(mb);
        int i = 0;
        while (i < this.nEntries) {
            calcMemorySize += this.getEntry(i).getInMemorySize();
            ++i;
        }
        return calcMemorySize;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        int capacity = configManager.getInt(EnvironmentParams.NODE_MAX);
        return MemoryBudget.IN_FIXED_OVERHEAD + MemoryBudget.ARRAY_ITEM_OVERHEAD * (long)capacity;
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getINOverhead();
    }

    protected void updateMemorySize(ChildReference oldRef, ChildReference newRef) {
        long delta = 0L;
        if (newRef != null) {
            delta = newRef.getInMemorySize();
        }
        if (oldRef != null) {
            delta -= oldRef.getInMemorySize();
        }
        this.changeMemorySize(delta);
    }

    public void updateMemorySize(long oldSize, long newSize) {
        long delta = newSize - oldSize;
        this.changeMemorySize(delta);
    }

    void updateMemorySize(Node oldNode, Node newNode) {
        long delta = 0L;
        if (newNode != null) {
            delta = newNode.getMemorySizeIncludedByParent();
        }
        if (oldNode != null) {
            delta -= oldNode.getMemorySizeIncludedByParent();
        }
        this.changeMemorySize(delta);
    }

    protected void updateMemorySize(DbLsn oldLsn, DbLsn newLsn) {
        long oldSize = oldLsn == null ? 0L : MemoryBudget.LSN_SIZE;
        long newSize = newLsn == null ? 0L : MemoryBudget.LSN_SIZE;
        long delta = newSize - oldSize;
        this.changeMemorySize(delta);
    }

    private void changeMemorySize(long delta) {
        this.inMemorySize += delta;
        if (this.inListResident) {
            MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
            mb.updateCacheMemoryUsage(delta);
        }
    }

    public void setInListResident(boolean resident) {
        this.inListResident = resident;
    }

    /*
     * Unable to fully structure code
     */
    public int findEntry(Key key, boolean indicateIfDuplicate, boolean exact) {
        high = this.nEntries - 1;
        low = 0;
        middle = 0;
        userCompareToFcn = this.getKeyComparator();
        v0 = entryZeroSpecialCompare = this.entryZeroKeyComparesLow() != false && exact == false && indicateIfDuplicate == false;
        if (IN.$assertionsDisabled || this.nEntries >= 0) ** GOTO lbl25
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            middle = (high + low) / 2;
            middleKey = null;
            if (middle == 0 && entryZeroSpecialCompare) {
                s = 1;
            } else {
                middleKey = this.entries[middle].getKey();
                v1 = s = userCompareToFcn == null ? key.compareTo(middleKey) : userCompareToFcn.compare(key.getKey(), middleKey.getKey());
            }
            if (s < 0) {
                high = middle - 1;
                continue;
            }
            if (s > 0) {
                low = middle + 1;
                continue;
            }
            ret = indicateIfDuplicate != false ? middle | 65536 : middle;
            if (ret >= 0 && exact && this.isKnownDeleted(ret & 65535)) {
                return -1;
            }
            return ret;
lbl25:
            // 3 sources

            ** while (low <= high)
        }
lbl26:
        // 1 sources

        if (exact) {
            return -1;
        }
        return high;
    }

    public boolean insertEntry(ChildReference entry) throws DatabaseException {
        return (this.insertEntry1(entry) & 0x20000) != 0;
    }

    public int insertEntry1(ChildReference entry) throws DatabaseException {
        if (this.nEntries >= this.entries.length) {
            this.compress();
        }
        if (this.nEntries < this.entries.length) {
            Key key = entry.getKey();
            int index = this.findEntry(key, true, false);
            if (index >= 0 && (index & 0x10000) != 0) {
                return index;
            }
            if (++index < this.nEntries) {
                this.shiftEntriesRight(index);
            }
            this.entries[index] = entry;
            ++this.nEntries;
            this.adjustCursorsForInsert(index);
            this.updateMemorySize(0L, entry.getInMemorySize());
            this.setDirty(true);
            return index | 0x20000;
        }
        throw new InconsistentNodeException("Node " + this.getNodeId() + " should have been split before calling insertEntry");
    }

    boolean deleteEntry(Key key, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        int index = this.findEntry(key, false, true);
        if (index < 0) {
            return false;
        }
        return this.deleteEntry(index, maybeValidate);
    }

    public boolean deleteEntry(int index, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        if (!$assertionsDisabled && maybeValidate && !this.validateSubtreeBeforeDelete(index)) {
            throw new AssertionError();
        }
        if (index < this.nEntries) {
            this.updateMemorySize(this.entries[index].getInMemorySize(), 0L);
            int i = index;
            while (i < this.nEntries - 1) {
                this.entries[i] = this.entries[i + 1];
                ++i;
            }
            --this.nEntries;
            this.setDirty(true);
            this.setCompressedSinceLastLog(true);
            this.traceDelete(Level.FINEST, index);
            return true;
        }
        return false;
    }

    protected void setCompressedSinceLastLog(boolean val) {
    }

    public boolean compress() throws DatabaseException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        boolean bl;
        block6: {
            boolean needToLatch;
            block4: {
                boolean bl2;
                block5: {
                    needToLatch = !this.getLatch().isOwner();
                    try {
                        if (needToLatch) {
                            this.latch();
                        }
                        if (index < this.nEntries) break block4;
                        bl2 = true;
                        Object var6_5 = null;
                        if (!needToLatch || !this.getLatch().isOwner()) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var6_7 = null;
                            if (!needToLatch || !this.getLatch().isOwner()) break block7;
                            this.releaseLatch();
                        }
                        throw throwable;
                    }
                    this.releaseLatch();
                }
                return bl2;
            }
            Node child = this.getEntry(index).fetchTarget(this.databaseImpl, this);
            bl = child.isValidForDelete();
            Object var6_6 = null;
            if (!needToLatch || !this.getLatch().isOwner()) break block6;
            this.releaseLatch();
        }
        return bl;
    }

    Key makePrefixKey(Key wholeKey) {
        return wholeKey;
    }

    public boolean needsSplitting() {
        return this.entries.length - this.nEntries < 1;
    }

    boolean entryZeroKeyComparesLow() {
        return true;
    }

    DbLsn split(IN parent, int childIndex, int maxEntries) throws DatabaseException {
        return this.splitInternal(parent, childIndex, maxEntries, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbLsn splitInternal(IN parent, int childIndex, int maxEntries, int splitIndex) throws DatabaseException {
        int high;
        int low;
        if (this.identifierKey == null) {
            throw new InconsistentNodeException("idkey is null");
        }
        int idKeyIndex = this.findEntry(this.identifierKey, false, false);
        if (splitIndex < 0) {
            splitIndex = this.nEntries / 2;
        }
        IN newSibling = null;
        if (idKeyIndex < splitIndex) {
            low = splitIndex;
            high = this.nEntries;
        } else {
            low = 0;
            high = splitIndex;
        }
        Key newIdKey = this.entries[low].getKey();
        DbLsn parentLsn = null;
        newSibling = this.createNewInstance(newIdKey, maxEntries, this.level);
        newSibling.latch();
        long oldMemorySize = this.inMemorySize;
        try {
            boolean insertOk;
            int toIdx = 0;
            int i = low;
            while (i < high) {
                newSibling.setEntry(toIdx++, this.entries[i]);
                ++i;
            }
            int newSiblingNEntries = high - low;
            if (low == 0) {
                this.shiftEntriesLeft(newSiblingNEntries);
            }
            newSibling.nEntries = toIdx;
            this.nEntries -= newSiblingNEntries;
            this.setDirty(true);
            this.adjustCursors(newSibling, low, high);
            EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            DbLsn newSiblingLsn = newSibling.logProvisional(logManager);
            DbLsn myNewLsn = this.logProvisional(logManager);
            if (low == 0) {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, newSibling, newSiblingLsn, newIdKey);
                } else {
                    parent.updateEntry(childIndex, newSibling, newSiblingLsn);
                }
                insertOk = parent.insertEntry(new ChildReference(this, this.entries[0].getKey(), myNewLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            } else {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, this, myNewLsn, this.entries[0].getKey());
                } else {
                    parent.updateEntry(childIndex, this, myNewLsn);
                }
                insertOk = parent.insertEntry(new ChildReference(newSibling, newIdKey, newSiblingLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            }
            parentLsn = parent.log(logManager);
            long newSize = this.computeMemorySize();
            this.updateMemorySize(oldMemorySize, newSize);
            inMemoryINs.add(newSibling);
            parent.setDirty(true);
            this.traceSplit(Level.FINE, parent, newSibling, parentLsn, myNewLsn, newSiblingLsn, splitIndex, idKeyIndex, childIndex);
            Object var24_22 = null;
        }
        catch (Throwable throwable) {
            Object var24_23 = null;
            newSibling.releaseLatch();
            throw throwable;
        }
        newSibling.releaseLatch();
        return parentLsn;
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, Key key, boolean leftSide) throws DatabaseException {
        int index = this.findEntry(key, false, false);
        if (leftSide && index == 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1);
        } else if (!leftSide && index == this.nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, this.nEntries - 1);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
    }

    void adjustCursorsForInsert(int insertIndex) {
    }

    public Comparator getKeyComparator() {
        return this.databaseImpl.getBtreeComparator();
    }

    private void shiftEntriesRight(int index) {
        int i = this.nEntries;
        while (i > index) {
            this.entries[i] = this.entries[i - 1];
            --i;
        }
        this.setDirty(true);
    }

    private void shiftEntriesLeft(int byHowMuch) {
        int i = 0;
        while (i < this.nEntries - byHowMuch) {
            this.entries[i] = this.entries[i + byHowMuch];
            ++i;
        }
        this.setDirty(true);
    }

    public void verify(Key maxKey) throws InconsistentNodeException {
        Comparator userCompareToFcn = this.databaseImpl == null ? null : this.getKeyComparator();
        Key key1 = null;
        int i = 1;
        while (i < this.nEntries) {
            int s;
            key1 = this.entries[i].getKey();
            Key key2 = this.entries[i - 1].getKey();
            int n = s = userCompareToFcn == null ? key1.compareTo(key2) : userCompareToFcn.compare(key1.getKey(), key2.getKey());
            if (s <= 0) {
                throw new InconsistentNodeException("IN " + this.getNodeId() + " key " + (i - 1) + " (" + key2.toString() + ") and " + i + " (" + key1.toString() + ") are out of order");
            }
            ++i;
        }
        boolean inconsistent = false;
        if (maxKey != null && key1 != null) {
            if (userCompareToFcn == null) {
                if (key1.compareTo(maxKey) >= 0) {
                    inconsistent = true;
                }
            } else if (userCompareToFcn.compare(key1.getKey(), maxKey.getKey()) >= 0) {
                inconsistent = true;
            }
        }
        if (inconsistent) {
            throw new InconsistentNodeException("IN " + this.getNodeId() + " has entry larger than next entry in parent.");
        }
    }

    void rebuildINList(INList inList) throws DatabaseException {
        this.initMemorySize();
        inList.add(this);
        int i = 0;
        while (i < this.nEntries) {
            Node n = this.getEntry(i).getTarget();
            if (n != null) {
                n.rebuildINList(inList);
            }
            ++i;
        }
    }

    void removeFromINList(INList inList) throws DatabaseException {
        if (this.nEntries > 1) {
            throw new DatabaseException("Found non-deletable IN " + this.getNodeId() + " while flushing INList. nEntries = " + this.nEntries);
        }
        inList.removeLatchAlreadyHeld(this);
        int i = 0;
        while (i < this.nEntries) {
            Node n = this.getEntry(i).fetchTargetIgnoreKnownDeleted(this.databaseImpl, this);
            if (n != null) {
                n.removeFromINList(inList);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidForDelete() throws DatabaseException {
        boolean bl;
        block9: {
            boolean needToLatch;
            block7: {
                boolean bl2;
                block8: {
                    block5: {
                        boolean bl3;
                        block6: {
                            needToLatch = !this.getLatch().isOwner();
                            try {
                                if (needToLatch) {
                                    this.latch();
                                }
                                if (this.nEntries <= 1) break block5;
                                bl3 = false;
                                Object var5_5 = null;
                                if (!needToLatch || !this.getLatch().isOwner()) break block6;
                            }
                            catch (Throwable throwable) {
                                block10: {
                                    Object var5_8 = null;
                                    if (!needToLatch || !this.getLatch().isOwner()) break block10;
                                    this.releaseLatch();
                                }
                                throw throwable;
                            }
                            this.releaseLatch();
                        }
                        return bl3;
                    }
                    if (this.nEntries != 1) break block7;
                    Node child = this.getEntry(0).fetchTarget(this.databaseImpl, this);
                    bl2 = child.isValidForDelete();
                    Object var5_6 = null;
                    if (!needToLatch || !this.getLatch().isOwner()) break block8;
                    this.releaseLatch();
                }
                return bl2;
            }
            bl = true;
            Object var5_7 = null;
            if (!needToLatch || !this.getLatch().isOwner()) break block9;
            this.releaseLatch();
        }
        return bl;
    }

    void findParent(Tree.SearchType searchType, boolean requireExactMatch, SearchResult result, IN target, Key mainTreeKey, Key dupTreeKey, List trackingList) throws DatabaseException {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (this.getNodeId() == target.getNodeId()) {
            this.releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            result.parent = null;
            return;
        }
        if (this.getNEntries() == 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
                result.index = -1;
            }
            return;
        }
        if (searchType == Tree.SearchType.NORMAL) {
            result.index = this.findEntry(this.selectKey(mainTreeKey, dupTreeKey), false, false);
        } else if (searchType == Tree.SearchType.LEFT) {
            result.index = 0;
        } else if (searchType == Tree.SearchType.RIGHT) {
            result.index = this.nEntries - 1;
        } else {
            throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
        }
        if (result.index < 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
            return;
        }
        ChildReference childRef = this.getEntry(result.index);
        if (childRef.isKnownDeleted()) {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                result.parent = null;
                this.releaseLatch();
            } else {
                result.parent = this;
            }
            return;
        }
        Node child = childRef.fetchTarget(this.databaseImpl, this);
        DbLsn childLsn = childRef.getLsn();
        if (child.isSoughtNode(target.getNodeId())) {
            result.exactParentFound = true;
            result.parent = this;
            result.keepSearching = false;
            return;
        }
        this.descendOnParentSearch(result, target, child, requireExactMatch);
        if (trackingList != null && result.parent != this && result.parent != null) {
            trackingList.add(new TrackingInfo(childLsn, child.getNodeId()));
        }
    }

    protected void descendOnParentSearch(SearchResult result, IN target, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(target)) {
            this.releaseLatch();
            result.parent = (IN)child;
        } else {
            ((IN)child).releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
        }
    }

    protected boolean isSoughtNode(long nid) throws DatabaseException {
        this.latch();
        if (this.getNodeId() == nid) {
            this.releaseLatch();
            return true;
        }
        return false;
    }

    protected boolean canBeAncestor(IN target) {
        return true;
    }

    public boolean isEvictable() {
        if (this.evictionProhibited) {
            return false;
        }
        int i = 0;
        while (i < this.nEntries) {
            ChildReference ref = this.getEntry(i);
            if (ref.getTarget() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setEvictionProhibited(boolean pinned) {
        this.evictionProhibited = pinned;
    }

    public DbLsn log(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, false);
    }

    public DbLsn log(LogManager logManager, boolean isProvisional) throws DatabaseException {
        return this.logInternal(logManager, false, isProvisional);
    }

    public DbLsn logProvisional(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, true);
    }

    public DbLsn logFromCheckpoint(LogManager logManager, boolean isProvisional) throws DatabaseException {
        return this.logInternal(logManager, true, isProvisional);
    }

    protected DbLsn logInternal(LogManager logManager, boolean isCheckpoint, boolean isProvisional) throws DatabaseException {
        DbLsn lsn = logManager.log(new INLogEntry(this), isProvisional, null, false);
        this.setDirty(false);
        return lsn;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        size += this.identifierKey.getLogSize();
        size += LogUtils.getBooleanLogSize();
        size += 4;
        size += 4;
        size += 4;
        int i = 0;
        while (i < this.nEntries) {
            size += this.entries[i].getLogSize();
            ++i;
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.identifierKey.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.isRoot);
        LogUtils.writeInt(logBuffer, this.nEntries);
        LogUtils.writeInt(logBuffer, this.level);
        LogUtils.writeInt(logBuffer, this.entries.length);
        int i = 0;
        while (i < this.nEntries) {
            this.entries[i].writeToLog(logBuffer);
            ++i;
        }
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.identifierKey.readFromLog(itemBuffer);
        this.isRoot = LogUtils.readBoolean(itemBuffer);
        this.nEntries = LogUtils.readInt(itemBuffer);
        this.level = LogUtils.readInt(itemBuffer);
        int length = LogUtils.readInt(itemBuffer);
        this.entries = new ChildReference[length];
        int i = 0;
        while (i < this.nEntries) {
            this.entries[i] = new ChildReference();
            this.entries[i].readFromLog(itemBuffer);
            ++i;
        }
        this.latch.setName(this.shortClassName() + this.getNodeId());
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        this.identifierKey.dumpLog(sb, verbose);
        sb.append("<isRoot val=\"");
        sb.append(this.isRoot);
        sb.append("\"/>");
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level));
        sb.append("\"/>");
        sb.append("<entries numEntries=\"");
        sb.append(this.nEntries);
        sb.append("\" length=\"");
        sb.append(this.entries.length);
        sb.append("\">");
        if (verbose) {
            int i = 0;
            while (i < this.nEntries) {
                this.entries[i].dumpLog(sb, verbose);
                ++i;
            }
        }
        sb.append("</entries>");
        this.dumpLogAdditional(sb);
        sb.append(this.endTag());
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    protected void dumpLogAdditional(StringBuffer sb) {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    void dumpKeys() throws DatabaseException {
        int i = 0;
        while (i < this.nEntries) {
            ChildReference entry = this.entries[i];
            System.out.println(entry.getKey().toString());
            ++i;
        }
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(super.dumpString(nSpaces + 2, true));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<idkey>");
        sb.append(this.identifierKey == null ? "" : this.identifierKey.toString());
        sb.append("</idkey>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dirty val=\"").append(this.dirty).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<generation val=\"").append(this.generation).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isRoot val=\"").append(this.isRoot).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<entries nEntries=\"");
        sb.append(this.nEntries);
        sb.append("\">");
        sb.append('\n');
        int i = 0;
        while (i < this.nEntries) {
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("<entry id=\"" + i + "\">");
            sb.append('\n');
            ChildReference cref = this.entries[i];
            if (cref == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<empty>");
            } else {
                sb.append(cref.dumpString(nSpaces + 6, true));
            }
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("</entry>");
            sb.append('\n');
            ++i;
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("</entries>");
        sb.append('\n');
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "IN";
    }

    void traceSplit(Level level, IN parent, IN newSibling, DbLsn parentLsn, DbLsn myNewLsn, DbLsn newSiblingLsn, int splitIndex, int idKeyIndex, int childIndex) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_SPLIT);
            sb.append(" parent=");
            sb.append(parent.getNodeId());
            sb.append(" child=");
            sb.append(this.getNodeId());
            sb.append(" newSibling=");
            sb.append(newSibling.getNodeId());
            sb.append(" parentLsn = ");
            sb.append(parentLsn.getNoFormatString());
            sb.append(" childLsn = ");
            sb.append(myNewLsn.getNoFormatString());
            sb.append(" newSiblingLsn = ");
            sb.append(newSiblingLsn.getNoFormatString());
            sb.append(" splitIdx=");
            sb.append(splitIndex);
            sb.append(" idKeyIdx=");
            sb.append(idKeyIndex);
            sb.append(" childIdx=");
            sb.append(childIndex);
            logger.log(level, sb.toString());
        }
    }

    private void traceDelete(Level level, int index) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_DELETE);
            sb.append(" in=").append(this.getNodeId());
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$tree$IN == null ? (class$com$sleepycat$je$tree$IN = IN.class$("com.sleepycat.je.tree.IN")) : class$com$sleepycat$je$tree$IN).desiredAssertionStatus();
    }
}

