/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DeltaInfo;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BINDelta
implements LoggableObject,
LogReadable {
    private DatabaseId dbId;
    private DbLsn lastFullLsn;
    private List deltas;
    private LogEntryType logEntryType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$tree$BINDelta;

    public BINDelta(BIN bin) {
        this.lastFullLsn = bin.getLastFullVersion();
        this.dbId = bin.getDatabaseId();
        this.deltas = new ArrayList();
        this.logEntryType = bin.getBINDeltaType();
        int i = 0;
        while (i < bin.getNEntries()) {
            ChildReference entry = bin.getEntry(i);
            if (entry.isDirty()) {
                this.deltas.add(new DeltaInfo(entry.getKey(), entry.getLsn(), entry.isKnownDeleted()));
            }
            ++i;
        }
    }

    public BINDelta() {
        this.dbId = new DatabaseId();
        this.lastFullLsn = new DbLsn();
        this.deltas = new ArrayList();
    }

    int getNumDeltas() {
        return this.deltas.size();
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public DbLsn getLastFullLsn() {
        return this.lastFullLsn;
    }

    public BIN reconstituteBIN(EnvironmentImpl env) throws DatabaseException {
        BIN fullBIN = (BIN)env.getLogManager().get(this.lastFullLsn);
        DatabaseImpl db = env.getDbMapTree().getDb(this.dbId);
        fullBIN.setDatabase(db);
        fullBIN.latch();
        int i = 0;
        while (i < this.deltas.size()) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            int foundIndex = fullBIN.findEntry(info.getKey(), true, false);
            if (foundIndex >= 0 && (foundIndex & 0x10000) != 0) {
                foundIndex &= 0xFFFEFFFF;
                if (info.isKnownDeleted()) {
                    fullBIN.setKnownDeleted(foundIndex);
                } else {
                    fullBIN.clearKnownDeleted(foundIndex);
                    fullBIN.updateEntry(foundIndex, info.getLsn());
                }
            } else if (!info.isKnownDeleted()) {
                ChildReference entry = new ChildReference(info.getKey(), info.getLsn(), info.isKnownDeleted());
                boolean insertOk = fullBIN.insertEntry(entry);
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            }
            ++i;
        }
        fullBIN.setGeneration(0L);
        fullBIN.releaseLatch();
        return fullBIN;
    }

    public LogEntryType getLogType() {
        return this.logEntryType;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(DbLsn justLoggedLsn) {
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        this.dbId.readFromLog(itemBuffer);
        this.lastFullLsn.readFromLog(itemBuffer);
        int numDeltas = LogUtils.readInt(itemBuffer);
        int i = 0;
        while (i < numDeltas) {
            DeltaInfo info = new DeltaInfo();
            info.readFromLog(itemBuffer);
            this.deltas.add(info);
            ++i;
        }
    }

    public int getLogSize() {
        int size = this.dbId.getLogSize() + this.lastFullLsn.getLogSize() + 4;
        int i = 0;
        while (i < this.deltas.size()) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            size += info.getLogSize();
            ++i;
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.dbId.writeToLog(logBuffer);
        this.lastFullLsn.writeToLog(logBuffer);
        LogUtils.writeInt(logBuffer, this.deltas.size());
        int i = 0;
        while (i < this.deltas.size()) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            info.writeToLog(logBuffer);
            ++i;
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        sb.append("<lastFullLsn>");
        this.lastFullLsn.dumpLog(sb, verbose);
        sb.append("</lastFullLsn>");
        sb.append("<deltas size=\"").append(this.deltas.size()).append("\"/>");
        int i = 0;
        while (i < this.deltas.size()) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            info.dumpLog(sb, verbose);
            ++i;
        }
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$tree$BINDelta == null ? (class$com$sleepycat$je$tree$BINDelta = BINDelta.class$("com.sleepycat.je.tree.BINDelta")) : class$com$sleepycat$je$tree$BINDelta).desiredAssertionStatus();
    }
}

