/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BIN
extends IN
implements LoggableObject {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    protected Set cursorSet = new HashSet();
    private DbLsn lastFullVersion;
    private DbLsn lastDeltaVersion;
    private int numDeltasSinceLastFull = 0;
    private boolean compressedSinceLastLog = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$tree$BIN;

    public BIN() {
    }

    public BIN(DatabaseImpl db, Key identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    protected IN createNewInstance(Key identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    public Key getChildKey(IN child) throws DatabaseException {
        return child.getDupKey();
    }

    public LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_BIN_DELTA;
    }

    DbLsn getLastFullVersion() {
        return this.lastFullVersion;
    }

    public DbLsn getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    protected void setLastFullLsn(DbLsn lsn) {
        this.lastFullVersion = lsn;
    }

    protected void setCompressedSinceLastLog(boolean val) {
        this.compressedSinceLastLog = val;
    }

    protected void descendOnParentSearch(SearchResult result, IN target, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(target)) {
            if (target.containsDuplicates() && target.isRoot()) {
                long childNid = child.getNodeId();
                ((IN)child).releaseLatch();
                result.keepSearching = false;
                result.exactParentFound = childNid == target.getNodeId();
                if (requireExactMatch && !result.exactParentFound) {
                    result.parent = null;
                    this.releaseLatch();
                } else {
                    result.parent = this;
                }
            } else {
                this.releaseLatch();
                result.parent = (IN)child;
            }
        } else {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (!requireExactMatch && target.containsDuplicates()) {
                result.parent = this;
            } else {
                this.releaseLatch();
                result.parent = null;
            }
        }
    }

    protected boolean canBeAncestor(IN target) {
        return target.containsDuplicates();
    }

    public boolean isEvictable() {
        if (this.evictionProhibited) {
            return false;
        }
        if (this.nCursors() > 0) {
            return false;
        }
        return this.childrenAreEvictable();
    }

    protected boolean childrenAreEvictable() {
        int i = 0;
        while (i < this.getNEntries()) {
            ChildReference ref = this.getEntry(i);
            if (ref.getTarget() != null && !(ref.getTarget() instanceof LN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean entryZeroKeyComparesLow() {
        return false;
    }

    public boolean isKnownDeleted(int index) {
        ChildReference entry = this.getEntry(index);
        return entry == null || entry.isKnownDeleted();
    }

    public void setKnownDeleted(int index) {
        ChildReference entry = this.getEntry(index);
        entry.setKnownDeleted();
        this.updateMemorySize(entry.getTarget(), null);
        entry.setTarget(null);
        this.setDirty(true);
    }

    public void setKnownDeletedLeaveTarget(int index) {
        ChildReference entry = this.getEntry(index);
        entry.setKnownDeleted();
        this.setDirty(true);
    }

    public void clearKnownDeleted(int index) {
        ChildReference entry = this.getEntry(index);
        entry.clearKnownDeleted();
        this.setDirty(true);
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        int capacity = configManager.getInt(EnvironmentParams.NODE_MAX);
        return MemoryBudget.BIN_FIXED_OVERHEAD + MemoryBudget.ARRAY_ITEM_OVERHEAD * (long)capacity;
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getBINOverhead();
    }

    public Set getCursorSet() {
        return this.cursorSet;
    }

    public void addCursor(CursorImpl cursor) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        this.cursorSet.remove(cursor);
    }

    public int nCursors() {
        return this.cursorSet.size();
    }

    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getBIN();
    }

    int getCursorIndex(CursorImpl cursor) {
        return cursor.getIndex();
    }

    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setBIN(bin);
    }

    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setIndex(index);
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, Key key, boolean leftSide) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        if (!$assertionsDisabled && !newSibling.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = (CursorImpl)iter.next();
            int cIdx = this.getCursorIndex(cursor);
            BIN cBin = this.getCursorBIN(cursor);
            if (!$assertionsDisabled && cBin != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(newSibling instanceof BIN)) {
                throw new AssertionError();
            }
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    this.setCursorBIN(cursor, ns);
                    iter.remove();
                    ns.addCursor(cursor);
                    continue;
                }
                this.setCursorIndex(cursor, cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            this.setCursorIndex(cursor, cIdx - newSiblingLow);
            this.setCursorBIN(cursor, ns);
            iter.remove();
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                BIN cBin = this.getCursorBIN(cursor);
                if (!$assertionsDisabled && cBin != this) {
                    throw new AssertionError();
                }
            }
        }
    }

    void adjustCursorsForInsert(int insertIndex) {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                int cIdx = this.getCursorIndex(cursor);
                if (insertIndex > cIdx) continue;
                this.setCursorIndex(cursor, cIdx + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compress() throws DatabaseException {
        boolean setNewIdKey;
        boolean ret;
        block13: {
            ret = false;
            setNewIdKey = false;
            DatabaseImpl db = this.getDatabase();
            BasicLocker lockingTxn = new BasicLocker(db.getDbEnvironment());
            try {
                int i = 0;
                while (true) {
                    block18: {
                        ChildReference child;
                        boolean deleteEntry;
                        block16: {
                            Node n;
                            block17: {
                                block15: {
                                    if (i >= this.getNEntries()) {
                                        Object var13_13 = null;
                                        if (lockingTxn == null) break block13;
                                        break;
                                    }
                                    deleteEntry = false;
                                    child = this.getEntry(i);
                                    n = child.fetchTargetIgnoreKnownDeleted(db, this);
                                    if (n != null) break block15;
                                    deleteEntry = true;
                                    break block16;
                                }
                                if (!child.isKnownDeleted()) break block17;
                                LockGrantType lockRet = lockingTxn.nonBlockingReadLock((LN)n);
                                if (lockRet == LockGrantType.DENIED) break block18;
                                deleteEntry = true;
                                break block16;
                            }
                            if (n.containsDuplicates()) break block16;
                            LN ln = (LN)n;
                            LockGrantType lockRet = lockingTxn.nonBlockingReadLock(ln);
                            if (lockRet == LockGrantType.DENIED) break block18;
                            if (ln.isDeleted()) {
                                deleteEntry = true;
                            }
                        }
                        if (deleteEntry) {
                            boolean entryIsIdentifierKey;
                            Comparator userComparisonFcn = this.getKeyComparator();
                            boolean bl = entryIsIdentifierKey = (userComparisonFcn == null ? child.getKey().compareTo(this.getIdentifierKey()) : userComparisonFcn.compare(child.getKey().getKey(), this.getIdentifierKey().getKey())) == 0;
                            if (entryIsIdentifierKey) {
                                setNewIdKey = true;
                            }
                            boolean deleteSuccess = this.deleteEntry(i, true);
                            if (!$assertionsDisabled && !deleteSuccess) {
                                throw new AssertionError();
                            }
                            --i;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (lockingTxn == null) throw throwable;
                ((Locker)lockingTxn).operationEnd();
                throw throwable;
            }
            ((Locker)lockingTxn).operationEnd();
        }
        if (this.getNEntries() == 0) {
            return true;
        }
        if (!setNewIdKey) return ret;
        this.setIdentifierKey(this.getEntry(0).getKey());
        return ret;
    }

    public long evictLNs() throws DatabaseException {
        if (!$assertionsDisabled && !this.getLatch().isOwner()) {
            throw new AssertionError((Object)"BIN must be latched before evicting LNs");
        }
        long removed = 0L;
        if (this.nCursors() == 0) {
            int i = 0;
            while (i < this.getNEntries()) {
                ChildReference lnRef = this.getEntry(i);
                Node n = lnRef.getTarget();
                if (n != null && n instanceof LN) {
                    lnRef.setTarget(null);
                    removed += n.getMemorySizeIncludedByParent();
                }
                ++i;
            }
            this.updateMemorySize(removed, 0L);
        }
        return removed;
    }

    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidForDelete() throws DatabaseException {
        boolean bl;
        block14: {
            boolean needToLatch;
            block12: {
                boolean bl2;
                block13: {
                    int numValidEntries;
                    int validIndex;
                    block10: {
                        boolean bl3;
                        block11: {
                            block8: {
                                boolean bl4;
                                block9: {
                                    validIndex = 0;
                                    numValidEntries = 0;
                                    needToLatch = !this.getLatch().isOwner();
                                    try {
                                        if (needToLatch) {
                                            this.latch();
                                        }
                                        int i = 0;
                                        while (i < this.getNEntries()) {
                                            if (!this.getEntry(i).isKnownDeleted()) {
                                                ++numValidEntries;
                                                validIndex = i;
                                            }
                                            ++i;
                                        }
                                        if (numValidEntries <= true) break block8;
                                        bl4 = false;
                                        Object var8_9 = null;
                                        if (!needToLatch || !this.getLatch().isOwner()) break block9;
                                    }
                                    catch (Throwable throwable) {
                                        block15: {
                                            Object var8_13 = null;
                                            if (!needToLatch || !this.getLatch().isOwner()) break block15;
                                            this.releaseLatch();
                                        }
                                        throw throwable;
                                    }
                                    this.releaseLatch();
                                }
                                return bl4;
                            }
                            if (this.nCursors() <= 0) break block10;
                            bl3 = false;
                            Object var8_10 = null;
                            if (!needToLatch || !this.getLatch().isOwner()) break block11;
                            this.releaseLatch();
                        }
                        return bl3;
                    }
                    if (numValidEntries != 1) break block12;
                    Node child = this.getEntry(validIndex).fetchTarget(this.getDatabase(), this);
                    bl2 = child.isValidForDelete();
                    Object var8_11 = null;
                    if (!needToLatch || !this.getLatch().isOwner()) break block13;
                    this.releaseLatch();
                }
                return bl2;
            }
            bl = true;
            Object var8_12 = null;
            if (!needToLatch || !this.getLatch().isOwner()) break block14;
            this.releaseLatch();
        }
        return bl;
    }

    public Comparator getKeyComparator() {
        return this.getDatabase().getBtreeComparator();
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    public String shortClassName() {
        return "BIN";
    }

    protected DbLsn logInternal(LogManager logManager, boolean isCheckpoint, boolean isProvisional) throws DatabaseException {
        boolean doDeltaLog = false;
        BINDelta deltaInfo = null;
        if (isCheckpoint && this.lastFullVersion != null && !this.compressedSinceLastLog) {
            deltaInfo = new BINDelta(this);
            doDeltaLog = this.doDeltaLog(deltaInfo);
        }
        DbLsn returnLsn = null;
        if (doDeltaLog) {
            this.lastDeltaVersion = logManager.log(deltaInfo);
            returnLsn = null;
            ++this.numDeltasSinceLastFull;
        } else {
            this.lastFullVersion = returnLsn = logManager.log(new INLogEntry(this), isProvisional, null, false);
            this.numDeltasSinceLastFull = 0;
            this.setCompressedSinceLastLog(false);
            this.setDirty(false);
        }
        return returnLsn;
    }

    private boolean doDeltaLog(BINDelta deltaInfo) throws DatabaseException {
        int maxDiffs = this.getNEntries() * this.getDatabase().getBinDeltaPercent() / 100;
        return deltaInfo.getNumDeltas() <= maxDiffs && this.numDeltasSinceLastFull < this.getDatabase().getBinMaxDeltas();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$tree$BIN == null ? (class$com$sleepycat$je$tree$BIN = BIN.class$("com.sleepycat.je.tree.BIN")) : class$com$sleepycat$je$tree$BIN).desiredAssertionStatus();
    }
}

