/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.RecoveryException;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryManager {
    private static final String TRACE_DUP_ROOT_REPLACE = "DupRootRecover:";
    private static final String TRACE_LN_REDO = "LNRedo:";
    private static final String TRACE_LN_UNDO = "LNUndo";
    private static final String TRACE_IN_REPLACE = "INRecover:";
    private static final String TRACE_ROOT_REPLACE = "RootRecover:";
    private static final String TRACE_IN_DEL_REPLAY = "INDelReplay:";
    private static final int CLEAR_INCREMENT = 100;
    private static final boolean ENABLE_UP_RECOVERY = false;
    private EnvironmentImpl env;
    private int readBufferSize;
    private RecoveryInfo info;
    private Set committedTxnIds;
    private Set inListRebuildDbIds;
    private Level detailedTraceLevel;
    private Map fileSummaryLsns;
    private int inListClearCounter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$recovery$RecoveryManager;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.env = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashSet();
        this.inListRebuildDbIds = new HashSet();
        this.fileSummaryLsns = new HashMap();
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_RECOVERY);
    }

    public RecoveryInfo recover(boolean readOnly) throws DatabaseException {
        this.info = new RecoveryInfo();
        try {
            block6: {
                try {
                    FileManager fileManager = this.env.getFileManager();
                    if (fileManager.filesExist()) {
                        DbLsn checkpointLsn = this.findEndOfLog(readOnly);
                        Tracer.trace(Level.INFO, this.env, "Recovery underway, found end of log");
                        this.findLastCheckpoint(checkpointLsn);
                        Tracer.trace(Level.INFO, this.env, "Recovery checkpoint search, " + this.info);
                        this.env.readMapTreeFromLog(this.info.useRootLsn);
                        this.buildTree();
                    } else {
                        this.env.enableDebugLoggingToDbLog();
                        Tracer.trace(Level.INFO, this.env, "Recovery w/no files.");
                        this.env.logMapTreeRoot();
                    }
                    if (readOnly) break block6;
                    CheckpointConfig config = new CheckpointConfig();
                    config.setForce(true);
                    this.env.getCheckpointer().doCheckpoint(config, false, false, "recovery");
                }
                catch (IOException e) {
                    Tracer.trace(this.env, "RecoveryManager", "recover", "Couldn't recover", e);
                    throw new RecoveryException(this.env, "Couldn't recover: " + e.getMessage(), e);
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Tracer.trace(Level.INFO, this.env, "Recovery finished: " + this.info);
            throw throwable;
        }
        Tracer.trace(Level.INFO, this.env, "Recovery finished: " + this.info);
        return this.info;
    }

    private DbLsn findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        LastFileReader reader = new LastFileReader(this.env, this.readBufferSize);
        reader.setTargetType(LogEntryType.LOG_CKPT_END);
        while (reader.readNextEntry()) {
        }
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastLsn();
        this.info.nextAvailableLsn = reader.getNextAvailableLsn();
        this.env.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.env.enableDebugLoggingToDbLog();
        return reader.getLastSeen(LogEntryType.LOG_CKPT_END);
    }

    private void findLastCheckpoint(DbLsn checkpointLsn) throws IOException, DatabaseException {
        this.info.checkpointEndLsn = checkpointLsn;
        if (this.info.checkpointEndLsn == null) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.env, this.readBufferSize, false, this.info.lastUsedLsn, null, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                if (searcher.isCheckpoint()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (!searcher.isRoot() || this.info.useRootLsn != null) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
        }
        if (this.info.checkpointEndLsn == null) {
            this.info.checkpointStartLsn = null;
            this.info.firstActiveLsn = null;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.env.getLogManager().get(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != null) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.env.getCheckpointer().setCheckpointId(checkpointEnd.getId());
        }
        if (this.info.useRootLsn == null) {
            throw new RecoveryException(this.env, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    private void buildTree() throws IOException, DatabaseException {
        this.inListClearCounter = 0;
        Tracer.trace(Level.INFO, this.env, this.passHeader(1, true) + "read map INs");
        this.readINsAndTrackIds(this.info.checkpointStartLsn);
        Tracer.trace(Level.INFO, this.env, this.passHeader(1, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(2, true) + "read map BINDeltas");
        this.info.numOtherINs += this.readINs(this.info.checkpointStartLsn, true, LogEntryType.LOG_BIN_DELTA, null, null);
        Tracer.trace(Level.INFO, this.env, this.passHeader(2, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(3, true) + "count entries");
        this.countNewEntries(this.info.checkpointStartLsn);
        Tracer.trace(Level.INFO, this.env, this.passHeader(3, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(4, true) + "undo map LNs");
        HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
        mapLNSet.add(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
        this.undoLNs(this.info, mapLNSet);
        Tracer.trace(Level.INFO, this.env, this.passHeader(4, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(5, true) + "redo map LNs");
        mapLNSet.add(LogEntryType.LOG_MAPLN);
        this.redoLNs(this.info.checkpointStartLsn, mapLNSet);
        Tracer.trace(Level.INFO, this.env, this.passHeader(5, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(6, true) + "read other INs");
        this.info.numOtherINs += this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_IN, LogEntryType.LOG_BIN, LogEntryType.LOG_IN_DELETE_INFO);
        Tracer.trace(Level.INFO, this.env, this.passHeader(6, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(7, true) + "read BINDeltas");
        this.info.numBinDeltas = this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_BIN_DELTA, null, null);
        Tracer.trace(Level.INFO, this.env, this.passHeader(7, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(8, true) + "read dup INs");
        this.info.numDuplicateINs += this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_DIN, LogEntryType.LOG_DBIN, LogEntryType.LOG_IN_DELETE_INFO);
        Tracer.trace(Level.INFO, this.env, this.passHeader(8, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(9, true) + "read dup BINDeltas");
        this.info.numBinDeltas += this.readINs(this.info.checkpointStartLsn, false, LogEntryType.LOG_DUP_BIN_DELTA, null, null);
        Tracer.trace(Level.INFO, this.env, this.passHeader(9, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(10, true) + "undo LNs");
        HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
        lnSet.add(LogEntryType.LOG_LN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL);
        this.undoLNs(this.info, lnSet);
        Tracer.trace(Level.INFO, this.env, this.passHeader(10, false) + this.info.toString());
        Tracer.trace(Level.INFO, this.env, this.passHeader(11, true) + "redo LNs");
        lnSet.add(LogEntryType.LOG_LN);
        lnSet.add(LogEntryType.LOG_NAMELN);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN);
        lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
        this.redoLNs(this.info.checkpointStartLsn, lnSet);
        Tracer.trace(Level.INFO, this.env, this.passHeader(11, false) + this.info.toString());
        this.committedTxnIds = null;
        this.fileSummaryLsns = null;
        this.rebuildINList();
    }

    private void readINsAndTrackIds(DbLsn rollForwardLsn) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, true, false);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_IN_DELETE_INFO);
        try {
            this.info.numMapINs = 0;
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                this.replayOneIN(reader, db);
                ++this.info.numMapINs;
            }
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                if (this.info.useMaxNodeId < this.info.checkpointEnd.getLastNodeId()) {
                    this.info.useMaxNodeId = this.info.checkpointEnd.getLastNodeId();
                }
                if (this.info.useMaxDbId < this.info.checkpointEnd.getLastDbId()) {
                    this.info.useMaxDbId = this.info.checkpointEnd.getLastDbId();
                }
                if (this.info.useMaxTxnId < this.info.checkpointEnd.getLastTxnId()) {
                    this.info.useMaxTxnId = this.info.checkpointEnd.getLastTxnId();
                }
            }
            Node.setLastNodeId(this.info.useMaxNodeId);
            this.env.getDbMapTree().setLastDbId(this.info.useMaxDbId);
            this.env.getTxnManager().setLastTxnId(this.info.useMaxTxnId);
        }
        catch (Exception e) {
            Tracer.trace(this.env, "RecoveryManager", "readMapIns", "last Lsn = " + reader.getLastLsn().getNoFormatString(), e);
            throw new DatabaseException(e);
        }
    }

    private int readINs(DbLsn rollForwardLsn, boolean mapDbOnly, LogEntryType inType1, LogEntryType inType2, LogEntryType inType3) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, false, mapDbOnly);
        if (inType1 != null) {
            reader.addTargetType(inType1);
        }
        if (inType2 != null) {
            reader.addTargetType(inType2);
        }
        if (inType3 != null) {
            reader.addTargetType(inType3);
        }
        int numINsSeen = 0;
        try {
            DbTree dbMapTree = this.env.getDbMapTree();
            while (reader.readNextEntry()) {
                DatabaseImpl db;
                DatabaseId dbId = reader.getDatabaseId();
                boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
                boolean isTarget = false;
                if (mapDbOnly && isMapDb) {
                    isTarget = true;
                } else if (!mapDbOnly && !isMapDb) {
                    isTarget = true;
                }
                if (!isTarget || (db = dbMapTree.getDb(dbId)) == null) continue;
                this.replayOneIN(reader, db);
                ++numINsSeen;
                this.inListRebuildDbIds.add(dbId);
            }
            return numINsSeen;
        }
        catch (Exception e) {
            Tracer.trace(this.env, "RecoveryManager", "readNonMapIns", "last Lsn = " + reader.getLastLsn().getNoFormatString(), e);
            throw new DatabaseException(e);
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db) throws DatabaseException {
        if (reader.isDeleteInfo()) {
            this.replayINDelete(db, reader.getDeletedNodeId(), reader.getDeletedIdKey(), reader.getLastLsn());
        } else {
            IN in = reader.getIN();
            DbLsn inLsn = reader.getLsnOfIN();
            in.postRecoveryInit(db, inLsn);
            in.latch();
            this.replaceOrInsert(db, in, reader.getLastLsn(), inLsn);
        }
        if (this.inListClearCounter % 100 == 0) {
            this.env.getInMemoryINs().clear();
        } else {
            ++this.inListClearCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undoLNs(RecoveryInfo info, Set lnTypes) throws IOException, DatabaseException {
        DbLsn firstActiveLsn = info.firstActiveLsn;
        DbLsn lastUsedLsn = info.lastUsedLsn;
        DbLsn endOfFileLsn = info.nextAvailableLsn;
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, lastUsedLsn, false, endOfFileLsn, firstActiveLsn, null);
        Iterator iter = lnTypes.iterator();
        while (iter.hasNext()) {
            LogEntryType lnType = (LogEntryType)iter.next();
            reader.addTargetType(lnType);
        }
        HashMap countedFileSummaries = new HashMap();
        HashSet countedAbortLsnNodes = new HashSet();
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        try {
            while (true) {
                if (!reader.readNextEntry()) {
                    return;
                }
                if (reader.isLN()) {
                    Long txnId = reader.getTxnId();
                    if (this.committedTxnIds.contains(txnId)) continue;
                    LN ln = reader.getLN();
                    DbLsn logLsn = reader.getLastLsn();
                    DbLsn abortLsn = reader.getAbortLsn();
                    boolean abortKnownDeleted = reader.getAbortKnownDeleted();
                    DatabaseId dbId = reader.getDatabaseId();
                    DatabaseImpl db = dbMapTree.getDb(dbId);
                    if (db != null) {
                        Object var20_22;
                        ln.postFetchInit(db);
                        try {
                            RecoveryManager.undo(this.detailedTraceLevel, db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, abortLsn, abortKnownDeleted, info, true);
                            this.inListRebuildDbIds.add(dbId);
                            var20_22 = null;
                            if (location.bin != null) {
                                location.bin.releaseLatch();
                            }
                        }
                        catch (Throwable throwable) {
                            var20_22 = null;
                            if (location.bin == null) throw throwable;
                            location.bin.releaseLatch();
                            throw throwable;
                        }
                    }
                    TxnNodeId txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                    this.undoUtilizationInfo(ln, logLsn, abortLsn, abortKnownDeleted, txnNodeId, countedFileSummaries, countedAbortLsnNodes);
                    continue;
                }
                this.committedTxnIds.add(new Long(reader.getTxnCommitId()));
            }
        }
        catch (Exception e) {
            Tracer.trace(this.env, "RecoveryManager", "undoLNs", "last Lsn = " + reader.getLastLsn().getNoFormatString(), e);
            throw new DatabaseException(e);
        }
    }

    private void redoLNs(DbLsn rollForwardLsn, Set lnTypes) throws IOException, DatabaseException {
        LNFileReader reader = new LNFileReader(this.env, this.readBufferSize, rollForwardLsn, true, null, null, null);
        Iterator iter = lnTypes.iterator();
        while (iter.hasNext()) {
            LogEntryType lnType = (LogEntryType)iter.next();
            reader.addTargetType(lnType);
        }
        HashSet countedAbortLsnNodes = new HashSet();
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        try {
            while (reader.readNextEntry()) {
                Long txnId;
                if (!reader.isLN() || (txnId = reader.getTxnId()) != null && (txnId == null || !this.committedTxnIds.contains(txnId))) continue;
                LN ln = reader.getLN();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                DbLsn logLsn = reader.getLastLsn();
                DbLsn treeLsn = null;
                if (db != null) {
                    ln.postFetchInit(db);
                    treeLsn = this.redo(db, location, ln, reader.getKey(), reader.getDupTreeKey(), logLsn, this.info);
                    this.inListRebuildDbIds.add(dbId);
                }
                TxnNodeId txnNodeId = null;
                if (txnId != null) {
                    txnNodeId = new TxnNodeId(reader.getNodeId(), txnId);
                }
                this.redoUtilizationInfo(logLsn, treeLsn, reader.getAbortLsn(), reader.getAbortKnownDeleted(), ln, txnNodeId, countedAbortLsnNodes);
            }
        }
        catch (Exception e) {
            Tracer.trace(this.env, "RecoveryManager", "redoLNs", "last Lsn = " + reader.getLastLsn().getNoFormatString(), e);
            throw new DatabaseException(e);
        }
    }

    private void countNewEntries(DbLsn startLsn) throws IOException, DatabaseException {
    }

    private void rebuildINList() throws DatabaseException {
        this.env.getInMemoryINs().clear();
        this.env.getDbMapTree().rebuildINListMapDb();
        Iterator iter = this.inListRebuildDbIds.iterator();
        while (iter.hasNext()) {
            DatabaseId dbId = (DatabaseId)iter.next();
            if (dbId.equals(DbTree.ID_DB_ID)) continue;
            DatabaseImpl db = this.env.getDbMapTree().getDb(dbId);
            db.getTree().rebuildINList();
        }
    }

    private void replaceOrInsert(DatabaseImpl db, IN inFromLog, DbLsn logLsn, DbLsn inLsn) throws DatabaseException {
        ArrayList trackingList = null;
        try {
            if (inFromLog.isRoot()) {
                if (inFromLog.containsDuplicates()) {
                    this.replaceOrInsertDuplicateRoot(db, (DIN)inFromLog, logLsn);
                } else {
                    this.replaceOrInsertRoot(db, inFromLog, logLsn);
                }
            } else {
                trackingList = new ArrayList();
                this.replaceOrInsertChild(db, inFromLog, logLsn, inLsn, trackingList);
            }
        }
        catch (Exception e) {
            String trace = this.printTrackList(trackingList);
            Tracer.trace(db.getDbEnvironment(), "Tree", "replaceOrInsert", " lsnFromLog:" + logLsn.getNoFormatString() + " " + trace, e);
            throw new DatabaseException(e);
        }
        finally {
            if (inFromLog.getLatch().isOwner()) {
                inFromLog.releaseLatch();
            }
            if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                throw new AssertionError((Object)(Latch.latchesHeldToString() + "Lsn = " + logLsn + " inFromLog = " + inFromLog.getNodeId()));
            }
        }
    }

    private String printTrackList(List trackingList) {
        if (trackingList != null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = trackingList.iterator();
            sb.append("Trace list:");
            sb.append('\n');
            while (iter.hasNext()) {
                sb.append((TrackingInfo)iter.next());
                sb.append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayINDelete(DatabaseImpl db, long logNid, Key logIdKey, DbLsn logLsn) throws DatabaseException {
        IN parent = null;
        boolean found = false;
        boolean deleted = false;
        int index = -1;
        try {
            Tree tree = db.getTree();
            parent = tree.search(logIdKey, Tree.SearchType.NORMAL, logNid, false);
            if (parent == null) {
                tree.withRootLatched(new RootDeleter(tree));
                DbTree dbTree = db.getDbEnvironment().getDbMapTree();
                dbTree.modifyDbRoot(db);
                Tracer.traceRootDeletion(Level.FINE, db);
                deleted = true;
            } else {
                index = parent.findEntry(logIdKey, false, true);
                if (index >= 0) {
                    found = true;
                    deleted = parent.deleteEntry(index, false);
                }
            }
        }
        finally {
            if (parent != null) {
                parent.releaseLatch();
            }
            this.traceINDeleteReplay(logNid, logLsn, found, deleted, index);
        }
    }

    private void replaceOrInsertRoot(DatabaseImpl db, IN inFromLog, DbLsn lsn) throws DatabaseException {
        boolean success = true;
        Tree tree = db.getTree();
        RootUpdater rootUpdater = new RootUpdater(tree, inFromLog, lsn);
        try {
            tree.withRootLatched(rootUpdater);
            if (rootUpdater.updateDone()) {
                EnvironmentImpl env = db.getDbEnvironment();
                env.getDbMapTree().modifyDbRoot(db);
            }
        }
        catch (Exception e) {
            success = false;
            throw new DatabaseException(e);
        }
        finally {
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), null, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertDuplicateRoot(DatabaseImpl db, DIN inFromLog, DbLsn lsn) throws DatabaseException {
        boolean success;
        int index;
        IN parent;
        DbLsn originalLsn;
        boolean replaced;
        boolean inserted;
        boolean found;
        block8: {
            found = true;
            inserted = false;
            replaced = false;
            originalLsn = null;
            Key mainTreeKey = inFromLog.getMainTreeKey();
            parent = null;
            index = -1;
            success = false;
            try {
                parent = db.getTree().search(mainTreeKey, Tree.SearchType.NORMAL, -1L, false);
                if (!$assertionsDisabled && !(parent instanceof BIN)) {
                    throw new AssertionError();
                }
                index = parent.findEntry(mainTreeKey, false, true);
                if (index >= 0) {
                    ChildReference childRef = parent.getEntry(index);
                    originalLsn = childRef.getLsn();
                    if (originalLsn.compareTo(lsn) < 0) {
                        ChildReference newDupRoot = new ChildReference(inFromLog, mainTreeKey, lsn);
                        parent.setEntry(index, newDupRoot);
                        replaced = true;
                    }
                } else {
                    ChildReference newRef = new ChildReference(inFromLog, mainTreeKey, lsn);
                    boolean insertOk = parent.insertEntry(newRef);
                    if (!$assertionsDisabled && !insertOk) {
                        throw new AssertionError();
                    }
                    found = false;
                }
                success = true;
                if (parent == null) break block8;
            }
            catch (Throwable throwable) {
                if (parent != null) {
                    parent.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, null, index);
                throw throwable;
            }
            parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_DUP_ROOT_REPLACE, success, inFromLog, lsn, parent, found, replaced, inserted, originalLsn, null, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertChild(DatabaseImpl db, IN inFromLog, DbLsn logLsn, DbLsn inLsn, List trackingList) throws DatabaseException {
        SearchResult result;
        boolean success;
        DbLsn originalLsn;
        boolean replaced;
        boolean inserted;
        block12: {
            block14: {
                Key idKey;
                block13: {
                    block10: {
                        block11: {
                            inserted = false;
                            replaced = false;
                            originalLsn = null;
                            success = false;
                            result = new SearchResult();
                            try {
                                result = db.getTree().getParentINForChildIN(inFromLog, false, trackingList);
                                if (result.parent != null) break block10;
                                if (result.parent == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (result.parent != null) {
                                    result.parent.releaseLatch();
                                }
                                RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, null, result.index);
                                throw throwable;
                            }
                            result.parent.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, null, result.index);
                        return;
                    }
                    idKey = result.parent.getChildKey(inFromLog);
                    if (result.index < 0) break block13;
                    ChildReference childRef = result.parent.getEntry(result.index);
                    if (!childRef.getLsn().equals(logLsn)) {
                        if (result.exactParentFound) {
                            originalLsn = childRef.getLsn();
                            if (originalLsn.compareTo(logLsn) < 0) {
                                result.parent.updateEntry(result.index, inFromLog, inLsn);
                                replaced = true;
                            }
                            break block14;
                        } else {
                            ChildReference ref = new ChildReference(inFromLog, idKey, inLsn);
                            boolean insertOk = result.parent.insertEntry(ref);
                            if (!$assertionsDisabled && !insertOk) {
                                throw new AssertionError((Object)("Nomatch, couln't insert for lsn " + logLsn + " parent=" + result.parent.getNodeId() + " index=" + result.index));
                            }
                            inserted = true;
                        }
                    }
                    break block14;
                }
                ChildReference newRef = new ChildReference(inFromLog, idKey, inLsn);
                boolean insertOk = result.parent.insertEntry(newRef);
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
                inserted = true;
            }
            success = true;
            if (result.parent == null) break block12;
            result.parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_IN_REPLACE, success, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, null, result.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbLsn redo(DatabaseImpl db, TreeLocation location, LN lnFromLog, Key mainKey, Key dupKey, DbLsn logLsn, RecoveryInfo info) throws DatabaseException {
        boolean found = false;
        boolean replaced = false;
        boolean inserted = false;
        boolean success = false;
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, true, false, true);
            if (!found && location.bin == null) {
                success = true;
                DbLsn dbLsn = null;
                return dbLsn;
            }
            if (lnFromLog.containsDuplicates()) {
                if (!found) {
                    throw new DatabaseException("Couldn't find BIN parent while redo'ing DupCountLN");
                }
                DIN duplicateRoot = (DIN)location.bin.getEntry(location.index).fetchTarget(db, location.bin);
                if (logLsn.compareTo(location.childLsn) >= 0) {
                    duplicateRoot.updateDupCountLNRefAndNullTarget(logLsn);
                }
            } else if (found) {
                ++info.lnFound;
                if (logLsn.compareTo(location.childLsn) > 0) {
                    ++info.lnReplaced;
                    replaced = true;
                    location.bin.updateEntry(location.index, null, logLsn);
                }
                if (logLsn.compareTo(location.childLsn) >= 0 && lnFromLog.isDeleted()) {
                    db.getDbEnvironment().addToCompressorQueue(location.bin);
                }
            } else {
                ++info.lnNotFound;
                if (!lnFromLog.isDeleted()) {
                    ++info.lnInserted;
                    inserted = true;
                    boolean insertOk = RecoveryManager.insertRecovery(db, location, logLsn);
                    if (!$assertionsDisabled && !insertOk) {
                        throw new AssertionError();
                    }
                }
            }
            success = true;
            DbLsn dbLsn = found ? location.childLsn : null;
            return dbLsn;
        }
        finally {
            if (location.bin != null) {
                location.bin.releaseLatch();
            }
            RecoveryManager.trace(this.detailedTraceLevel, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, found, replaced, inserted, location.childLsn, null, location.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean undo(Level traceLevel, DatabaseImpl db, TreeLocation location, LN lnFromLog, Key mainKey, Key dupKey, DbLsn logLsn, DbLsn abortLsn, boolean abortKnownDeleted, RecoveryInfo info, boolean splitsAllowed) throws DatabaseException {
        boolean found = false;
        boolean replaced = false;
        boolean success = false;
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, mainKey, dupKey, lnFromLog, splitsAllowed, true, false);
            if (lnFromLog.containsDuplicates()) {
                if (!found) {
                    throw new DatabaseException("Couldn't find duplicateRoot while undo'ing DupCountLN.  duplicateRoot should have been recovered in earlier pass.");
                }
                DIN duplicateRoot = (DIN)location.bin.getEntry(location.index).fetchTarget(db, location.bin);
                if (logLsn.compareTo(location.childLsn) == 0) {
                    duplicateRoot.updateDupCountLNRefAndNullTarget(abortLsn);
                    replaced = true;
                }
            } else if (found) {
                boolean updateEntry;
                if (info != null) {
                    ++info.lnFound;
                }
                boolean bl = updateEntry = logLsn.compareTo(location.childLsn) == 0;
                if (updateEntry) {
                    if (abortLsn == null) {
                        location.bin.setKnownDeletedLeaveTarget(location.index);
                        db.getDbEnvironment().addToCompressorQueue(location.bin);
                    } else {
                        if (info != null) {
                            ++info.lnReplaced;
                        }
                        replaced = true;
                        location.bin.updateEntry(location.index, null, abortLsn);
                        if (abortKnownDeleted) {
                            location.bin.setKnownDeleted(location.index);
                        } else {
                            location.bin.clearKnownDeleted(location.index);
                        }
                    }
                }
            } else if (info != null) {
                ++info.lnNotFound;
            }
            success = true;
            boolean bl = replaced;
            return bl;
        }
        finally {
            RecoveryManager.trace(traceLevel, db, TRACE_LN_UNDO, success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
        }
    }

    private static boolean insertRecovery(DatabaseImpl db, TreeLocation location, DbLsn logLsn) throws DatabaseException {
        BIN parentBIN = location.bin;
        ChildReference newLNRef = new ChildReference(null, location.lnKey, logLsn);
        int entryIndex = parentBIN.insertEntry1(newLNRef);
        if ((entryIndex & 0x20000) == 0) {
            boolean canOverwrite = false;
            ChildReference currentRef = parentBIN.getEntry(entryIndex &= 0xFFFEFFFF);
            if (currentRef.isKnownDeleted()) {
                canOverwrite = true;
            } else {
                LN currentLN = (LN)currentRef.fetchTarget(db, parentBIN);
                if (currentLN.isDeleted()) {
                    canOverwrite = true;
                }
                currentRef.clearTarget();
            }
            if (canOverwrite) {
                parentBIN.updateEntry(entryIndex, null, logLsn, location.lnKey);
                parentBIN.clearKnownDeleted(entryIndex);
                location.index = entryIndex;
                return true;
            }
            return false;
        }
        location.index = entryIndex & 0xFFFDFFFF;
        return true;
    }

    private void redoUtilizationInfo(DbLsn logLsn, DbLsn treeLsn, DbLsn abortLsn, boolean abortKnownDeleted, LN ln, TxnNodeId txnNodeId, Set countedAbortLsnNodes) {
    }

    private void undoUtilizationInfo(LN ln, DbLsn logLsn, DbLsn abortLsn, boolean abortKnownDeleted, TxnNodeId txnNodeId, Map countedFileSummaries, Set countedAbortLsnNodes) {
    }

    private String passHeader(int passNum, boolean start) {
        String status = start ? " start " : " end ";
        return "Recovery Pass " + passNum + status + ": ";
    }

    private static void trace(Level level, DatabaseImpl database, String debugType, boolean success, Node node, DbLsn logLsn, IN parent, boolean found, boolean replaced, boolean inserted, DbLsn replacedLsn, DbLsn abortLsn, int index) {
        Logger logger = database.getDbEnvironment().getLogger();
        Level useLevel = level;
        if (!success) {
            useLevel = Level.SEVERE;
        }
        if (logger.isLoggable(useLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(debugType);
            sb.append(" success=").append(success);
            sb.append(" node=");
            sb.append(node.getNodeId());
            sb.append(" lsn=");
            sb.append(logLsn.getNoFormatString());
            if (parent != null) {
                sb.append(" parent=").append(parent.getNodeId());
            }
            sb.append(" found=");
            sb.append(found);
            sb.append(" replaced=");
            sb.append(replaced);
            sb.append(" inserted=");
            sb.append(inserted);
            if (replacedLsn != null) {
                sb.append(" replacedLsn=");
                sb.append(replacedLsn.getNoFormatString());
            }
            if (abortLsn != null) {
                sb.append(" abortLsn=");
                sb.append(abortLsn.getNoFormatString());
            }
            sb.append(" index=").append(index);
            logger.log(useLevel, sb.toString());
        }
    }

    private void traceINDeleteReplay(long nodeId, DbLsn logLsn, boolean found, boolean deleted, int index) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(this.detailedTraceLevel)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_IN_DEL_REPLAY);
            sb.append(" node=").append(nodeId);
            sb.append(" lsn=").append(logLsn.getNoFormatString());
            sb.append(" found=").append(found);
            sb.append(" deleted=").append(deleted);
            sb.append(" index=").append(index);
            logger.log(this.detailedTraceLevel, sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$recovery$RecoveryManager == null ? (class$com$sleepycat$je$recovery$RecoveryManager = RecoveryManager.class$("com.sleepycat.je.recovery.RecoveryManager")) : class$com$sleepycat$je$recovery$RecoveryManager).desiredAssertionStatus();
    }

    private class RootUpdater
    implements WithRootLatched {
        private Tree tree;
        private IN inFromLog;
        private DbLsn lsn;
        private boolean inserted = false;
        private boolean replaced = false;
        private DbLsn originalLsn;

        RootUpdater(Tree tree, IN inFromLog, DbLsn lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = new ChildReference(this.inFromLog, new Key(new byte[0]), this.lsn);
            this.inFromLog.releaseLatch();
            if (root == null) {
                this.tree.setRoot(newRoot);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (root.getLsn().compareTo(this.lsn) < 0) {
                    this.tree.setRoot(newRoot);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        DbLsn getOriginalLsn() {
            return this.originalLsn;
        }
    }

    private class RootDeleter
    implements WithRootLatched {
        Tree tree;

        RootDeleter(Tree tree) {
            this.tree = tree;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            this.tree.setRoot(null);
            return null;
        }
    }

    private class TxnNodeId {
        long nodeId;
        long txnId;

        TxnNodeId(long nodeId, long txnId) {
            this.nodeId = nodeId;
            this.txnId = txnId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TxnNodeId)) {
                return false;
            }
            return ((TxnNodeId)obj).txnId == this.txnId && ((TxnNodeId)obj).nodeId == this.nodeId;
        }

        public int hashCode() {
            return (int)(this.txnId + this.nodeId);
        }

        public String toString() {
            return "txnId=" + this.txnId + "/nodeId=" + this.nodeId;
        }
    }
}

