/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

public class Checkpointer
extends DaemonThread {
    private EnvironmentImpl envImpl;
    private long checkpointId;
    private long logSizeBytesInterval;
    private long logFileMax;
    private long timeInterval;
    private long lastCheckpointMillis;
    private int nCheckpoints;
    private DbLsn lastFirstActiveLsn;
    private DbLsn lastCheckpointStart;
    private DbLsn lastCheckpointEnd;
    private int nFullINFlush;
    private int nDeltaINFlush;
    private int nFullINFlushThisRun;
    private int nDeltaINFlushThisRun;
    private int highestFlushLevel;

    public Checkpointer(EnvironmentImpl envImpl, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, envImpl);
        this.envImpl = envImpl;
        this.logSizeBytesInterval = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.logFileMax = envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        this.nCheckpoints = 0;
        this.timeInterval = waitTime;
        this.lastCheckpointMillis = 0L;
        this.setName("Checkpointer Thread");
    }

    public static long getWakeupPeriod(DbConfigManager configManager) throws IllegalArgumentException, DatabaseException {
        long wakeupPeriod = PropUtil.microsToMillis(configManager.getLong(EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL));
        long bytePeriod = configManager.getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        if (wakeupPeriod == 0L && bytePeriod == 0L) {
            throw new IllegalArgumentException(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL.getName() + " and " + EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL.getName() + " cannot both be 0. ");
        }
        if (bytePeriod == 0L) {
            return wakeupPeriod;
        }
        return 0L;
    }

    public void setCheckpointId(long lastCheckpointId) {
        this.checkpointId = lastCheckpointId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Checkpointer name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void loadStats(StatsConfig config, EnvironmentStatsInternal stat) throws DatabaseException {
        stat.setNCheckpoints(this.nCheckpoints);
        stat.setLastCheckpointStart(this.lastCheckpointStart);
        stat.setLastCheckpointEnd(this.lastCheckpointEnd);
        stat.setLastCheckpointId(this.checkpointId);
        stat.setNFullINFlush(this.nFullINFlush);
        stat.setNDeltaINFlush(this.nDeltaINFlush);
        if (config.getClear()) {
            this.nCheckpoints = 0;
            this.nFullINFlush = 0;
            this.nDeltaINFlush = 0;
        }
    }

    public DbLsn getFirstActiveLsn() {
        return this.lastFirstActiveLsn;
    }

    public void clearEnv() {
        this.envImpl = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.CHECKPOINTER_RETRY);
    }

    protected void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doCheckpoint(CheckpointConfig.DEFAULT, true, false, "daemon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunnable(CheckpointConfig config) throws DatabaseException {
        long useBytesInterval = 0L;
        long useTimeInterval = 0L;
        DbLsn nextLsn = null;
        try {
            if (config.getForce()) {
                boolean bl = true;
                return bl;
            }
            if (config.getKBytes() != 0) {
                useBytesInterval = config.getKBytes() << 10;
            } else if (config.getMinutes() != 0) {
                useTimeInterval = config.getMinutes() * 60 * 1000;
            } else if (this.logSizeBytesInterval != 0L) {
                useBytesInterval = this.logSizeBytesInterval;
            } else {
                useTimeInterval = this.timeInterval;
            }
            if (useBytesInterval != 0L) {
                nextLsn = this.envImpl.getFileManager().getNextLsn();
                if (nextLsn.getDistance(this.lastCheckpointEnd, this.logFileMax) >= useBytesInterval) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (useTimeInterval != 0L) {
                DbLsn lastUsedLsn = this.envImpl.getFileManager().getLastUsedLsn();
                if (System.currentTimeMillis() - this.lastCheckpointMillis >= useTimeInterval && lastUsedLsn.compareTo(this.lastCheckpointEnd) != 0) {
                    boolean sb = true;
                    return sb;
                }
                boolean sb = false;
                return sb;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            StringBuffer sb = new StringBuffer();
            sb.append("size interval=").append(useBytesInterval);
            if (nextLsn != null) {
                sb.append(" nextLsn=").append(nextLsn.getNoFormatString());
            }
            if (this.lastCheckpointEnd != null) {
                sb.append(" lastCkpt=");
                sb.append(this.lastCheckpointEnd.getNoFormatString());
            }
            sb.append(" time interval=").append(useTimeInterval);
            sb.append(" force=").append(config.getForce());
            Tracer.trace(Level.FINEST, this.envImpl, sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckpoint(CheckpointConfig config, boolean allowDeltas, boolean flushAll, String invokingSource) throws DatabaseException {
        Evictor evictor = this.envImpl.getEvictor();
        synchronized (evictor) {
            this.doCheckpointInternal(config, allowDeltas, flushAll, invokingSource);
        }
    }

    private synchronized void doCheckpointInternal(CheckpointConfig config, boolean allowDeltas, boolean flushAll, String invokingSource) throws DatabaseException {
        if (!this.isRunnable(config)) {
            return;
        }
        this.lastCheckpointMillis = System.currentTimeMillis();
        this.resetPerRunCounters();
        LogManager logManager = this.envImpl.getLogManager();
        ++this.checkpointId;
        ++this.nCheckpoints;
        boolean success = false;
        boolean traced = false;
        try {
            try {
                CheckpointStart startEntry = new CheckpointStart(this.checkpointId, invokingSource);
                DbLsn checkpointStart = logManager.log(startEntry);
                DbLsn firstActiveLsn = this.envImpl.getTxnManager().getFirstActiveLsn();
                if (firstActiveLsn != null && checkpointStart.compareTo(firstActiveLsn) < 0) {
                    firstActiveLsn = checkpointStart;
                }
                this.flushDirtyNodes(flushAll, allowDeltas);
                this.flushUtilizationInfo();
                if (firstActiveLsn == null) {
                    firstActiveLsn = checkpointStart;
                }
                CheckpointEnd endEntry = new CheckpointEnd(invokingSource, checkpointStart, this.envImpl.getRootLsn(), firstActiveLsn, Node.getLastId(), this.envImpl.getDbMapTree().getLastDbId(), this.envImpl.getTxnManager().getLastTxnId(), this.checkpointId);
                this.trace(this.envImpl, invokingSource, true);
                traced = true;
                this.lastCheckpointEnd = flushAll ? logManager.logForceFlush(endEntry) : logManager.log(endEntry);
                this.lastFirstActiveLsn = firstActiveLsn;
                this.lastCheckpointStart = checkpointStart;
                this.accumulatePerRunCounters();
                success = true;
            }
            catch (DatabaseException e) {
                Tracer.trace(this.envImpl, "Checkpointer", "doCheckpoint", "checkpointId=" + this.checkpointId, e);
                throw e;
            }
            Object var13_13 = null;
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
            throw throwable;
        }
    }

    private void trace(EnvironmentImpl envImpl, String invokingSource, boolean success) {
        StringBuffer sb = new StringBuffer();
        sb.append("Checkpoint ").append(this.checkpointId);
        sb.append(": source=").append(invokingSource);
        sb.append(" success=").append(success);
        sb.append(" nFullINFlushThisRun=").append(this.nFullINFlushThisRun);
        sb.append(" nDeltaINFlushThisRun=").append(this.nDeltaINFlushThisRun);
        Tracer.trace(Level.INFO, envImpl, sb.toString());
    }

    private void flushUtilizationInfo() throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.envImpl.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        TrackedFileSummary[] activeFiles = this.envImpl.getUtilizationTracker().getTrackedFiles();
        int i = 0;
        while (i < activeFiles.length) {
            TrackedFileSummary trackedFile = activeFiles[i];
            profile.putFileSummary(trackedFile);
            ++i;
        }
    }

    private void flushDirtyNodes(boolean flushAll, boolean allowDeltas) throws DatabaseException {
        LogManager logManager = this.envImpl.getLogManager();
        SortedMap dirtyMap = this.selectDirtyINs(flushAll);
        while (dirtyMap.size() > 0) {
            Integer currentLevel = (Integer)dirtyMap.firstKey();
            boolean logProvisionally = currentLevel != this.highestFlushLevel;
            Set nodeSet = (Set)dirtyMap.get(currentLevel);
            Iterator iter = nodeSet.iterator();
            while (iter.hasNext()) {
                IN target = (IN)iter.next();
                target.latch();
                boolean triedToFlush = false;
                if (target.getDirty() && !target.getDatabase().getIsDeleted()) {
                    this.flushIN(target, logManager, dirtyMap, logProvisionally, allowDeltas);
                    triedToFlush = true;
                } else {
                    target.releaseLatch();
                }
                Tracer.trace(Level.FINE, this.envImpl, "Checkpointer: node=" + target.getNodeId() + " level=" + Integer.toHexString(target.getLevel()) + " flushed=" + triedToFlush);
            }
            dirtyMap.remove(currentLevel);
            if (currentLevel == this.highestFlushLevel) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap selectDirtyINs(boolean flushAll) throws DatabaseException {
        TreeMap newDirtyMap = new TreeMap();
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.latchMajor();
        long totalSize = 0L;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        try {
            Iterator iter = inMemINs.iterator();
            while (iter.hasNext()) {
                Set<IN> dirtySet;
                IN in = (IN)iter.next();
                in.latch();
                totalSize = mb.accumulateNewUsage(in, totalSize);
                boolean isDirty = in.getDirty();
                in.releaseLatch();
                if (!isDirty) continue;
                Integer level = new Integer(in.getLevel());
                if (newDirtyMap.containsKey(level)) {
                    dirtySet = (Set)newDirtyMap.get(level);
                } else {
                    dirtySet = new HashSet();
                    newDirtyMap.put(level, dirtySet);
                }
                dirtySet.add(in);
            }
            if (newDirtyMap.size() > 0) {
                this.highestFlushLevel = flushAll ? this.envImpl.getDbMapTree().getHighestLevel() : ((Integer)newDirtyMap.lastKey()).intValue();
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            inMemINs.releaseMajorLatchIfHeld();
            throw throwable;
        }
        inMemINs.releaseMajorLatchIfHeld();
        return newDirtyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIN(IN target, LogManager logManager, Map dirtyMap, boolean logProvisionally, boolean allowDeltas) throws DatabaseException {
        DatabaseImpl db = target.getDatabase();
        Tree tree = db.getTree();
        boolean targetWasRoot = false;
        if (target.isDbRoot()) {
            target.releaseLatch();
            RootFlusher flusher = new RootFlusher(db, logManager, target);
            tree.withRootLatched(flusher);
            boolean flushed = flusher.getFlushed();
            targetWasRoot = flusher.stillRoot();
            if (flushed) {
                DbTree dbTree = db.getDbEnvironment().getDbMapTree();
                dbTree.modifyDbRoot(db);
                ++this.nFullINFlushThisRun;
            }
            if (!targetWasRoot) {
                target.latch();
            }
        }
        if (!targetWasRoot) {
            SearchResult result = tree.getParentINForChildIN(target, true);
            if (result.exactParentFound) {
                try {
                    ChildReference entry = result.parent.getEntry(result.index);
                    IN renewedTarget = (IN)entry.fetchTarget(db, result.parent);
                    renewedTarget.latch();
                    DbLsn newLsn = null;
                    try {
                        if (renewedTarget.getDirty()) {
                            if (allowDeltas) {
                                newLsn = renewedTarget.logFromCheckpoint(logManager, logProvisionally);
                                if (newLsn == null) {
                                    ++this.nDeltaINFlushThisRun;
                                }
                            } else {
                                newLsn = renewedTarget.log(logManager, logProvisionally);
                            }
                        }
                        Object var14_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        renewedTarget.releaseLatch();
                        throw throwable;
                    }
                    renewedTarget.releaseLatch();
                    if (newLsn != null) {
                        ++this.nFullINFlushThisRun;
                        result.parent.updateEntry(result.index, newLsn);
                        this.addToDirtyMap(dirtyMap, result.parent);
                    }
                    Object var16_17 = null;
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    result.parent.releaseLatch();
                    throw throwable;
                }
                result.parent.releaseLatch();
                {
                }
            }
        }
    }

    private void addToDirtyMap(Map dirtyMap, IN in) {
        Integer inLevel = new Integer(in.getLevel());
        HashSet<IN> inSet = (HashSet<IN>)dirtyMap.get(inLevel);
        if (inSet == null) {
            inSet = new HashSet<IN>();
            dirtyMap.put(inLevel, inSet);
        }
        inSet.add(in);
    }

    private void resetPerRunCounters() {
        this.nFullINFlushThisRun = 0;
        this.nDeltaINFlushThisRun = 0;
    }

    private void accumulatePerRunCounters() {
        this.nFullINFlush += this.nFullINFlushThisRun;
        this.nDeltaINFlush += this.nDeltaINFlushThisRun;
    }

    private class RootFlusher
    implements WithRootLatched {
        private DatabaseImpl db;
        private boolean flushed;
        private boolean stillRoot;
        private LogManager logManager;
        private IN target;

        RootFlusher(DatabaseImpl db, LogManager logManager, IN target) {
            this.db = db;
            this.flushed = false;
            this.logManager = logManager;
            this.target = target;
            this.stillRoot = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            rootIN.latch();
            try {
                if (rootIN.getNodeId() == this.target.getNodeId()) {
                    this.stillRoot = true;
                    if (rootIN.getDirty()) {
                        DbLsn newLsn = rootIN.log(this.logManager);
                        root.setLsn(newLsn);
                        this.flushed = true;
                    }
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                rootIN.releaseLatch();
                throw throwable;
            }
            rootIN.releaseLatch();
            return null;
        }

        boolean getFlushed() {
            return this.flushed;
        }

        boolean stillRoot() {
            return this.stillRoot;
        }
    }
}

