/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class StatsFileReader
extends DumpFileReader {
    private Map entryInfoMap = new TreeMap(new LogEntryTypeComparator());
    private long totalLogBytes = 0L;
    private long totalCount = 0L;

    public StatsFileReader(EnvironmentImpl env, int readBufferSize, DbLsn startLsn, DbLsn finishLsn, String entryTypes, String txnIds, boolean verbose) throws IOException, DatabaseException {
        super(env, readBufferSize, startLsn, finishLsn, entryTypes, txnIds, verbose);
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        entryBuffer.position(entryBuffer.position() + this.currentEntrySize);
        EntryInfo info = (EntryInfo)this.entryInfoMap.get(lastEntryType);
        if (info == null) {
            info = new EntryInfo();
            this.entryInfoMap.put(lastEntryType, info);
        }
        ++info.count;
        ++this.totalCount;
        if (LogEntryType.isProvisional(this.currentEntryTypeVersion)) {
            ++info.provisionalCount;
        }
        int size = this.currentEntrySize + 14;
        info.totalBytes += (long)size;
        this.totalLogBytes += (long)size;
        if (info.minBytes == 0 || info.minBytes > size) {
            info.minBytes = size;
        }
        if (info.maxBytes < size) {
            info.maxBytes = size;
        }
        return true;
    }

    public void summarize() {
        System.out.println("Log statistics:");
        Iterator iter = this.entryInfoMap.entrySet().iterator();
        NumberFormat form = NumberFormat.getIntegerInstance();
        NumberFormat percentForm = NumberFormat.getInstance();
        percentForm.setMaximumFractionDigits(1);
        System.out.println(this.pad("type") + this.pad("total") + this.pad("provisional") + this.pad("total") + this.pad("min") + this.pad("max") + this.pad("avg") + this.pad("entries"));
        System.out.println(this.pad("") + this.pad("count") + this.pad("count") + this.pad("bytes") + this.pad("bytes") + this.pad("bytes") + this.pad("bytes") + this.pad("as % of log"));
        while (iter.hasNext()) {
            Map.Entry m = iter.next();
            EntryInfo info = (EntryInfo)m.getValue();
            StringBuffer sb = new StringBuffer();
            LogEntryType entryType = (LogEntryType)m.getKey();
            sb.append(this.pad(entryType.toString()));
            sb.append(this.pad(form.format(info.count)));
            sb.append(this.pad(form.format(info.provisionalCount)));
            sb.append(this.pad(form.format(info.totalBytes)));
            sb.append(this.pad(form.format(info.minBytes)));
            sb.append(this.pad(form.format(info.maxBytes)));
            sb.append(this.pad(form.format(info.totalBytes / (long)info.count)));
            double entryPercent = (double)(info.totalBytes * 100L) / (double)this.totalLogBytes;
            sb.append(this.pad(percentForm.format(entryPercent)));
            System.out.println(sb.toString());
            if (entryType != LogEntryType.LOG_LN_TRANSACTIONAL) continue;
            sb = new StringBuffer();
            sb.append(this.pad("key/data"));
            sb.append(this.pad(""));
            sb.append(this.pad(""));
            int overhead = 59;
            long realTotalBytes = info.totalBytes - (long)(info.count * overhead);
            sb.append(this.pad(form.format(realTotalBytes)));
            sb.append(this.pad(""));
            sb.append(this.pad(""));
            sb.append(this.pad(""));
            String realSize = "(" + percentForm.format((double)(realTotalBytes * 100L) / (double)this.totalLogBytes) + ")";
            sb.append(this.pad(realSize));
            System.out.println(sb.toString());
        }
        System.out.println("\nTotal bytes in portion of log read: " + form.format(this.totalLogBytes));
        System.out.println("Total number of entries: " + form.format(this.totalCount));
    }

    private String pad(String result) {
        int spaces = 14 - result.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < spaces) {
            sb.append(" ");
            ++i;
        }
        sb.append(result);
        return sb.toString();
    }

    static class LogEntryTypeComparator
    implements Comparator {
        LogEntryTypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o1 == null) {
                return 1;
            }
            if (o1 instanceof LogEntryType && o2 instanceof LogEntryType) {
                Byte t1 = new Byte(((LogEntryType)o1).getTypeNum());
                Byte t2 = new Byte(((LogEntryType)o2).getTypeNum());
                return t1.compareTo(t2);
            }
            throw new IllegalArgumentException("non LogEntryType passed to LogEntryType.compare");
        }
    }

    static class EntryInfo {
        public int count = 0;
        public int provisionalCount = 0;
        public long totalBytes = 0L;
        public int minBytes = 0;
        public int maxBytes = 0;

        EntryInfo() {
        }
    }
}

