/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemLogEntry;
import java.util.Hashtable;
import java.util.Map;

public class LogEntryType {
    private static Map LOG_TYPES = new Hashtable();
    public static final LogEntryType LOG_LN_TRANSACTIONAL = new LogEntryType(1, 0, "LN_TX", new LNLogEntry(class$com$sleepycat$je$tree$LN == null ? (class$com$sleepycat$je$tree$LN = LogEntryType.class$("com.sleepycat.je.tree.LN")) : class$com$sleepycat$je$tree$LN, true));
    public static final LogEntryType LOG_LN = new LogEntryType(2, 0, "LN", new LNLogEntry(class$com$sleepycat$je$tree$LN == null ? (class$com$sleepycat$je$tree$LN = LogEntryType.class$("com.sleepycat.je.tree.LN")) : class$com$sleepycat$je$tree$LN, false));
    public static final LogEntryType LOG_MAPLN_TRANSACTIONAL = new LogEntryType(3, 0, "MapLN_TX", new LNLogEntry(class$com$sleepycat$je$tree$MapLN == null ? (class$com$sleepycat$je$tree$MapLN = LogEntryType.class$("com.sleepycat.je.tree.MapLN")) : class$com$sleepycat$je$tree$MapLN, true));
    public static final LogEntryType LOG_MAPLN = new LogEntryType(4, 0, "MapLN", new LNLogEntry(class$com$sleepycat$je$tree$MapLN == null ? (class$com$sleepycat$je$tree$MapLN = LogEntryType.class$("com.sleepycat.je.tree.MapLN")) : class$com$sleepycat$je$tree$MapLN, false));
    public static final LogEntryType LOG_NAMELN_TRANSACTIONAL = new LogEntryType(5, 0, "NameLN_TX", new LNLogEntry(class$com$sleepycat$je$tree$NameLN == null ? (class$com$sleepycat$je$tree$NameLN = LogEntryType.class$("com.sleepycat.je.tree.NameLN")) : class$com$sleepycat$je$tree$NameLN, true));
    public static final LogEntryType LOG_NAMELN = new LogEntryType(6, 0, "NameLN", new LNLogEntry(class$com$sleepycat$je$tree$NameLN == null ? (class$com$sleepycat$je$tree$NameLN = LogEntryType.class$("com.sleepycat.je.tree.NameLN")) : class$com$sleepycat$je$tree$NameLN, false));
    public static final LogEntryType LOG_DEL_DUPLN_TRANSACTIONAL = new LogEntryType(7, 0, "DelDupLN_TX", new DeletedDupLNLogEntry(true));
    public static final LogEntryType LOG_DEL_DUPLN = new LogEntryType(8, 0, "DelDupLN", new DeletedDupLNLogEntry(false));
    public static final LogEntryType LOG_DUPCOUNTLN_TRANSACTIONAL = new LogEntryType(9, 0, "DupCountLN_TX", new LNLogEntry(class$com$sleepycat$je$tree$DupCountLN == null ? (class$com$sleepycat$je$tree$DupCountLN = LogEntryType.class$("com.sleepycat.je.tree.DupCountLN")) : class$com$sleepycat$je$tree$DupCountLN, true));
    public static final LogEntryType LOG_DUPCOUNTLN = new LogEntryType(10, 0, "DupCountLN", new LNLogEntry(class$com$sleepycat$je$tree$DupCountLN == null ? (class$com$sleepycat$je$tree$DupCountLN = LogEntryType.class$("com.sleepycat.je.tree.DupCountLN")) : class$com$sleepycat$je$tree$DupCountLN, false));
    public static final LogEntryType LOG_FILESUMMARYLN = new LogEntryType(11, 0, "FileSummaryLN", new LNLogEntry(class$com$sleepycat$je$tree$FileSummaryLN == null ? (class$com$sleepycat$je$tree$FileSummaryLN = LogEntryType.class$("com.sleepycat.je.tree.FileSummaryLN")) : class$com$sleepycat$je$tree$FileSummaryLN, false));
    public static final LogEntryType LOG_IN = new LogEntryType(12, 0, "IN", new INLogEntry(class$com$sleepycat$je$tree$IN == null ? (class$com$sleepycat$je$tree$IN = LogEntryType.class$("com.sleepycat.je.tree.IN")) : class$com$sleepycat$je$tree$IN));
    public static final LogEntryType LOG_BIN = new LogEntryType(13, 0, "BIN", new INLogEntry(class$com$sleepycat$je$tree$BIN == null ? (class$com$sleepycat$je$tree$BIN = LogEntryType.class$("com.sleepycat.je.tree.BIN")) : class$com$sleepycat$je$tree$BIN));
    public static final LogEntryType LOG_DIN = new LogEntryType(14, 0, "DIN", new INLogEntry(class$com$sleepycat$je$tree$DIN == null ? (class$com$sleepycat$je$tree$DIN = LogEntryType.class$("com.sleepycat.je.tree.DIN")) : class$com$sleepycat$je$tree$DIN));
    public static final LogEntryType LOG_DBIN = new LogEntryType(15, 0, "DBIN", new INLogEntry(class$com$sleepycat$je$tree$DBIN == null ? (class$com$sleepycat$je$tree$DBIN = LogEntryType.class$("com.sleepycat.je.tree.DBIN")) : class$com$sleepycat$je$tree$DBIN));
    private static final int MAX_NODE_TYPE_NUM = 15;
    public static final LogEntryType LOG_ROOT = new LogEntryType(16, 0, "Root", new SingleItemLogEntry(class$com$sleepycat$je$dbi$DbTree == null ? (class$com$sleepycat$je$dbi$DbTree = LogEntryType.class$("com.sleepycat.je.dbi.DbTree")) : class$com$sleepycat$je$dbi$DbTree));
    public static final LogEntryType LOG_TXN_COMMIT = new LogEntryType(17, 0, "Commit", new SingleItemLogEntry(class$com$sleepycat$je$txn$TxnCommit == null ? (class$com$sleepycat$je$txn$TxnCommit = LogEntryType.class$("com.sleepycat.je.txn.TxnCommit")) : class$com$sleepycat$je$txn$TxnCommit));
    public static final LogEntryType LOG_TXN_ABORT = new LogEntryType(18, 0, "Abort", new SingleItemLogEntry(class$com$sleepycat$je$txn$TxnAbort == null ? (class$com$sleepycat$je$txn$TxnAbort = LogEntryType.class$("com.sleepycat.je.txn.TxnAbort")) : class$com$sleepycat$je$txn$TxnAbort));
    public static final LogEntryType LOG_CKPT_START = new LogEntryType(19, 0, "CkptStart", new SingleItemLogEntry(class$com$sleepycat$je$recovery$CheckpointStart == null ? (class$com$sleepycat$je$recovery$CheckpointStart = LogEntryType.class$("com.sleepycat.je.recovery.CheckpointStart")) : class$com$sleepycat$je$recovery$CheckpointStart));
    public static final LogEntryType LOG_CKPT_END = new LogEntryType(20, 0, "CkptEnd", new SingleItemLogEntry(class$com$sleepycat$je$recovery$CheckpointEnd == null ? (class$com$sleepycat$je$recovery$CheckpointEnd = LogEntryType.class$("com.sleepycat.je.recovery.CheckpointEnd")) : class$com$sleepycat$je$recovery$CheckpointEnd));
    public static final LogEntryType LOG_IN_DELETE_INFO = new LogEntryType(21, 0, "INDelete", new SingleItemLogEntry(class$com$sleepycat$je$tree$INDeleteInfo == null ? (class$com$sleepycat$je$tree$INDeleteInfo = LogEntryType.class$("com.sleepycat.je.tree.INDeleteInfo")) : class$com$sleepycat$je$tree$INDeleteInfo));
    public static final LogEntryType LOG_BIN_DELTA = new LogEntryType(22, 0, "BINDelta", new BINDeltaLogEntry(class$com$sleepycat$je$tree$BINDelta == null ? (class$com$sleepycat$je$tree$BINDelta = LogEntryType.class$("com.sleepycat.je.tree.BINDelta")) : class$com$sleepycat$je$tree$BINDelta));
    public static final LogEntryType LOG_DUP_BIN_DELTA = new LogEntryType(23, 0, "DupBINDelta", new BINDeltaLogEntry(class$com$sleepycat$je$tree$BINDelta == null ? (class$com$sleepycat$je$tree$BINDelta = LogEntryType.class$("com.sleepycat.je.tree.BINDelta")) : class$com$sleepycat$je$tree$BINDelta));
    public static final LogEntryType LOG_TRACE = new LogEntryType(24, 0, "Trace", new SingleItemLogEntry(class$com$sleepycat$je$utilint$Tracer == null ? (class$com$sleepycat$je$utilint$Tracer = LogEntryType.class$("com.sleepycat.je.utilint.Tracer")) : class$com$sleepycat$je$utilint$Tracer));
    public static final LogEntryType LOG_FILE_HEADER = new LogEntryType(25, 0, "FileHeader", new SingleItemLogEntry(class$com$sleepycat$je$log$FileHeader == null ? (class$com$sleepycat$je$log$FileHeader = LogEntryType.class$("com.sleepycat.je.log.FileHeader")) : class$com$sleepycat$je$log$FileHeader));
    private static final int MAX_TYPE_NUM = 25;
    private static final byte PROVISIONAL_MASK = -128;
    private static final byte IGNORE_PROVISIONAL = 127;
    private byte typeNum;
    private byte version;
    private String displayName;
    private LogEntry logEntry;
    static /* synthetic */ Class class$com$sleepycat$je$tree$LN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$MapLN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$NameLN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$DupCountLN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$FileSummaryLN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$IN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$BIN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$DIN;
    static /* synthetic */ Class class$com$sleepycat$je$tree$DBIN;
    static /* synthetic */ Class class$com$sleepycat$je$dbi$DbTree;
    static /* synthetic */ Class class$com$sleepycat$je$txn$TxnCommit;
    static /* synthetic */ Class class$com$sleepycat$je$txn$TxnAbort;
    static /* synthetic */ Class class$com$sleepycat$je$recovery$CheckpointStart;
    static /* synthetic */ Class class$com$sleepycat$je$recovery$CheckpointEnd;
    static /* synthetic */ Class class$com$sleepycat$je$tree$INDeleteInfo;
    static /* synthetic */ Class class$com$sleepycat$je$tree$BINDelta;
    static /* synthetic */ Class class$com$sleepycat$je$utilint$Tracer;
    static /* synthetic */ Class class$com$sleepycat$je$log$FileHeader;

    public static boolean isNodeType(byte typeNum, byte version) {
        return typeNum <= 15;
    }

    LogEntryType(byte typeNum, byte version) {
        this.typeNum = typeNum;
        this.version = version;
    }

    private LogEntryType(byte typeNum, byte version, String displayName, LogEntry logEntry) {
        this.typeNum = typeNum;
        this.version = version;
        this.logEntry = logEntry;
        this.displayName = displayName;
        LOG_TYPES.put(this, this);
    }

    public boolean isNodeType() {
        return this.typeNum <= 15;
    }

    static LogEntryType findType(byte typeNum, byte version) {
        return (LogEntryType)LOG_TYPES.get(new LogEntryType(typeNum, version));
    }

    LogEntry getSharedLogEntry() {
        return this.logEntry;
    }

    LogEntry getNewLogEntry() throws DatabaseException {
        try {
            return (LogEntry)this.logEntry.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException(e);
        }
    }

    static byte setProvisional(byte version) {
        return (byte)(version | 0xFFFFFF80);
    }

    static boolean isProvisional(byte version) {
        return (version & 0xFFFFFF80) != 0;
    }

    byte getTypeNum() {
        return this.typeNum;
    }

    byte getVersion() {
        return this.version;
    }

    static boolean isValidType(byte typeNum) {
        return typeNum <= 25;
    }

    public String toString() {
        return this.displayName + "/" + this.version;
    }

    boolean equalsType(byte typeNum, byte version) {
        return this.typeNum == typeNum && (this.version & 0x7F) == (version & 0x7F);
    }

    boolean equalsType(byte typeNum) {
        return this.typeNum == typeNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogEntryType)) {
            return false;
        }
        return this.typeNum == ((LogEntryType)obj).typeNum && (this.version & 0x7F) == (((LogEntryType)obj).version & 0x7F);
    }

    public int hashCode() {
        return this.typeNum + (this.version & 0x7F);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

