/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

class LogBuffer
implements LogSource {
    private static final String DEBUG_NAME;
    private ByteBuffer buffer;
    private DbLsn firstLsn;
    private DbLsn lastLsn;
    private Latch readLatch;
    static /* synthetic */ Class class$com$sleepycat$je$log$LogBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;

    LogBuffer(int capacity, EnvironmentImpl env) throws DatabaseException {
        this.buffer = ByteBuffer.allocateDirect(capacity);
        this.readLatch = new Latch(DEBUG_NAME, env);
        this.reinit();
    }

    void reinit() throws DatabaseException {
        this.readLatch.acquire();
        this.buffer.clear();
        this.firstLsn = null;
        this.lastLsn = null;
        this.readLatch.release();
    }

    DbLsn getFirstLsn() {
        return this.firstLsn;
    }

    void registerLsn(DbLsn lsn) throws DatabaseException {
        this.readLatch.acquire();
        if (this.lastLsn != null && !$assertionsDisabled && lsn.compareTo(this.lastLsn) <= 0) {
            throw new AssertionError();
        }
        this.lastLsn = lsn;
        if (this.firstLsn == null) {
            this.firstLsn = lsn;
        }
        this.readLatch.release();
    }

    boolean hasRoom(int numBytes) {
        return numBytes <= this.buffer.capacity() - this.buffer.position();
    }

    ByteBuffer getDataBuffer() {
        return this.buffer;
    }

    int getCapacity() {
        return this.buffer.capacity();
    }

    boolean containsLsn(DbLsn lsn) throws DatabaseException {
        this.readLatch.acquire();
        boolean found = false;
        if (this.firstLsn != null && this.firstLsn.compareTo(lsn) <= 0 && this.lastLsn.compareTo(lsn) >= 0) {
            found = true;
        }
        if (found) {
            return true;
        }
        this.readLatch.release();
        return false;
    }

    public void release() throws DatabaseException {
        if (this.readLatch.isOwner()) {
            this.readLatch.release();
        }
    }

    public ByteBuffer getBytes(long fileOffset) {
        ByteBuffer copy = null;
        while (true) {
            try {
                copy = this.buffer.duplicate();
                copy.position((int)(fileOffset - this.firstLsn.getFileOffset()));
            }
            catch (IllegalArgumentException IAE) {
                continue;
            }
            break;
        }
        return copy;
    }

    public ByteBuffer getBytes(long fileOffset, int numBytes) {
        ByteBuffer copy = this.getBytes(fileOffset);
        if (!$assertionsDisabled && copy.remaining() < numBytes) {
            throw new AssertionError((Object)("copy.remaining=" + copy.remaining() + " numBytes=" + numBytes));
        }
        return copy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$log$LogBuffer == null ? (class$com$sleepycat$je$log$LogBuffer = LogBuffer.class$("com.sleepycat.je.log.LogBuffer")) : class$com$sleepycat$je$log$LogBuffer).desiredAssertionStatus();
        DEBUG_NAME = (class$com$sleepycat$je$log$LogBuffer == null ? (class$com$sleepycat$je$log$LogBuffer = LogBuffer.class$("com.sleepycat.je.log.LogBuffer")) : class$com$sleepycat$je$log$LogBuffer).getName();
    }
}

