/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LastFileReader
extends FileReader {
    private Set trackableEntries = new HashSet();
    private Map lastOffsetSeen = new HashMap();

    public LastFileReader(EnvironmentImpl env, int readBufferSize) throws IOException, DatabaseException {
        super(env, readBufferSize, true, null, new Long(0L), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initStartingPosition(DbLsn endOfFileLsn, Long ignoreSingleFileNum) throws IOException, DatabaseException {
        this.eof = false;
        Long lastNum = this.fileManager.getLastFileNum();
        FileHandle fileHandle = null;
        this.readBufferFileEnd = 0L;
        while (true) {
            Object var7_6;
            if (fileHandle != null || this.eof) {
                this.nextEntryOffset = 0L;
                return;
            }
            if (lastNum == null) {
                this.eof = true;
                continue;
            }
            try {
                block8: {
                    try {
                        this.readBufferFileNum = lastNum;
                        fileHandle = this.fileManager.getFileHandle(this.readBufferFileNum);
                        if (fileHandle.getFile().length() != (long)FileManager.firstLogEntryOffset()) break block8;
                        lastNum = this.fileManager.getFollowingFileNum(lastNum, false);
                        fileHandle.release();
                        fileHandle = null;
                    }
                    catch (DatabaseException e) {
                        lastNum = this.attemptToMoveBadFile(e);
                        fileHandle = null;
                        var7_6 = null;
                        if (fileHandle == null) continue;
                        fileHandle.release();
                        continue;
                    }
                }
                var7_6 = null;
                if (fileHandle == null) continue;
            }
            catch (Throwable throwable) {
                var7_6 = null;
                if (fileHandle != null) {
                    fileHandle.release();
                }
                throw throwable;
            }
            fileHandle.release();
        }
    }

    private Long attemptToMoveBadFile(DatabaseException origException) throws DatabaseException, IOException {
        String fileName = this.fileManager.getFullFileNames(this.readBufferFileNum)[0];
        File problemFile = new File(fileName);
        Long lastNum = null;
        if (problemFile.length() > (long)FileManager.firstLogEntryOffset()) {
            throw origException;
        }
        this.fileManager.clear();
        lastNum = this.fileManager.getFollowingFileNum(this.readBufferFileNum, false);
        this.fileManager.renameFile(this.readBufferFileNum, ".bad");
        return lastNum;
    }

    public void setEndOfFile() throws IOException, DatabaseException {
        this.fileManager.truncateLog(this.readBufferFileNum, this.nextEntryOffset);
    }

    public DbLsn getNextAvailableLsn() {
        return new DbLsn(this.readBufferFileNum, this.nextEntryOffset);
    }

    public long getPrevOffset() {
        return this.currentEntryOffset;
    }

    public void setTargetType(LogEntryType type) {
        this.trackableEntries.add(type);
    }

    public DbLsn getLastSeen(LogEntryType type) {
        Long typeNumber = (Long)this.lastOffsetSeen.get(type);
        if (typeNumber != null) {
            return new DbLsn(this.readBufferFileNum, typeNumber);
        }
        return null;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) {
        entryBuffer.position(entryBuffer.position() + this.currentEntrySize);
        LogEntryType logType = new LogEntryType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        if (this.trackableEntries.contains(logType)) {
            this.lastOffsetSeen.put(logType, new Long(this.currentEntryOffset));
        }
        return true;
    }
}

