/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;

class JEFileFilter
implements FilenameFilter {
    String[] suffix;

    JEFileFilter(String[] suffix) {
        this.suffix = suffix;
    }

    private boolean matches(String fileSuffix) {
        int i = 0;
        while (i < this.suffix.length) {
            if (fileSuffix.equalsIgnoreCase(this.suffix[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File dir, String name) {
        boolean ok;
        block6: {
            String fileVersion;
            ok = false;
            StringTokenizer tokenizer = new StringTokenizer(name, ".");
            int nTokens = tokenizer.countTokens();
            if (nTokens != 2 && nTokens != 3) break block6;
            boolean hasVersion = nTokens == 3;
            String fileNumber = tokenizer.nextToken();
            String fileSuffix = "." + tokenizer.nextToken();
            String string = fileVersion = hasVersion ? tokenizer.nextToken() : null;
            if (fileNumber.length() == 8 && this.matches(fileSuffix)) {
                try {
                    Integer.parseInt(fileNumber, 16);
                    ok = true;
                }
                catch (NumberFormatException e) {
                    ok = false;
                }
                if (hasVersion) {
                    try {
                        Integer.parseInt(fileVersion);
                        ok = true;
                    }
                    catch (NumberFormatException e) {
                        ok = false;
                    }
                }
            }
        }
        return ok;
    }
}

