/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogSource;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

class FileSource
implements LogSource {
    private RandomAccessFile file;
    private int readBufferSize;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$log$FileSource;

    FileSource(RandomAccessFile file, int readBufferSize) {
        this.file = file;
        this.readBufferSize = readBufferSize;
    }

    public void release() throws DatabaseException {
    }

    public ByteBuffer getBytes(long fileOffset) throws IOException {
        ByteBuffer destBuf = ByteBuffer.allocate(this.readBufferSize);
        this.file.getChannel().read(destBuf, fileOffset);
        if (EnvironmentImpl.getForcedYield()) {
            Thread.yield();
        }
        destBuf.flip();
        return destBuf;
    }

    public ByteBuffer getBytes(long fileOffset, int numBytes) throws IOException {
        ByteBuffer destBuf = ByteBuffer.allocate(numBytes);
        this.file.getChannel().read(destBuf, fileOffset);
        if (EnvironmentImpl.getForcedYield()) {
            Thread.yield();
        }
        destBuf.flip();
        if (!$assertionsDisabled && destBuf.remaining() < numBytes) {
            throw new AssertionError((Object)("remaining=" + destBuf.remaining() + " numBytes=" + numBytes));
        }
        return destBuf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$log$FileSource == null ? (class$com$sleepycat$je$log$FileSource = FileSource.class$("com.sleepycat.je.log.FileSource")) : class$com$sleepycat$je$log$FileSource).desiredAssertionStatus();
    }
}

