/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

class ChecksumValidator {
    private static final boolean DEBUG = false;
    private Checksum cksum = new Adler32();

    ChecksumValidator() {
    }

    void reset() {
        this.cksum.reset();
    }

    void update(EnvironmentImpl env, ByteBuffer buf, int length) throws DbChecksumException {
        if (buf == null) {
            throw new DbChecksumException(env, "null buffer given to checksum validation, probably result of 0's in log file");
        }
        int bufStart = buf.position();
        if (buf.hasArray()) {
            this.cksum.update(buf.array(), bufStart, length);
        } else {
            int i = bufStart;
            while (i < length + bufStart) {
                this.cksum.update(buf.get(i));
                ++i;
            }
        }
    }

    void validate(EnvironmentImpl env, long expectedChecksum, DbLsn lsn) throws DbChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            throw new DbChecksumException(env, "Location " + lsn.getNoFormatString() + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }

    void validate(EnvironmentImpl env, long expectedChecksum, long fileNum, long fileOffset) throws DbChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            DbLsn problemLsn = new DbLsn(fileNum, fileOffset);
            throw new DbChecksumException(env, "Location " + problemLsn.getNoFormatString() + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }
}

