/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SharedLatch {
    private static LatchTable latchTable;
    private String name = null;
    private List waiters = new ArrayList();
    private LatchStats stats = new LatchStats();
    private Object subject = null;
    private EnvironmentImpl env = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$latch$SharedLatch;

    public SharedLatch(Object subject, String name, EnvironmentImpl env) {
        this.subject = subject;
        this.name = name;
        this.env = env;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void acquireExclusive() throws DatabaseException {
        try {
            try {
                Owner owner;
                Thread thread = Thread.currentThread();
                int index = this.indexOf(thread);
                if (index < 0) {
                    owner = new Owner(thread, 1);
                    this.waiters.add(owner);
                } else {
                    owner = (Owner)this.waiters.get(index);
                    if (owner.type == 0) {
                        ++this.stats.nAcquiresUpgrade;
                        throw new LatchException(this.getNameString() + " upgrade not allowed");
                    }
                    if (!$assertionsDisabled && owner.type != 1) {
                        throw new AssertionError();
                    }
                }
                if (this.waiters.size() == 1) {
                    ++this.stats.nAcquiresNoWaiters;
                } else {
                    ++this.stats.nAcquiresWithContention;
                    while (this.waiters.get(0) != owner) {
                        this.wait();
                    }
                }
                ++owner.nAcquires;
                if (!$assertionsDisabled && !this.noteLatch()) {
                    throw new AssertionError();
                }
                Object var5_5 = null;
            }
            catch (InterruptedException e) {
                throw new RunRecoveryException(this.env, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!EnvironmentImpl.getForcedYield()) throw throwable;
            Thread.yield();
            throw throwable;
        }
        if (!EnvironmentImpl.getForcedYield()) return;
        Thread.yield();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void acquireShared() throws DatabaseException {
        try {
            try {
                Owner owner;
                Thread thread = Thread.currentThread();
                int index = this.indexOf(thread);
                if (index < 0) {
                    owner = new Owner(thread, 0);
                    this.waiters.add(owner);
                } else {
                    owner = (Owner)this.waiters.get(index);
                }
                while (true) {
                    if (this.indexOf(thread) <= this.firstWriter()) {
                        ++owner.nAcquires;
                        ++this.stats.nAcquireSharedSuccessful;
                        if (!$assertionsDisabled && !this.noteLatch()) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    this.wait();
                }
                Object var5_5 = null;
            }
            catch (InterruptedException e) {
                throw new RunRecoveryException(this.env, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!EnvironmentImpl.getForcedYield()) throw throwable;
            Thread.yield();
            throw throwable;
        }
        if (!EnvironmentImpl.getForcedYield()) return;
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws LatchNotHeldException {
        try {
            Thread thread = Thread.currentThread();
            int index = this.indexOf(thread);
            if (index < 0 || index > this.firstWriter()) {
                throw new LatchNotHeldException(this.getNameString() + " not held");
            }
            Owner owner = (Owner)this.waiters.get(index);
            --owner.nAcquires;
            if (owner.nAcquires == 0) {
                this.waiters.remove(index);
                this.notifyAll();
            }
            ++this.stats.nReleases;
            if (!$assertionsDisabled && !this.unNoteLatch()) {
                throw new AssertionError();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
            throw throwable;
        }
        if (EnvironmentImpl.getForcedYield()) {
            Thread.yield();
        }
    }

    private int indexOf(Thread thread) {
        Iterator i = this.waiters.iterator();
        int index = 0;
        while (i.hasNext()) {
            Owner owner = (Owner)i.next();
            if (owner.thread == thread) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int firstWriter() {
        Iterator i = this.waiters.iterator();
        int index = 0;
        while (i.hasNext()) {
            Owner owner = (Owner)i.next();
            if (owner.type == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isOwner() {
        return Thread.currentThread() == this.owner();
    }

    public synchronized Thread owner() {
        return this.waiters.size() > 0 ? ((Owner)this.waiters.get((int)0)).thread : null;
    }

    synchronized int nWaiters() {
        int n = this.waiters.size();
        return n > 0 ? n - 1 : 0;
    }

    LatchStats getLatchStats() {
        return this.stats;
    }

    public synchronized String toString() {
        return latchTable.toString(this.name, this.owner(), this.waiters, 1);
    }

    private String getNameString() {
        return latchTable.getNameString(this.name);
    }

    private boolean noteLatch() throws LatchException {
        return latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() throws LatchNotHeldException {
        return latchTable.unNoteLatch(this, this.name);
    }

    public static int countLatchesHeld() {
        return latchTable.countLatchesHeld();
    }

    public static void dumpLatchesHeld() {
        System.out.println(SharedLatch.latchesHeldToString());
    }

    public static String latchesHeldToString() {
        return latchTable.latchesHeldToString();
    }

    public static void clearNotes() {
        latchTable.clearNotes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$latch$SharedLatch == null ? (class$com$sleepycat$je$latch$SharedLatch = SharedLatch.class$("com.sleepycat.je.latch.SharedLatch")) : class$com$sleepycat$je$latch$SharedLatch).desiredAssertionStatus();
        latchTable = new LatchTable("SharedLatch");
    }

    private static class Owner {
        static final int SHARED = 0;
        static final int EXCLUSIVE = 1;
        Thread thread;
        int type;
        int nAcquires;

        Owner(Thread thread, int type) {
            this.thread = thread;
            this.type = type;
        }
    }
}

