/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchTable;
import java.util.ArrayList;
import java.util.List;

public class Latch {
    private static final String DEFAULT_LATCH_NAME = "Latch";
    private static LatchTable latchTable;
    private String name = null;
    private List waiters = null;
    private LatchStats stats = new LatchStats();
    private EnvironmentImpl env = null;
    private Thread owner = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$latch$Latch;

    public Latch(String name, EnvironmentImpl env) {
        this.name = name;
        this.env = env;
    }

    public Latch(EnvironmentImpl env) {
        this.env = env;
        this.name = DEFAULT_LATCH_NAME;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void acquire() throws DatabaseException {
        try {
            try {
                Thread thread = Thread.currentThread();
                if (thread == this.owner) {
                    ++this.stats.nAcquiresSelfOwned;
                    throw new LatchException(this.getNameString() + " already held");
                }
                if (this.owner == null) {
                    ++this.stats.nAcquiresNoWaiters;
                    this.owner = thread;
                } else {
                    if (this.waiters == null) {
                        this.waiters = new ArrayList();
                    }
                    this.waiters.add(thread);
                    ++this.stats.nAcquiresWithContention;
                    while (thread != this.owner) {
                        this.wait();
                    }
                }
                if (!$assertionsDisabled && !this.noteLatch()) {
                    throw new AssertionError();
                }
                Object var3_3 = null;
            }
            catch (InterruptedException e) {
                throw new RunRecoveryException(this.env, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!EnvironmentImpl.getForcedYield()) throw throwable;
            Thread.yield();
            throw throwable;
        }
        if (!EnvironmentImpl.getForcedYield()) return;
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquireNoWait() throws LatchException {
        block7: {
            boolean bl;
            try {
                Thread thread = Thread.currentThread();
                if (thread == this.owner) {
                    ++this.stats.nAcquiresSelfOwned;
                    throw new LatchException(this.getNameString() + " already held");
                }
                if (this.owner != null) break block7;
                this.owner = thread;
                ++this.stats.nAcquireNoWaitSuccessful;
                if (!$assertionsDisabled && !this.noteLatch()) {
                    throw new AssertionError();
                }
                bl = true;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_6 = null;
                    if (!EnvironmentImpl.getForcedYield()) break block8;
                    Thread.yield();
                }
                throw throwable;
            }
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
            return bl;
        }
        ++this.stats.nAcquireNoWaitUnsuccessful;
        boolean bl = false;
        Object var4_5 = null;
        if (EnvironmentImpl.getForcedYield()) {
            Thread.yield();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws LatchNotHeldException {
        try {
            Thread thread = Thread.currentThread();
            if (thread != this.owner) {
                throw new LatchNotHeldException(this.getNameString() + " not held");
            }
            if (this.waiters != null && this.waiters.size() > 0) {
                this.owner = (Thread)this.waiters.remove(0);
                this.notifyAll();
            } else {
                this.owner = null;
            }
            ++this.stats.nReleases;
            if (!$assertionsDisabled && !this.unNoteLatch()) {
                throw new AssertionError();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (EnvironmentImpl.getForcedYield()) {
                Thread.yield();
            }
            throw throwable;
        }
        if (EnvironmentImpl.getForcedYield()) {
            Thread.yield();
        }
    }

    public boolean isOwner() {
        return Thread.currentThread() == this.owner;
    }

    public Thread owner() {
        return this.owner;
    }

    synchronized int nWaiters() {
        return this.waiters != null ? this.waiters.size() : 0;
    }

    public LatchStats getLatchStats() {
        LatchStats s = null;
        try {
            s = (LatchStats)this.stats.clone();
        }
        catch (CloneNotSupportedException e) {}
        return s;
    }

    public synchronized String toString() {
        return latchTable.toString(this.name, this.owner, this.waiters, 0);
    }

    private String getNameString() {
        return latchTable.getNameString(this.name);
    }

    private boolean noteLatch() throws LatchException {
        return latchTable.noteLatch(this);
    }

    private boolean unNoteLatch() throws LatchNotHeldException {
        return latchTable.unNoteLatch(this, this.name);
    }

    public static int countLatchesHeld() {
        return latchTable.countLatchesHeld();
    }

    public static void dumpLatchesHeld() {
        System.out.println(Latch.latchesHeldToString());
    }

    public static String latchesHeldToString() {
        return latchTable.latchesHeldToString();
    }

    public static void clearNotes() {
        latchTable.clearNotes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$latch$Latch == null ? (class$com$sleepycat$je$latch$Latch = Latch.class$("com.sleepycat.je.latch.Latch")) : class$com$sleepycat$je$latch$Latch).desiredAssertionStatus();
        latchTable = new LatchTable(DEFAULT_LATCH_NAME);
    }
}

