/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.incomp;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class INCompressor
extends DaemonThread {
    private static final String TRACE_COMPRESS = "INCompress:";
    private EnvironmentImpl env;
    private long lockTimeout;
    private int splitBins = 0;
    private int dbClosedBins = 0;
    private int cursorsBins = 0;
    private int nonEmptyBins = 0;
    private int processedBins = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sleepycat$je$incomp$INCompressor;

    public INCompressor(EnvironmentImpl env, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.setName("INCompressor Thread");
        this.lockTimeout = PropUtil.microsToMillis(env.getConfigManager().getLong(EnvironmentParams.COMPRESSOR_LOCK_TIMEOUT));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<INCompressor name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void clearEnv() {
        this.env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyCursors() throws DatabaseException {
        HashSet workQueueSnapshot;
        block6: {
            if (this.env.isClosed()) {
                return;
            }
            workQueueSnapshot = null;
            try {
                this.workQueueLatch.acquire();
                workQueueSnapshot = new HashSet(this.workQueue);
                Object var3_2 = null;
                if (!this.workQueueLatch.isOwner()) break block6;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.workQueueLatch.isOwner()) {
                    this.workQueueLatch.release();
                }
                throw throwable;
            }
            this.workQueueLatch.release();
        }
        Iterator it = workQueueSnapshot.iterator();
        while (it.hasNext()) {
            BINReference binRef = (BINReference)it.next();
            DatabaseImpl db = this.env.getDbMapTree().getDb(binRef.getDatabaseId(), this.lockTimeout);
            BIN bin = this.searchForBIN(db, binRef);
            if (bin == null) continue;
            bin.verifyCursors();
            bin.getLatch().release();
        }
        return;
    }

    public void addToQueue(Object o) throws DatabaseException {
        super.addToQueue(((BIN)o).createReference());
    }

    public void addMultipleBinRefsToQueue(Set binRefs) throws DatabaseException {
        this.workQueueLatch.acquire();
        super.addToQueueAlreadyLatched(binRefs);
        this.workQueueLatch.release();
        this.wakeup();
    }

    public void loadStats(StatsConfig config, EnvironmentStatsInternal stat) throws DatabaseException {
        stat.setSplitBins(this.splitBins);
        stat.setDbClosedBins(this.dbClosedBins);
        stat.setCursorsBins(this.cursorsBins);
        stat.setNonEmptyBins(this.nonEmptyBins);
        stat.setProcessedBins(this.processedBins);
        stat.setInCompQueueSize(this.getQueueSize());
        if (config.getClear()) {
            this.splitBins = 0;
            this.dbClosedBins = 0;
            this.cursorsBins = 0;
            this.nonEmptyBins = 0;
            this.processedBins = 0;
        }
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.COMPRESSOR_RETRY);
    }

    public synchronized void onWakeup() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        this.doCompress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void doCompress() throws DatabaseException {
        if (!this.isRunnable()) {
            return;
        }
        Set workQueueSnapshot = null;
        try {
            this.workQueueLatch.acquire();
            workQueueSnapshot = this.workQueue;
            this.workQueue = new HashSet();
            this.workQueue.clear();
            Object var3_2 = null;
            if (this.workQueueLatch.isOwner()) {
                this.workQueueLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.workQueueLatch.isOwner()) throw throwable;
            this.workQueueLatch.release();
            throw throwable;
        }
        int splitBinsThisRun = 0;
        int dbClosedBinsThisRun = 0;
        int cursorsBinsThisRun = 0;
        int nonEmptyBinsThisRun = 0;
        int processedBinsThisRun = 0;
        ArrayList<Long> cursorsBinList = new ArrayList<Long>();
        Tracer.trace(Level.FINE, this.env, "InCompress.doCompress called, queue size: " + workQueueSnapshot.size());
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        INList inList = this.env.getInMemoryINs();
        try {
            Iterator it = workQueueSnapshot.iterator();
            while (it.hasNext()) {
                Object var20_27;
                BINReference binRef = (BINReference)it.next();
                if (this.env.isClosed()) {
                    return;
                }
                DbTree dbTree = this.env.getDbMapTree();
                DatabaseImpl db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout);
                if (db == null) {
                    ++dbClosedBinsThisRun;
                    continue;
                }
                try {
                    Object var18_26;
                    Key idKey;
                    BIN bin;
                    boolean empty;
                    block34: {
                        block35: {
                            block32: {
                                block33: {
                                    inList.latchMajor();
                                    Tracer.trace(Level.FINEST, this.env, "Compressing " + binRef);
                                    empty = false;
                                    bin = null;
                                    idKey = null;
                                    try {
                                        bin = this.searchForBIN(db, binRef);
                                        if (bin != null && bin.getNodeId() == binRef.getNodeId()) break block32;
                                        ++splitBinsThisRun;
                                        var18_26 = null;
                                        if (bin == null) break block33;
                                    }
                                    catch (Throwable throwable) {
                                        var18_26 = null;
                                        if (bin == null) throw throwable;
                                        bin.releaseLatch();
                                        throw throwable;
                                    }
                                    bin.releaseLatch();
                                }
                                var20_27 = null;
                                inList.releaseMajorLatchIfHeld();
                                continue;
                            }
                            idKey = bin.getIdentifierKey();
                            int nCursors = bin.nCursors();
                            if (nCursors <= 0) break block34;
                            this.addToQueue(bin);
                            ++cursorsBinsThisRun;
                            cursorsBinList.add(new Long(bin.getNodeId()));
                            var18_26 = null;
                            if (bin == null) break block35;
                            bin.releaseLatch();
                        }
                        var20_27 = null;
                        inList.releaseMajorLatchIfHeld();
                        continue;
                    }
                    empty = bin.compress();
                    var18_26 = null;
                    if (bin != null) {
                        bin.releaseLatch();
                    }
                    if (empty) {
                        block36: {
                            try {
                                Tree tree = db.getTree();
                                if (bin.containsDuplicates()) {
                                    DBIN dbin = (DBIN)bin;
                                    if (!tree.deleteDup(idKey, dbin.getDupKey())) {
                                        this.addToQueue(bin);
                                        ++cursorsBinsThisRun;
                                        break block36;
                                    } else {
                                        ++processedBinsThisRun;
                                    }
                                    break block36;
                                }
                                boolean deletedRoot = tree.delete(idKey);
                                if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                                    throw new AssertionError();
                                }
                                if (deletedRoot) {
                                    inList.releaseMajorLatchIfHeld();
                                    dbTree.modifyDbRoot(db);
                                    Tracer.traceRootDeletion(Level.FINE, db);
                                    inList.latchMajor();
                                }
                                ++processedBinsThisRun;
                            }
                            catch (NodeNotEmptyException NNNE) {
                                ++nonEmptyBinsThisRun;
                            }
                        }
                        if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                            throw new AssertionError();
                        }
                    } else {
                        ++nonEmptyBinsThisRun;
                    }
                    var20_27 = null;
                    inList.releaseMajorLatchIfHeld();
                }
                catch (Throwable throwable) {
                    var20_27 = null;
                    inList.releaseMajorLatchIfHeld();
                    throw throwable;
                }
            }
            Tracer.trace(Level.FINE, this.env, "splitBins = " + splitBinsThisRun + " dbClosedBins = " + dbClosedBinsThisRun + " cursorsBins = " + cursorsBinsThisRun + " nonEmptyBins = " + nonEmptyBinsThisRun + " processedBins = " + processedBinsThisRun);
            return;
        }
        catch (DatabaseException DBE) {
            System.err.println("INCompressor caught: " + DBE);
            DBE.printStackTrace();
            return;
        }
        finally {
            if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            this.accumulateStats(splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
        }
    }

    private boolean isRunnable() throws DatabaseException {
        return true;
    }

    public BIN searchForBIN(DatabaseImpl db, BINReference binRef) throws DatabaseException {
        Tree tree = db.getTree();
        IN in = tree.search(binRef.getKey(), Tree.SearchType.NORMAL, -1L, false);
        if (in == null) {
            return null;
        }
        if (binRef.getData() == null) {
            return (BIN)in;
        }
        IN duplicateRoot = null;
        IN duplicateBin = null;
        BIN bin = (BIN)in;
        try {
            int index = bin.findEntry(binRef.getKey(), false, true);
            if (index >= 0) {
                ChildReference ref = bin.getEntry(index);
                if (ref.isKnownDeleted()) {
                    bin.releaseLatch();
                    return null;
                }
                Node node = ref.fetchTarget(db, bin);
                if (node.containsDuplicates()) {
                    bin.releaseLatch();
                    duplicateRoot = (DIN)node;
                    duplicateRoot.latch();
                    duplicateBin = (DBIN)tree.searchSubTree(duplicateRoot, binRef.getData(), Tree.SearchType.NORMAL, -1L, false);
                    return duplicateBin;
                }
                return bin;
            }
            bin.releaseLatch();
            return null;
        }
        catch (DatabaseException DBE) {
            if (bin != null && bin.getLatch().isOwner()) {
                bin.releaseLatch();
            }
            if (duplicateRoot != null && duplicateRoot.getLatch().isOwner()) {
                duplicateRoot.releaseLatch();
            }
            if (duplicateBin != null && duplicateBin.getLatch().isOwner()) {
                duplicateBin.releaseLatch();
            }
            throw DBE;
        }
    }

    private void accumulateStats(int splitBinsThisRun, int dbClosedBinsThisRun, int cursorsBinsThisRun, int nonEmptyBinsThisRun, int processedBinsThisRun, List cursorsBinList) {
        this.splitBins += splitBinsThisRun;
        this.dbClosedBins += dbClosedBinsThisRun;
        this.cursorsBins += cursorsBinsThisRun;
        this.nonEmptyBins += nonEmptyBinsThisRun;
        this.processedBins += processedBinsThisRun;
        this.trace(Level.FINE, splitBinsThisRun, dbClosedBinsThisRun, cursorsBinsThisRun, nonEmptyBinsThisRun, processedBinsThisRun, cursorsBinList);
    }

    private void trace(Level level, int splitBinsThisRun, int dbClosedBinsThisRun, int cursorsBinsThisRun, int nonEmptyBinsThisRun, int processedBinsThisRun, List cursorsBinList) {
        StringBuffer sb;
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            sb = new StringBuffer();
            sb.append(TRACE_COMPRESS);
            sb.append(" splitBins=").append(splitBinsThisRun);
            sb.append(" dbClosedBins=").append(dbClosedBinsThisRun);
            sb.append(" cursorsBins=").append(cursorsBinsThisRun);
            sb.append(" nonEmptyBins=").append(nonEmptyBinsThisRun);
            sb.append(" processedBins=").append(processedBinsThisRun);
            logger.log(level, sb.toString());
        }
        if (logger.isLoggable(Level.FINEST)) {
            sb = new StringBuffer();
            sb.append("cursorBinList:");
            int i = 0;
            while (i < cursorsBinList.size()) {
                sb.append((Long)cursorsBinList.get(i)).append(" ");
                ++i;
            }
            logger.log(Level.FINEST, sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sleepycat$je$incomp$INCompressor == null ? (class$com$sleepycat$je$incomp$INCompressor = INCompressor.class$("com.sleepycat.je.incomp.INCompressor")) : class$com$sleepycat$je$incomp$INCompressor).desiredAssertionStatus();
    }
}

